package com.digiwin.athena.datamap.engine.service.inner;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.engine.service.check.MechanismCheckHandler;
import com.digiwin.athena.datamap.mechanism.paradigm.DataMapParadigmService;
import com.digiwin.athena.kmservice.service.DataPickService;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import com.digiwin.athena.mechanism.achivebo.MechanismDecision;
import com.digiwin.athena.mechanism.achivebo.MechanismDecisionTarget;
import com.digiwin.athena.mechanism.widgets.CheckWidget;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2022-07-14 17:35
 **/
@Service
public class MechHelpService {

    @Autowired
    List<MechanismCheckHandler> checkHandlers;

    @Autowired
    DataPickService dataPickService;

    @Autowired
    DataMapParadigmService dataMapParadigmService;

    public boolean check(CheckWidget condition, Map data) {

        for (MechanismCheckHandler handler : checkHandlers) {
            if (handler.accept(condition)) {
                return handler.check(condition, data);
            }
        }

        return false;
    }

    public MechanismDecision getMechDecisionByDataSourceCode(String datasourcceCode) throws DWBusinessException {
        String tenantId = ServiceUtils.getTenantId();
        Query query = Query.query(Criteria.where("tenantId").is(tenantId).and("dataSource.code").is(datasourcceCode));
        MechanismDecision decision = dataPickService.tenantTemplate().findOne(query, MechanismDecision.class);
        return decision;
    }

    public List<MechanismDecisionTarget> getSuggestTargetsByIds(List<String> ids) {
        List<MechanismDecisionTarget> targets = dataPickService.tenantTemplate().find(Query.query(Criteria.where("targetId").in(ids)), MechanismDecisionTarget.class);
        return targets;
    }

    public String paradigmExpression(String mechanismCode, String dataCode) {
        String expression = dataMapParadigmService.getExpression(mechanismCode, dataCode);
        return expression;
    }

}
