package com.digiwin.athena.datamap.mechanism.activitybuilder;

import com.digiwin.athena.config.ActivityType;
import com.digiwin.athena.datamap.mechanism.support.MechanismParseContext;
import com.digiwin.athena.domain.core.Activity;
import com.digiwin.athena.mechanism.common.MechanismVariable;
import com.digiwin.athena.mechanism.widgets.ActivityWidget;
import com.digiwin.athena.mechanism.widgets.activity.VariableSetActivityWidget;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2022-07-07 09:31
 **/
@Service
@Order(1)
public class VariableSetActivityBuildService extends AbstractActivityBuildService {

    @Override
    public boolean accept(ActivityWidget ma) {
        return ActivityType.variableSet.name().equals(ma.getType());
    }

    @Override
    public void build(ActivityWidget aw, MechanismParseContext context, List<Activity> list) {
        VariableSetActivityWidget ma = super.convert(aw, VariableSetActivityWidget.class);
        if (ma.getVariables() == null) {
            return;
        }
        List<MechanismVariable> variables2 = ma.getVariables().stream().filter(v -> v.getData_name() != null).collect(Collectors.toList());
        ma.setVariables(variables2);
        if (ma.getVariables().size() == 0) {
            return;
        }

        Activity activity = list.get(0);
        for (MechanismVariable v : ma.getVariables()) {
            if (StringUtils.isEmpty(v.getPath()) || StringUtils.isEmpty(v.getData_name())) {
                continue;
            }
            if (null != v.getPath() && !v.getPath().startsWith("return")) {
                String jsPath = "return " + v.wrapperedPath();
                v.setPath(jsPath);
            }
            buildAtmcData(v.getData_name(), context);
        }
        activity.getConfig().put("variables", ma.getVariables());
    }

    public static void main(String[] args) {
        Arrays.asList("aa", "a", "aaa").stream().filter(s -> s.length() > 1).forEach(System.out::println);
    }

}
