package com.digiwin.athena.datamap.mechanism.component;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.datamap.mechanism.support.BindingContext;
import com.digiwin.athena.datamap.mechanism.support.MechanismParseContext;
import com.digiwin.athena.domain.component.ComponentTypeEnum;
import com.digiwin.athena.domain.plugin.PluginBindingPo;
import com.digiwin.athena.mechanism.bo.ControlAbilityBO;
import com.digiwin.athena.mechanism.common.MechanismAbility;
import com.digiwin.athena.mechanism.dto.MechanismApiInfoDTO;
import com.digiwin.athena.mechanism.dto.MechanismComponentDTO;
import org.springframework.stereotype.Service;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2022-07-27 13:34
 **/
@Service
public class ControlAbilityHandler extends AbstractAbilityComponentHandler {

    @Override
    public void apply(MechanismAbility ability, BindingContext context) throws DWException {
        ControlAbilityBO source = (ControlAbilityBO) ability;

        unapply(source, context);
        applyMechanismTask(source, context);

    }

    @Override
    public void unapply(MechanismAbility ability, BindingContext context) throws DWException {
        PluginBindingPo binding = PluginBindingPo.of(context.getTenantId(), context.getPluginId());
        pluginService.postRemovePlugin(binding);
    }

    public void applyMechanismTask(ControlAbilityBO mtask, BindingContext bindingContext) throws DWBusinessException {

        MechanismParseContext parseContext = buildTaskFlow(mtask, bindingContext);

        buildGateway1(mtask.getChoose(), parseContext);

        endTaskFlow(parseContext.getLastLink(), parseContext);

    }

    @Override
    public boolean accept(MechanismComponentDTO dto) {
        return ComponentTypeEnum.MechanismControl.name().equalsIgnoreCase(dto.getType());
    }

    @Override
    public Object parseScene(MechanismApiInfoDTO apiInfoDTO) {
        return null;
    }

}
