package com.digiwin.athena.datamap.mechanism.controlSourcehandlers;

import com.digiwin.app.container.exceptions.DWBusinessException;
//import com.digiwin.athena.datamap.common.MetaKey;
//import com.digiwin.athena.datamap.constant.Constants;
//import com.digiwin.athena.datamap.domain.core.DataState;
//import com.digiwin.athena.datamap.domain.core.StateMap;
//import com.digiwin.athena.datamap.domain.core.Task;
import com.digiwin.athena.datamap.mechanism.MechanismHelpService;
import com.digiwin.athena.datamap.mechanism.support.MechanismParseContext;
import com.digiwin.athena.datamap.service.inner.DataMapPickService;
import com.digiwin.athena.datamap.service.inner.PluginService;
import com.digiwin.athena.domain.core.Task;
import com.digiwin.athena.mechanism.common.MechanismAbility;
import com.digiwin.athena.mechanism.common.MechanismCheckSourceType;
import com.digiwin.athena.mechanism.widgets.SourceWidget;
import com.digiwin.athena.mechanism.widgets.source.TaskSourceWidget;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2022-08-05 19:38
 **/
@Service
public class ControlTaskSourceHandler extends AbstractControlSourceHandler {

    @Autowired
    DataMapPickService dataPickService;

    @Autowired
    PluginService pluginService;

    @Autowired
    @Qualifier("dataMapSystem")
    MongoTemplate mongoTemplate;

    @Autowired
    MechanismHelpService mechanismHelpService;

    @Override
    public boolean accept(SourceWidget source) {
        return MechanismCheckSourceType.taskSource.name().equals(source.getType());
    }

    @Override
    public void parse(SourceWidget source, MechanismParseContext context) throws DWBusinessException {
        Task task1 = context.getTask();
        MechanismAbility mtask = context.getBo();
        TaskSourceWidget taskSource = dataPickService.convert(source, TaskSourceWidget.class);
        context.setSourceWidget(taskSource);
        task1.setScheduleRule(mtask.getCheckSource().getScheduleRule());
        mtask.setCheckSource(taskSource);
        task1.setMasterCode(taskSource.getTarget());
        task1.setAssistantExecuteTime(taskSource.getExecuteTime());

        // Task masterTask = dataPickService.findBetter(task1.getMasterCode(),Task.class);
        // if(null!=masterTask){
        // task1.setInputVariables(masterTask.getInputVariables());
        // }
        // if(null==taskSource.getStateCode()){
        // if(null!=masterTask && masterTask.getStateMaps().size()>0){
        // taskSource.setStateCode(masterTask.getStateMaps().get(0).getInput());
        // }
        // }
        // if(null!=taskSource.getStateCode()){
        // DataState state = dataPickService.findBetter(taskSource.getStateCode(),DataState.class);
        // if(null!=state){
        // DataState state1=new DataState();
        // state1.setCode(mechanismHelpService.uid());
        // state1.setDataCode(state.getDataCode());
        // state1.setTenantId(context.getBindingContext().getTenantId());
        // state1.setPluginId(context.getBindingContext().getPluginId());
        // mongoTemplate.save(state1);
        // StateMap stateMap = new StateMap();
        // stateMap.setInput(state1.getCode());
        // task1.getStateMaps().add(stateMap);
        // }
        // }
    }
}
