package com.digiwin.athena.datamap.mechanism.limithandler;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.actions.ActionConstants;
import com.digiwin.athena.datamap.mechanism.convert.DynamicFunction;
import com.digiwin.athena.datamap.mechanism.support.MechanismParseContext;
import com.digiwin.athena.datamap.spi.PresetLibraryService;
import com.digiwin.athena.mechanism.common.MechanismPlanType;
import com.digiwin.athena.mechanism.common.MechanismVariable;
import com.digiwin.athena.mechanism.widgets.choose.SingleStrategyWidget;
import com.digiwin.athena.mechanism.widgets.condition.AutoProcessCondition;
import com.digiwin.athena.mechanism.widgets.config.RuleContent;
import com.digiwin.athena.mechanism.widgets.config.RuleTrigger;
import com.digiwin.athena.mechanism.widgets.plan.AutoProcessPlan;
import com.digiwin.athena.preset.Rule;
import com.google.common.collect.ImmutableMap;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * 自动处理零件  涉及有关APC的定制  慎改
 *
 * @Author: tangJieCheng-17257
 * @Date:
 * @return:
 **/
@Service
@Slf4j
public class AutoProcessHandler extends LimitCommonUtil implements LimitHandler {

    @Autowired
    PresetLibraryService presetLibraryService;

    private static final List<String> APC_TASK_CODES = Arrays.asList("apc_team_dispatch", "apc_workShopOnline", "LaunchWorkOrderOnlineAdjustmentProject");

    @Override
    public boolean accept(SingleStrategyWidget singleStrategyWidget) {
        return singleStrategyWidget.getPositiveTarget() != null && MechanismPlanType.autoProcessPlan.name().equalsIgnoreCase(singleStrategyWidget.getPositiveTarget().getType());
    }

    @Override
    public void handler(SingleStrategyWidget singleStrategyWidget, MechanismParseContext parseContext) throws Exception {
        List<Rule> rules = buildRules(singleStrategyWidget, parseContext);
        for (Rule rule : rules) {
            presetLibraryService.saveRule(rule);
        }
    }

    private List<Rule> buildRules(SingleStrategyWidget singleStrategyWidget, MechanismParseContext parseContext) throws Exception {
        AutoProcessPlan autoProcessPlan = mechanismHelpService.convert(singleStrategyWidget.getPositiveTarget(),
                AutoProcessPlan.class);
        autoProcessPlan.setIsRelationScript(Boolean.TRUE);
        ArrayList<Rule> list = new ArrayList<>();
        // 自动处理零件生成2种规则 1 页面存在主和从时 从只读 2 从随主变化 3不必填
        autoProcessPlan.setIsRelationScript(false);
        list.add(readOnlyRule(singleStrategyWidget, parseContext, autoProcessPlan));
        String domainId = parseContext.getProjectPageTarget() == null ? parseContext.getSourceTarget() : parseContext.getProjectPageTarget();
        if (!"apc_team_dispatch".equals(domainId)) {
            list.add(requiredRule(singleStrategyWidget, parseContext, autoProcessPlan));
        }
        autoProcessPlan.setIsRelationScript(true);
        list.add(linkageModificationRuleNew(singleStrategyWidget, parseContext, autoProcessPlan));
        // "isAsync": true
        return list;
    }

    private Rule requiredRule(SingleStrategyWidget singleStrategyWidget, MechanismParseContext parseContext,
                              AutoProcessPlan autoProcessPlan) throws DWBusinessException {
        RuleContent ruleContent = JSON.parseObject(JSON.toJSONString(autoProcessPlan.getRuleContent()),
                RuleContent.class);
        AutoProcessCondition subParameter = autoProcessPlan.getSubParameter();
        AutoProcessCondition parentParameter = autoProcessPlan.getParentParameter();
        Map<String, Object> content = new HashMap<>();
        Rule rule = new Rule();
        rule.setContent(content);
        ruleCommonSet(parseContext, rule);
        RuleTrigger trigger = ruleContent.getTrigger();
        String path = subParameter.getField().getPath();
        int len = path.lastIndexOf(".");
        content.put("path", path.substring(0, len));
        content.put("schema", path.substring(len + 1));
        content.put("key", "required");
        if (autoProcessPlan.getIsAsync()) {
            content.put("checkEmptyForAsyncRequired", true);
        }

        if (autoProcessPlan.getIsAsync()) {
            trigger.setPoint("default");
            content.put("trigger", trigger);
        }
        attributeAndLang(content, subParameter.getField(), "errorMessage", "必填");
        content.put("description", "limitTaskAction");

        // 条件不同 拼接不同的if()中的内容
        Set<DynamicFunction> dynamicFunctions = new LinkedHashSet<>();
        StringBuilder sb = new StringBuilder();
        ArrayList<String> expressionList = new ArrayList<>();
        expression(singleStrategyWidget, autoProcessPlan, parseContext, dynamicFunctions, expressionList);

        if (CollectionUtils.isNotEmpty(subParameter.getConditions())) {
            String code = subParameter.getConditions().get(0).getCode();
            if (StringUtils.isNotEmpty(code)) {
                // 是主/其他制程 直接返回true 要必填
                ArrayList<String> parameter2 = new ArrayList<>();
                String subDataName = subParameter.getConditions().get(0).getData_name();
                parameter2.add("!subMap[currentControl.parent.get('" + subDataName + "').value]");
                // 如果是从对象 那接下来要判断页面是否有从对象的主对象
                ArrayList<String> parameter3 = new ArrayList<>();
                String parDataName = parentParameter.getConditions().get(0).getData_name();
                if (autoProcessPlan.getConditionPatch()) {
                    parameter3.add("currentControl.parent.get('wo_no').value==item.wo_no");
                }
                // 当前行是否为需要管控行的主制程
                String verifyWhetherTheMainProcess = "subMap[currentControl.parent.get('" + subDataName + "').value].includes(item." + parDataName + ")";
                parameter3.add(verifyWhetherTheMainProcess);
                String verifyWoProperty = "item.wo_property !== '2'";
                parameter3.add(verifyWoProperty);
                // 是否存在满足条件的主制程
                if ("apiCheck_APC".equals(autoProcessPlan.getLimitType())) {
                    // 如果设置了外部来源API 是否外部API返回的数据是需要管控行的主制程 apiDataContain为校验函数
                    expressionList.add("(controlRequired&&!apiDataContain(subMap[currentControl.parent.get('" + subDataName + "').value]))");
                } else {
                    expressionList.add("controlRequired");
                }

                // 班组派工的定制化前端js
                String controlRequiredConditionFunction;
                if ("apc_team_dispatch".equals(rule.getDomainId())) {
                    controlRequiredConditionFunction = "controlRequiredCondition_apc_team_dispatch";
                } else {
                    controlRequiredConditionFunction = "controlRequiredCondition";
                }
                dynamicFunctions.add(DynamicFunction.builder().functionName(controlRequiredConditionFunction).parameter(ImmutableMap.of(
                        "parameter1", code, "parameter2", String.join(" && ", parameter2), "parameter3", String.join(
                                " && ", parameter3)))
                        .build());
                addMechanismParameter(parseContext, code);
            }
        }

        String expression = String.join(" && ", expressionList);
        sb.append("if(").append(expression).append("){ return true}");
        String functionExp = jsExpressionConverter.dynamicFunctionExpression(dynamicFunctions);
        if (null != functionExp) {
            sb.insert(0, functionExp);
        }
        // 拼接立即执行函数结构
        sb.insert(0, "(() => {");
        sb.append("})()");
        if (autoProcessPlan.getIsAsync()) {
            trigger.setCondition(sb.toString());
        } else {
            content.put("condition", sb.toString());
        }
        return rule;
    }

    private Rule linkageModificationRule(SingleStrategyWidget singleStrategyWidget,
                                         MechanismParseContext parseContext, AutoProcessPlan autoProcessPlan) throws DWBusinessException {
        AutoProcessCondition parentParameter = autoProcessPlan.getParentParameter();
        AutoProcessCondition subParameter = autoProcessPlan.getSubParameter();
        RuleContent ruleContent = JSON.parseObject(JSON.toJSONString(autoProcessPlan.getRuleContent()),
                RuleContent.class);
        Rule rule = new Rule();
        Map<String, Object> content = new HashMap<>();
        ruleCommonSet(parseContext, rule);
        rule.setContent(content);
        RuleTrigger trigger = ruleContent.getTrigger();
        List<MechanismVariable> params = autoProcessPlan.getParams();
        if (autoProcessPlan.getIsAsync()) {
            trigger.setPoint("dataChanged");
            content.put("trigger", trigger);
        }
        if (CollectionUtils.isNotEmpty(params)) {
            String path = params.get(0).getPath();
            int len = path.lastIndexOf(".");
            content.put("path", path.substring(0, len));
            content.put("schema", path.substring(len + 1));
            content.put("key", "connection");
        } else {
            // 此零件暂时没有对应其他操作分支吧？？？？
            content.put("key", "connection");
        }
        content.put("description", "limitTaskAction");
        ArrayList<Map<String, Object>> relations = new ArrayList<>();
        Map<String, Object> relation = new HashMap<>();
        relation.put("path", subParameter.getField().getData_name());
        HashMap<String, Object> operation = new HashMap<>();
        operation.put("type", "script");

        // 条件不同 拼接不同的if()中的内容
        Set<DynamicFunction> dynamicFunctions = new LinkedHashSet<>();
        StringBuilder sb = new StringBuilder();
        ArrayList<String> expressionList = new ArrayList<>();
        // 条件生成
        expression(singleStrategyWidget, autoProcessPlan, parseContext, dynamicFunctions, expressionList);
        // 补充条件
        String code = subParameter.getConditions().get(0).getCode();
        addMechanismParameter(parseContext, code);
        String parDataName = parentParameter.getConditions().get(0).getData_name();
        String subDataName = subParameter.getConditions().get(0).getData_name();
        String sourceField = parentParameter.getField().getData_name();
        String targetField = subParameter.getField().getData_name();
        // todo 没写完 得遍历 生成条件 然后组装替换到js脚本里
        ArrayList<String> parameter2 = new ArrayList<>();
        // 是否主字段的值
        parameter2.add("parSet.includes(currentControl.parent.get('" + parDataName + "').value)");

        expressionList.add("isPar"); // 是否存在满足条件的主制程
        dynamicFunctions.add(DynamicFunction.builder().functionName("isPar").parameter(ImmutableMap.of(
                "parameter1", code, "parameter2", String.join(" && ", parameter2))).build());

        ArrayList<String> parameter3 = new ArrayList<>();
        // 从属字段 遍历找到所有从属字段的行/或者是其他是当前主对象的行 赋值被写入字段
        parameter3.add("(map[currentControl.parent.get('" + parDataName + "').value].includes(item.get('" + subDataName + "').value)||currentControl.parent.get('" + parDataName
                + "').value==item.get('" + parDataName + "').value)");
        if (autoProcessPlan.getConditionPatch()) {
            parameter3.add("currentControl.parent.get('wo_no').value==item.get('wo_no').value");
        }

        String expression = String.join(" && ", expressionList);
        sb.append("if(").append(expression).append("){");
        String functionExp = jsExpressionConverter.dynamicFunctionExpression(dynamicFunctions);
        if (null != functionExp) {
            sb.insert(0, functionExp);
        }

        // 满足了上面那些条件 开始自动赋值 其中有一个name/no互换逻辑supplementJs
        String supplementJs = complementaryLogic(targetField, sourceField);
        String replaceJs = "item.get('" + targetField + "').setValue(currentControl.parent.get('" + sourceField + "')" +
                ".value);"
                + "if(item.get('uibot_checked')!==null" +
                "&&item.get('uibot_checked')!==undefined" +
                "&&currentControl.parent.get('uibot_checked')!==null" +
                "&&currentControl.parent.get('uibot_checked')!==undefined)" +
                "{item.get('uibot_checked').setValue(currentControl.parent.get('uibot_checked').value)}"
                + supplementJs;

        // 班组派工的定制化前端js
        String autoProcessDataFunction;
        if ("apc_team_dispatch".equals(rule.getDomainId())) {
            autoProcessDataFunction = "autoProcessData_apc_team_dispatch";
        } else {
            autoProcessDataFunction = "autoProcessData";
        }
        sb.append(jsExpressionConverter.dynamicFunctionExpression(Collections.singleton(DynamicFunction.builder().functionName(autoProcessDataFunction).parameter(ImmutableMap.of(
                "parameter3", String.join(" && ", parameter3), "parameter4", replaceJs, "parameter5", subDataName)).build()))).append("}");
        // 拼接立即执行函数结构
        sb.insert(0, "(() => {");
        sb.append("})()");
        operation.put("script", sb.toString());

        relation.put("operations", Collections.singletonList(operation));
        relations.add(relation);
        content.put("relations", relations);
        return rule;
    }

    private Rule linkageModificationRuleNew(SingleStrategyWidget singleStrategyWidget,
                                            MechanismParseContext parseContext, AutoProcessPlan autoProcessPlan) throws DWBusinessException {
        String domainId = parseContext.getProjectPageTarget() == null ? parseContext.getSourceTarget() : parseContext.getProjectPageTarget();
        // 只改APC任务定制，其他任务走原来的逻辑
        if (!APC_TASK_CODES.contains(domainId)) {
            return linkageModificationRule(singleStrategyWidget, parseContext, autoProcessPlan);
        }
        AutoProcessCondition parentParameter = autoProcessPlan.getParentParameter();
        AutoProcessCondition subParameter = autoProcessPlan.getSubParameter();
        RuleContent ruleContent = JSON.parseObject(JSON.toJSONString(autoProcessPlan.getRuleContent()),
                RuleContent.class);
        Rule rule = new Rule();
        Map<String, Object> content = new HashMap<>();
        ruleCommonSet(parseContext, rule);
        rule.setContent(content);

        List<MechanismVariable> params = autoProcessPlan.getParams();
        RuleTrigger trigger = ruleContent.getTrigger();
        if (autoProcessPlan.getIsAsync()) {
            String parameterScript = trigger.getParameterScript();
            parameterScript = parameterScript.replace(ActionConstants.bm_dsc_wo_op_dispatch_get, ActionConstants.bm_dsc_wo_op_dispatch_get_connection_rule)
                    .replace("day_plan_data", "apc_day_plan_data")
                    .replace(ActionConstants.bm_dpsc_working_day_plan_get, ActionConstants.apc_working_day_plan_dispatch_info_get);
            trigger.setParameterScript(parameterScript);
            trigger.setPoint("dataChanged");
            content.put("trigger", trigger);
        }
        if (CollectionUtils.isNotEmpty(params)) {
            String path = params.get(0).getPath();
            int len = path.lastIndexOf(".");
            content.put("path", path.substring(0, len));
            content.put("schema", path.substring(len + 1));
            content.put("key", "connection");
        } else {
            // 此零件暂时没有对应其他操作分支吧？？？？
            content.put("key", "connection");
        }
        content.put("description", "limitTaskAction");
        ArrayList<Map<String, Object>> relations = new ArrayList<>();
        Map<String, Object> relation = new HashMap<>();
        relation.put("path", subParameter.getField().getData_name());
        HashMap<String, Object> operation = new HashMap<>();
        operation.put("type", "script");

        // 条件不同 拼接不同的if()中的内容
        Set<DynamicFunction> dynamicFunctions = new LinkedHashSet<>();
        StringBuilder sb = new StringBuilder();
        ArrayList<String> expressionList = new ArrayList<>();
        // 条件生成
        expression(singleStrategyWidget, autoProcessPlan, parseContext, dynamicFunctions, expressionList);
        // 补充条件
        String code = subParameter.getConditions().get(0).getCode();
        addMechanismParameter(parseContext, code);
        // changed_op_no
        String parDataName = parentParameter.getConditions().get(0).getData_name();
        // changed_op_no
        String subDataName = subParameter.getConditions().get(0).getData_name();
        // area_name
        String sourceField = parentParameter.getField().getData_name();
        // area_name
        String targetField = subParameter.getField().getData_name();
        // 班组派工的定制化前端js
        String autoProcessDataFunction;
        if ("LaunchWorkOrderOnlineAdjustmentProject".equals(domainId)) {
            autoProcessDataFunction = "LaunchWorkOrderOnlineAdjustmentProject";
        } else if ("apc_workShopOnline".equals(rule.getDomainId())) {
            autoProcessDataFunction = "apc_workShopOnline_new";
        } else {
            autoProcessDataFunction = "autoProcessData_apc_team_dispatch_new";
        }

        sb.append(jsExpressionConverter.dynamicFunctionExpression(Collections.singleton(DynamicFunction.builder().functionName(autoProcessDataFunction).parameter(ImmutableMap.of(
                "parameter1", parDataName, "parameter2", subDataName, "parameter3", sourceField, "parameter4", targetField)).build())));
        // 拼接立即执行函数结构
        sb.insert(0, "(() => {");
        sb.append("})()");
        operation.put("script", sb.toString());

        relation.put("operations", Collections.singletonList(operation));
        relations.add(relation);
        content.put("relations", relations);
        return rule;
    }

    private String complementaryLogic(String targetField, String sourceField) {
        String targetFieldLink = null;
        String sourceFieldLink = null;
        if (targetField.endsWith("_no")) {
            targetFieldLink = targetField.replace("_no", "_name");
        }
        if (targetField.endsWith("_name")) {
            targetFieldLink = targetField.replace("_name", "_no");
        }
        if (sourceField.endsWith("_no")) {
            sourceFieldLink = sourceField.replace("_no", "_name");
        }
        if (sourceField.endsWith("_name")) {
            sourceFieldLink = sourceField.replace("_name", "_no");
        }
        if (StringUtils.isNotEmpty(targetFieldLink) && StringUtils.isNotEmpty(sourceFieldLink)) {
            return "if (item.get('" + targetFieldLink + "') !== null && item.get('" + targetFieldLink + "') !== " +
                    "undefined && currentControl.parent.get('" + sourceFieldLink +
                    "') !== null && currentControl.parent.get('" + sourceFieldLink +
                    "') !== undefined) {item.get('" + targetFieldLink + "').setValue(currentControl.parent.get('" + sourceFieldLink + "').value);}";
        }
        return "";
    }

    private Rule readOnlyRule(SingleStrategyWidget singleStrategyWidget, MechanismParseContext parseContext,
                              AutoProcessPlan autoProcessPlan) throws DWBusinessException {
        RuleContent ruleContent = JSON.parseObject(JSON.toJSONString(autoProcessPlan.getRuleContent()),
                RuleContent.class);
        AutoProcessCondition subParameter = autoProcessPlan.getSubParameter();
        AutoProcessCondition parentParameter = autoProcessPlan.getParentParameter();
        Rule rule = new Rule();
        Map<String, Object> content = new HashMap<>();
        rule.setContent(content);
        ruleCommonSet(parseContext, rule);

        RuleTrigger trigger = ruleContent.getTrigger();

        String path = subParameter.getField().getPath();
        int len = path.lastIndexOf(".");
        content.put("path", path.substring(0, len));
        content.put("schema", path.substring(len + 1));
        content.put("key", "disabled");
        if (autoProcessPlan.getIsAsync()) {
            trigger.setPoint("default");
            content.put("trigger", trigger);
        }
        content.put("description", "limitTaskAction");
        // trigger.setType("sync");
        // 条件不同 拼接不同的if()中的内容
        Set<DynamicFunction> dynamicFunctions = new LinkedHashSet<>();
        StringBuilder sb = new StringBuilder();
        ArrayList<String> expressionList = new ArrayList<>();
        expression(singleStrategyWidget, autoProcessPlan, parseContext, dynamicFunctions, expressionList);

        if (CollectionUtils.isNotEmpty(subParameter.getConditions())) {
            String code = subParameter.getConditions().get(0).getCode();
            if (StringUtils.isNotEmpty(code)) {
                // todo 没写完 得遍历 生成条件 然后组装替换到js脚本里
                ArrayList<String> parameter2 = new ArrayList<>();
                String subDataName = subParameter.getConditions().get(0).getData_name();
                parameter2.add("!subMap[currentControl.parent.get('" + subDataName + "').value]");

                ArrayList<String> parameter3 = new ArrayList<>();
                String parDataName = parentParameter.getConditions().get(0).getData_name();
                if (autoProcessPlan.getConditionPatch()) {
                    // 制令上线调整发起项目中 要求同工单号
                    parameter3.add("currentControl.parent.get('wo_no').value==item.wo_no");
                }
                // 当前行是否为需要管控行的主制程
                String verifyWhetherTheMainProcess = "subMap[currentControl.parent.get('" + subDataName + "').value]" +
                        ".includes(item." + parDataName + ")";
                parameter3.add(verifyWhetherTheMainProcess);
                String verifyWoProperty = "item.wo_property !== '2'";
                parameter3.add(verifyWoProperty);
                // 是否存在满足条件的主制程
                if ("apiCheck_APC".equals(autoProcessPlan.getLimitType())) {
                    // 如果设置了外部来源API 是否外部API返回的数据是需要管控行的主制程 apiDataContain为校验函数
                    expressionList.add("(controlReadOnly||apiDataContain(subMap[currentControl.parent.get('" + subDataName + "').value]))");
                } else {
                    expressionList.add("controlReadOnly");
                }

                // 班组派工的定制化前端js
                String controlReadOnlyFunction;
                if ("apc_team_dispatch".equals(rule.getDomainId())) {
                    controlReadOnlyFunction = "controlReadOnlyCondition_apc_team_dispatch";
                } else {
                    controlReadOnlyFunction = "controlReadOnlyCondition";
                }
                dynamicFunctions.add(DynamicFunction.builder().functionName(controlReadOnlyFunction).parameter(ImmutableMap.of(
                        "parameter1", code, "parameter2", String.join(" && ", parameter2), "parameter3", String.join(
                                " && ", parameter3)))
                        .build());
                addMechanismParameter(parseContext, code);
            }
        }

        String expression = String.join(" && ", expressionList);
        sb.append("if(").append(expression).append("){ return true}");
        String functionExp = jsExpressionConverter.dynamicFunctionExpression(dynamicFunctions);
        if (null != functionExp) {
            sb.insert(0, functionExp);
        }
        // 拼接立即执行函数结构
        sb.insert(0, "(() => {");
        sb.append("})()");
        if (autoProcessPlan.getIsAsync()) {
            trigger.setCondition(sb.toString());
        } else {
            content.put("condition", sb.toString());
        }
        return rule;
    }
}
