package com.digiwin.athena.datamap.mechanism.limithandler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWBusinessException;
//import com.digiwin.athena.common.DataType;
//import com.digiwin.athena.common.OpType;
//import com.digiwin.athena.datamap.domain.TenantObjectAdaptation;
//import com.digiwin.athena.datamap.domain.core.Project;
//import com.digiwin.athena.datamap.domain.core.Task;
//import com.digiwin.athena.datamap.domain.view.PageView;
import com.digiwin.athena.config.DataType;
import com.digiwin.athena.config.OpType;
import com.digiwin.athena.datamap.mechanism.MechanismHelpService;
import com.digiwin.athena.datamap.mechanism.support.MechanismParseContext;
import com.digiwin.athena.datamap.service.inner.DataMapPickService;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import com.digiwin.athena.domain.core.Project;
import com.digiwin.athena.domain.core.Task;
import com.digiwin.athena.domain.core.TenantObjectAdaptation;
import com.digiwin.athena.domain.core.view.PageView;
import com.digiwin.athena.kmservice.service.DataPickService;
import com.digiwin.athena.mechanism.common.MechanismPlanType;
import com.digiwin.athena.mechanism.widgets.SourceWidget;
import com.digiwin.athena.mechanism.widgets.choose.SingleStrategyWidget;
import com.digiwin.athena.mechanism.widgets.config.ButtonInfo;
import com.digiwin.athena.mechanism.widgets.plan.ButtonLimit;
import com.jayway.jsonpath.JsonPath;
import io.seata.common.util.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 生成pageViewAdaptation数据
 *
 **/
@Service
public class ButtonLimitHandler implements LimitHandler {

    public static final String TASK_BUTTON_PATH_PREFIX = "$.pages.task-detail";
    public static final String PROJECT_BUTTON_PATH_PREFIX = "$.pages.project-detail";

    @Autowired
    MechanismHelpService mechanismHelpService;

    @Autowired
    DataMapPickService dataPickService;

    @Autowired
    @Qualifier("dataMapSystem")
    MongoTemplate mongoTemplate;

    @Override
    public boolean accept(SingleStrategyWidget singleStrategyWidget) {
        return singleStrategyWidget.getPositiveTarget() != null && MechanismPlanType.buttonLimit.name().equalsIgnoreCase(singleStrategyWidget.getPositiveTarget().getType());
    }

    @Override
    @Transactional
    public void handler(SingleStrategyWidget singleStrategyWidget, MechanismParseContext parseContext) {
        String tenantId = null;
        try {
            tenantId = ServiceUtils.getTenantId();
        } catch (DWBusinessException e) {
            throw new RuntimeException("getTenantId error:" + e.getMessage());
        }

        String conditionScript = mechanismHelpService.toExpression(singleStrategyWidget.getCondition(), parseContext);
        String pageCode = this.findPageCode(parseContext.getSourceWidget());

        ButtonLimit buttonLimit = mechanismHelpService.convert(singleStrategyWidget.getPositiveTarget(), ButtonLimit.class);
        List<ButtonInfo> buttons = buttonLimit.getButtons();
        if (!CollectionUtils.isEmpty(buttons)) {
            List<TenantObjectAdaptation> adaptations = new ArrayList<>();
            for (ButtonInfo buttonInfo : buttons) {
                String path = this.getPath(buttonInfo, parseContext.getSourceWidget().getType());

                TenantObjectAdaptation tenantObjectAdaptation = new TenantObjectAdaptation();
                tenantObjectAdaptation.setCode(pageCode);
                tenantObjectAdaptation.setTenantId(tenantId);
                tenantObjectAdaptation.setPluginId(parseContext.getBindingContext().getPluginId());
                tenantObjectAdaptation.setPath(path);
                if (StringUtils.isEmpty(buttonLimit.getAction()) || StringUtils.equals(buttonLimit.getAction(), "disable")) {
                    tenantObjectAdaptation.setValue("!(" + conditionScript + ")");
                } else {
                    tenantObjectAdaptation.setValue(conditionScript);
                }
                tenantObjectAdaptation.setDateType(DataType.string);
                tenantObjectAdaptation.setOp(OpType.put);
                tenantObjectAdaptation.setAttribute("condition");

                adaptations.add(tenantObjectAdaptation);

                if (StringUtils.isEmpty(buttonLimit.getTrigger()) || StringUtils.equals(buttonLimit.getTrigger(), "dataChanged")) {
                    // 当是init时，可以不添加属性， 小ai默认不配置时为init 参考：https://vjvh2n48ag.feishu.cn/wiki/wikcn9NodTGd7bNGsJRn0P9hWIf
                    TenantObjectAdaptation tenantObjectAdaptation2 = new TenantObjectAdaptation();
                    BeanUtils.copyProperties(tenantObjectAdaptation, tenantObjectAdaptation2);
                    tenantObjectAdaptation2.setValue("dataChanged");
                    tenantObjectAdaptation2.setAttribute("trigger");
                    adaptations.add(tenantObjectAdaptation2);
                }

            }

            Query query = new Query();
            query.addCriteria(Criteria.where("pluginId").is(parseContext.getBindingContext().getPluginId()).and("tenantId").is(tenantId).and("code").is(pageCode));
            dataPickService.tenantTemplate().remove(query, DataPickService.tableTenantObjectAdaptation(PageView.class));
            dataPickService.tenantTemplate().insert(adaptations, DataPickService.tableTenantObjectAdaptation(PageView.class));
        }

    }

    private String getPath(ButtonInfo buttonInfo, String checkSourceType) {
        StringBuilder sb = new StringBuilder();
        sb.append(".dataStates[?(@.code == '" + buttonInfo.getDataStateCode() + "')]")
                .append(".").append(buttonInfo.getButtonType()).append("[?(@.title == '" + buttonInfo.getTitle() + "'");
        if (StringUtils.isNotEmpty(buttonInfo.getMode())) {
            sb.append(" && @.mode == '" + buttonInfo.getMode() + "'");
        }
        if (StringUtils.isNotEmpty(buttonInfo.getApplyToField())) {
            sb.append(" && @.applyToField == '" + buttonInfo.getApplyToField() + "'");
        }
        sb.append(")]");

        if ("taskSource".equalsIgnoreCase(checkSourceType)) {
            return TASK_BUTTON_PATH_PREFIX + sb.toString();
        }

        if ("projectSource".equalsIgnoreCase(checkSourceType)) {
            return PROJECT_BUTTON_PATH_PREFIX + sb.toString();
        }

        return null;
    }

    private String findPageCode(SourceWidget sourceWidget) {
        try {
            if ("taskSource".equalsIgnoreCase(sourceWidget.getType())) {
                Task sourceTask = this.dataPickService.findBetter(sourceWidget.getTarget(), Task.class);
                if (sourceTask == null) {
                    throw new RuntimeException("findPageCode error, not found task:" + sourceWidget.getTarget());
                }
                return sourceTask.getPageCode();
            }

            if ("projectSource".equalsIgnoreCase(sourceWidget.getType())) {
                Project sourceProject = this.dataPickService.findBetter(sourceWidget.getTarget(), Project.class);
                if (sourceProject == null) {
                    throw new RuntimeException("findPageCode error, not found project:" + sourceWidget.getTarget());
                }
                return sourceProject.getPageCode();
            }
        } catch (DWBusinessException e) {
            e.printStackTrace();
            throw new RuntimeException("findPageCode error:" + e.getMessage());
        }

        return null;
    }

    public static void main(String[] args) {

        try {
            Map map = new HashMap();
            map.put("id", "1001");
            map.put("title", "title1");
            map.put("mode", "all");

            Map map2 = new HashMap();
            map2.put("id", "1002");
            map2.put("title", "title2");
            map2.put("mode", "line");

            List list = new ArrayList();
            list.add(map);
            list.add(map2);

            Map map3 = new HashMap();
            map3.put("operations", list);
            map3.put("code", "waitting");

            List list2 = new ArrayList();
            list2.add(map3);

            Map map5 = new HashMap();
            map5.put("dataStates", list2);

            Map map6 = new HashMap();
            map6.put("task-Detail", map5);

            Map map7 = new HashMap();
            map7.put("pages", map6);

            // System.out.println(JSON.toJSONString(map6));
            System.out.println("map6==>" + map7);

            // Map map4 = new HashMap();
            // map4.put("disableScript", "script");
            // System.out.println("map3==>" + map3);
            // Object read = JsonPath.parse(map3).read("$.operations[?(@.id == '1001')]");
            // System.out.println(read);
            // JsonPath.parse(map3).put("$.operations[0]", "disableScript", "script");
            // System.out.println(map3);
            // System.out.println("=================================");

            JsonPath.parse(map7).put("$.pages.task-Detail.dataStates[*].operations[?(@.id == '1001' && @.mode == 'all')]", "disableScript", "script...");
            // JsonPath.parse(map6).put("$.taskDetail.dataStates[0:].operations[?(@.id == '1002')]","disableScript", "script2...");
            JsonPath.parse(map7).put("$.pages.task-Detail.dataStates[?(@.code == 'waitting')].operations[?(@.id == '1002')]", "disableScript", "script2...");
            System.out.println(map7);

            ButtonInfo info = new ButtonInfo();
            info.setDataStateCode("waitting");
            info.setButtonType("submitActions");
            info.setTitle("提交");

            System.out.println(new ButtonLimitHandler().getPath(info, "taskSource"));

            ButtonInfo info2 = new ButtonInfo();
            info2.setDataStateCode("waitting");
            info2.setButtonType("operations");
            info2.setMode("all");
            info2.setTitle("保存");

            System.out.println(new ButtonLimitHandler().getPath(info2, "taskSource"));
            System.out.println(new ButtonLimitHandler().getPath(info2, "projectSource"));

        } catch (Exception ex) {
            ex.printStackTrace();
        }

        PageView pageView = new PageView();
        pageView.setCode("code01");
        pageView.setVersion("v1");
        JSONObject jsonObject = JSON.parseObject(JSON.toJSONString(pageView));
        System.out.println(jsonObject);
        JsonPath.parse(jsonObject).set("$.code", "code2");
        JsonPath.parse(jsonObject).set("$.version", "v2");

        System.out.println(jsonObject);

    }

}
