package com.digiwin.athena.datamap.mechanism.limithandler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
//import com.digiwin.athena.common.DataType;
//import com.digiwin.athena.common.OpType;
//import com.digiwin.athena.common.component.ComponentTypeEnum;
//import com.digiwin.athena.datamap.domain.TenantObjectAdaptation;
//import com.digiwin.athena.datamap.domain.action.ActionParam;
//import com.digiwin.athena.datamap.domain.view.PageView;
//import com.digiwin.athena.datamap.dto.MultiLanguageDTO;
import com.digiwin.athena.config.DataType;
import com.digiwin.athena.config.OpType;
import com.digiwin.athena.datamap.mechanism.MechanismHelpService;
import com.digiwin.athena.datamap.mechanism.convert.*;
import com.digiwin.athena.datamap.mechanism.support.BindingContext;
import com.digiwin.athena.datamap.mechanism.support.MechanismParseContext;
import com.digiwin.athena.datamap.service.inner.DataMapPickService;
import com.digiwin.athena.datamap.spi.DataMapKgService;
import com.digiwin.athena.domain.component.ComponentTypeEnum;
import com.digiwin.athena.domain.core.TenantObjectAdaptation;
import com.digiwin.athena.domain.core.view.PageView;
import com.digiwin.athena.domain.definition.actions.ActionParam;
import com.digiwin.athena.dto.MultiLanguageDTO;
import com.digiwin.athena.kmservice.service.DataPickService;
import com.digiwin.athena.mechanism.bo.LimitAbilityBo;
import com.digiwin.athena.mechanism.common.JsExpressionType;
import com.digiwin.athena.mechanism.common.MechanismEnum;
import com.digiwin.athena.mechanism.common.MechanismPlanType;
import com.digiwin.athena.mechanism.common.MechanismVariable;
import com.digiwin.athena.mechanism.widgets.SourceWidget;
import com.digiwin.athena.mechanism.widgets.choose.SingleStrategyWidget;
import com.digiwin.athena.mechanism.widgets.plan.LimitPlan;
import com.digiwin.athena.mechanism.widgets.plan.ReminderPlan;
import com.digiwin.athena.preset.PresetDomainEnum;
import com.digiwin.athena.preset.Rule;
import com.google.common.collect.ImmutableMap;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import java.util.*;

/**
 * @author tang jie cheng
 * @date 2023-05-11 16:25
 */
@Service
@Slf4j
public class LimitCommonUtil {

    @Autowired
    JsExpressionConverter jsExpressionConverter;
    @Autowired
    MechanismHelpService mechanismHelpService;
    @Autowired
    DataMapKgService dataMapKgService;
    @Autowired
    @Qualifier("dataMapSystem")
    MongoTemplate mongoTemplate;
    @Autowired
    HooksConverter hooksConverter;

    @Autowired
    DataPickService dataPickService;

    public void addMechanismParameter(MechanismParseContext parseContext, String code) {
        BindingContext bindingContext = parseContext.getBindingContext();
        SourceWidget sourceWidget = parseContext.getSourceWidget();
        // if ("dataEntrySource".equals(sourceWidget.getType())) {
        // kgService.addActionsByPluginId(sourceWidget.getTarget(), code,
        // bindingContext.getPluginId());
        // }
        if ("taskSource".equals(sourceWidget.getType())) {
            TenantObjectAdaptation tenantObjectAdaptation = new TenantObjectAdaptation();
            tenantObjectAdaptation.setExt(new HashMap<>());
            tenantObjectAdaptation.setTenantId(bindingContext.getTenantId());
            tenantObjectAdaptation.setPluginId(bindingContext.getPluginId());
            tenantObjectAdaptation.setCode(sourceWidget.getTarget());
            tenantObjectAdaptation.setDateType(DataType.array);
            tenantObjectAdaptation.setOp(OpType.add);
            tenantObjectAdaptation.setType("TM_VARIABLE");
            String path = "$.pages.task-detail.dataStates[0].submitActions[0].actionParams";
            tenantObjectAdaptation.setPath(path);
            tenantObjectAdaptation.setBusinessKey(ComponentTypeEnum.MechanismLimit.name());
            ActionParam actionParam = new ActionParam();
            actionParam.setName(code);
            actionParam.setType("TM_VARIABLE");
            actionParam.setValue(code);
            actionParam.setPluginId(bindingContext.getPluginId());
            tenantObjectAdaptation.setValue(actionParam);
            dataPickService.tenantTemplate().save(tenantObjectAdaptation, DataMapPickService.tableTenantObjectAdaptation(PageView.class));
        }
        if ("projectSource".equals(sourceWidget.getType())) {
            TenantObjectAdaptation tenantObjectAdaptation = new TenantObjectAdaptation();
            tenantObjectAdaptation.setExt(new HashMap<>());
            tenantObjectAdaptation.setTenantId(bindingContext.getTenantId());
            tenantObjectAdaptation.setPluginId(bindingContext.getPluginId());
            tenantObjectAdaptation.setCode(sourceWidget.getTarget());
            tenantObjectAdaptation.setDateType(DataType.object);
            tenantObjectAdaptation.setOp(OpType.put);
            tenantObjectAdaptation.setAttribute(ComponentTypeEnum.MechanismVariable.name());
            tenantObjectAdaptation.setBusinessKey(ComponentTypeEnum.MechanismLimit.name());
            tenantObjectAdaptation.setType("TM_VARIABLE");
            String path = "$.pages.task-detail";
            tenantObjectAdaptation.setPath(path);
            ActionParam actionParam = new ActionParam();
            actionParam.setName(code);
            actionParam.setType("TM_VARIABLE");
            actionParam.setValue(code);
            actionParam.setPluginId(bindingContext.getPluginId());
            tenantObjectAdaptation.setValue(actionParam);
            dataPickService.tenantTemplate().save(tenantObjectAdaptation, DataMapPickService.tableTenantObjectAdaptation(PageView.class));
        }
    }

    /**
     * 根据pluginId 和 tenantId删除定制补充新
     * @param tenantId 租户id
     * @param pluginId 插件id
     * @throws DWException
     */
    public void postRemovePlugin(String tenantId, String pluginId) throws DWException {
        Query queryDelete = Query.query(Criteria.where("tenantId").is(tenantId).and("pluginId").in(pluginId));
        dataPickService.tenantTemplate().remove(queryDelete, DataMapPickService.tableTenantObjectAdaptation(PageView.class));
    }

    /**
     * 新增机制参数
     *
     * @param parseContext
     * @param hooksInfoAll
     * @param pageView
     * @param bo
     */
    public void addMechanismParameter(LimitAbilityBo bo, MechanismParseContext parseContext, HooksInfo hooksInfoAll, PageView pageView) {
        BindingContext bindingContext = parseContext.getBindingContext();
        SourceWidget sourceWidget = parseContext.getSourceWidget();
        List<String> operationTypes = bo.getCheckSource().getOperationTypes();
        String operationType = operationTypes.get(0);
        if ("taskSource".equals(sourceWidget.getType())) {
            TenantObjectAdaptation tenantObjectAdaptation = new TenantObjectAdaptation();
            tenantObjectAdaptation.setExt(new HashMap<>());
            tenantObjectAdaptation.setTenantId(bindingContext.getTenantId());
            tenantObjectAdaptation.setPluginId(bindingContext.getPluginId());
            tenantObjectAdaptation.setCode(sourceWidget.getTarget());
            tenantObjectAdaptation.setType("TM_VARIABLE");
            tenantObjectAdaptation.setBusinessKey(ComponentTypeEnum.MechanismDecision.name());
            String partPath = "";
            String wholePath = "";
            Boolean isNeedObject;
            if (operationType.equalsIgnoreCase("click")) {
                partPath = "$.pages.task-detail.dataStates[0].submitActions[?(@.actionId == '" + operationTypes.get(1) + "')].hooks";
                wholePath = "$.pages.task-detail.dataStates[0].submitActions[?(@.actionId == '" + operationTypes.get(1) + "')].hooks";
                isNeedObject = Boolean.TRUE;
                buildPageAdaptation(pageView, tenantObjectAdaptation, hooksInfoAll,
                        "$.pages.task-detail.dataStates[?(@.code == 'waitting')]", "$.pages.task-detail.dataStates[0].hooks", Boolean.FALSE);
                dataPickService.tenantTemplate().save(tenantObjectAdaptation, DataMapPickService.tableTenantObjectAdaptation(PageView.class));
            } else {
                partPath = "$.pages.task-detail.dataStates[?(@.code == 'waitting')]";
                wholePath = "$.pages.task-detail.dataStates[0].hooks";
                isNeedObject = Boolean.FALSE;
            }
            buildPageAdaptation(pageView, tenantObjectAdaptation, hooksInfoAll, partPath, wholePath, isNeedObject);
            dataPickService.tenantTemplate().save(tenantObjectAdaptation, DataMapPickService.tableTenantObjectAdaptation(PageView.class));
        }

        if ("projectSource".equals(sourceWidget.getType())) {
            TenantObjectAdaptation tenantObjectAdaptation = new TenantObjectAdaptation();
            tenantObjectAdaptation.setExt(new HashMap<>());
            tenantObjectAdaptation.setTenantId(bindingContext.getTenantId());
            tenantObjectAdaptation.setPluginId(bindingContext.getPluginId());
            tenantObjectAdaptation.setCode(sourceWidget.getTarget());
            tenantObjectAdaptation.setType("TM_VARIABLE");
            tenantObjectAdaptation.setBusinessKey(ComponentTypeEnum.MechanismDecision.name());
            String partPath = "";
            String wholePath = "";
            Boolean isNeedObject;
            if (operationType.equalsIgnoreCase("click")) {
                partPath = "$.pages.task-detail.dataStates[0].submitActions[?(@.actionId == '" + operationTypes.get(1) + "')]";
                isNeedObject = Boolean.TRUE;
                buildPageAdaptation(pageView, tenantObjectAdaptation, hooksInfoAll,
                        "$.pages.task-detail.dataStates[?(@.code == 'waitting')]", "$.pages.task-detail.dataStates[0].hooks", Boolean.FALSE);
                dataPickService.tenantTemplate().save(tenantObjectAdaptation, DataMapPickService.tableTenantObjectAdaptation(PageView.class));
            } else {
                partPath = "$.pages.task-detail";
                wholePath = "$.pages.task-detail.hooks";
                isNeedObject = Boolean.FALSE;
            }
            buildPageAdaptation(pageView, tenantObjectAdaptation, hooksInfoAll, partPath, wholePath, isNeedObject);
            // start 临时代码
            tenantObjectAdaptation.setCode("start_" + tenantObjectAdaptation.getCode());
            dataPickService.tenantTemplate().save(tenantObjectAdaptation, DataMapPickService.tableTenantObjectAdaptation(PageView.class));
        }
    }

    /**
     * 构建补充信息
     *
     * @param pageView
     * @param pageViewAdaptation
     * @param hooksInfoAll
     * @param partPath
     * @param wholePath
     * @param isNeedObject
     */
    private void buildPageAdaptation(PageView pageView, TenantObjectAdaptation pageViewAdaptation, HooksInfo hooksInfoAll, String partPath, String wholePath, Boolean isNeedObject) {
        JSONObject pages = new JSONObject(pageView.getPages());
        JSONArray dataStates = pages.getJSONObject("task-detail").getJSONArray("dataStates");
        JSONArray oldHooks;
        // 有些数据中含dataStates层，有些没有，此处做兼容
        if (dataStates != null && !dataStates.isEmpty()) {
            JSONObject dataState = dataStates.getJSONObject(0);
            oldHooks = dataState.getJSONArray("hooks");
        } else {
            JSONObject taskDetail = pages.getJSONObject("task-detail");
            oldHooks = taskDetail.getJSONArray("hooks");
        }
        // Step1：旧数据没有hooks，直接添加hooks
        if (ObjectUtils.isEmpty(oldHooks)) {
            pageViewAdaptation.setDateType(DataType.object);
            pageViewAdaptation.setOp(OpType.put);
            pageViewAdaptation.setPath(partPath);
            pageViewAdaptation.setAttribute("hooks");
            pageViewAdaptation.setValue(isNeedObject ? hooksConverter.buildHooks(hooksInfoAll).get(0) : hooksConverter.buildHooks(hooksInfoAll));
            return;
        }
        // Step1：旧数据有hooks，添加hooks
        pageViewAdaptation.setDateType(DataType.object);
        pageViewAdaptation.setOp("comb");
        pageViewAdaptation.setPath(wholePath);
        pageViewAdaptation.setValue(isNeedObject ? hooksConverter.buildHooks(hooksInfoAll).get(0) : hooksConverter.buildHooks(hooksInfoAll));
    }

    public void ruleCommonSet(MechanismParseContext parseContext, Rule rule) {
        rule.setApplication(parseContext.getBindingContext().getApplication());
        rule.setTenantId(parseContext.getBindingContext().getTenantId());
        rule.setPluginId(parseContext.getBindingContext().getPluginId());
        rule.setDomain(PresetDomainEnum.ACTIVITY);
        rule.setDescription(ComponentTypeEnum.MechanismLimit.name());
        rule.setDomainId(parseContext.getProjectPageTarget() == null ? parseContext.getSourceTarget() : parseContext.getProjectPageTarget());
        rule.setKey(mechanismHelpService.uid());
        // 这里别动 为了确保机制规则被小ai查的时候在最后生效
        rule.setSequence(999);
    }

    public void expression(SingleStrategyWidget singleStrategyWidget, LimitPlan plan, MechanismParseContext parseContext,
                           Set<DynamicFunction> dynamicFunctions, ArrayList<String> expressionList) throws DWBusinessException {
        expressionList.add("true");
        boolean relationScript = plan.getIsRelationScript();
        String apiData = apiData(plan, relationScript);
        switch (plan.getLimitType()) {
            // 默认类型 无时机
            case "default":
                break;
            case "proficiency":
                String cond = "";
                // 旧逻辑
                if (!ObjectUtils.isEmpty(singleStrategyWidget.getPersonnelCondition().getPerformerValue())) {
                    cond = apiData + ".count < " + singleStrategyWidget.getPersonnelCondition().getPerformerValue();
                } else {
                    String type = singleStrategyWidget.getPersonnelCondition().getProficiencyType().name();
                    if (MechanismEnum.OperateType.EQ.getCode().equalsIgnoreCase(type)) {
                        cond = apiData + ".count " + " = " + Integer.valueOf(singleStrategyWidget.getPersonnelCondition().getToValue().toString());
                    }
                    if (MechanismEnum.OperateType.GT.getCode().equalsIgnoreCase(type)) {
                        cond = apiData + ".count " + " > " + Integer.valueOf(singleStrategyWidget.getPersonnelCondition().getToValue().toString());
                    }
                    if (MechanismEnum.OperateType.LT.getCode().equalsIgnoreCase(type)) {
                        cond = apiData + ".count " + " < " + Integer.valueOf(singleStrategyWidget.getPersonnelCondition().getToValue().toString());
                    }
                    if (MechanismEnum.OperateType.GTE.getCode().equalsIgnoreCase(type)) {
                        cond = apiData + ".count " + " >= " + Integer.valueOf(singleStrategyWidget.getPersonnelCondition().getToValue().toString());
                    }
                    if (MechanismEnum.OperateType.LTE.getCode().equalsIgnoreCase(type)) {
                        cond = apiData + ".count " + " <= " + Integer.valueOf(singleStrategyWidget.getPersonnelCondition().getToValue().toString());
                    }
                    if (MechanismEnum.OperateType.BETWEEN.getCode().equalsIgnoreCase(type)) {
                        cond = apiData + ".count " + " >= " + Integer.valueOf(singleStrategyWidget.getPersonnelCondition().getFromValue().toString()) + "&"
                                + apiData + ".count " + "<=" + Integer.valueOf(singleStrategyWidget.getPersonnelCondition().getToValue().toString());
                    }
                }
                expressionList.add("(" + cond + ")");
                break;
            case "duty":
                String performerValue = ObjectUtils.isEmpty(singleStrategyWidget.getPersonnelCondition().getPerformerValue()) ? singleStrategyWidget.getPersonnelCondition().getToValue().toString()
                        : singleStrategyWidget.getPersonnelCondition().getPerformerValue();
                String dutyValue = handleList(performerValue);
                expressionList.add("dutyMatch");
                dynamicFunctions.add(DynamicFunction.builder().functionName("dutyCondition").parameter(ImmutableMap.of("dutyParameter1", dutyValue, "dutyParameter2", apiData)).build());
                break;
            case "staff":
                String performerValueStaff =
                        ObjectUtils.isEmpty(singleStrategyWidget.getPersonnelCondition().getPerformerValue()) ? singleStrategyWidget.getPersonnelCondition().getToValue().toString()
                                : singleStrategyWidget.getPersonnelCondition().getPerformerValue();
                String result = handleList(performerValueStaff);
                expressionList.add("staffMatch");
                dynamicFunctions.add(DynamicFunction.builder().functionName("staffCondition").parameter(ImmutableMap.of("parameter", result)).build());
                break;
            case "apiCheck_APC":
                // 前端函数 入参 为主制程集合 判断apiData是否包含
                dynamicFunctions.add(DynamicFunction.builder().functionName("apiCheck_APC").parameter(ImmutableMap.of("parameter1", apiData + ".data")).build());
                break;
            case "businessCondition":
                String mechanismVersion = parseContext.getBindingContext().getMechanismVersion();
                if (null == mechanismVersion) {
                    BindingContext bindingContext = new BindingContext();
                    if (MechanismPlanType.reminderPlan.name().equals(plan.getType())) {
                        bindingContext.setJsExpressionType(JsExpressionType.taskData);
                    } else {
                        bindingContext.setJsExpressionType(JsExpressionType.currentControl);
                    }
                    JsExpression jsExpression =
                            jsExpressionConverter.convertByGroups(singleStrategyWidget.getBusinessCondition().getGroups(), bindingContext);
                    if (null != jsExpression) {
                        dynamicFunctions.addAll(jsExpression.getDynamicFunction());
                        Set<String> function = jsExpression.getFunction();
                        for (String s : function) {
                            dynamicFunctions.add(DynamicFunction.builder().functionName(s).build());
                        }
                        if (null != jsExpression.getExpression()) {
                            expressionList.add(jsExpression.getExpression());
                        }
                    }
                } else {
                    Map<String, Object> parameters = new HashMap();
                    List<Object> apiList = new ArrayList<>();
                    Map<String, Object> paramsInfo = new HashMap();
                    Map<String, Object> req = new HashMap();

                    // 场景号用法类似于api条件中的url
                    paramsInfo.put("requestJson", new Object());
                    paramsInfo.put("ability", parseContext.getBo());
                    // 内部api不需要Esp，因此设置为false
                    paramsInfo.put("isNeedEsp", Boolean.FALSE);
                    req.put("apiInfoDTO", paramsInfo);

                    parameters.put("hookApiList", apiList);
                    String parameterScript = "var result =  JSON.parse('" + JSON.toJSONString(req) + "')" +
                            ";result.tableData = currentControl.parent.parent.value; return result;";
                    ReminderPlan positiveTarget = (ReminderPlan) singleStrategyWidget.getPositiveTarget();
                    positiveTarget.getRuleContent().getTrigger().setParameterScript(parameterScript);

                    expressionList.add("(" + apiData + ".data)");
                    break;
                }
                break;
            default:
                throw new DWBusinessException("not support limitType:" + plan.getLimitType());
        }
    }

    private static String handleList(String performerValueStaff) {
        if (performerValueStaff == null) {
            return "";
        }
        String[] emails = performerValueStaff.replace("[", "").replace("]", "").replace("\"", "").split(",");
        return String.join(",", emails);
    }

    public void attributeAndLang(Map<String, Object> content, MechanismVariable variable, String attributeName, String suffix) {
        MultiLanguageDTO description = null == variable.getDescriptionLang() ? new MultiLanguageDTO() : variable.getDescriptionLang();
        description.setEn_US((StringUtils.isEmpty(description.getEn_US()) ? variable.getName() : description.getEn_US()) + suffix);
        description.setZh_CN((StringUtils.isEmpty(description.getZh_CN()) ? variable.getName() : description.getZh_CN()) + suffix);
        description.setZh_TW((StringUtils.isEmpty(description.getZh_TW()) ? variable.getName() : description.getZh_TW()) + suffix);
        if (content.containsKey("lang")) {
            Map lang = (Map) content.get("lang");
            lang.put(attributeName, description);
            content.put("lang", lang);
        } else {
            content.put("lang", ImmutableMap.of(attributeName, description));
        }
        content.put(attributeName, variable.getName() + suffix);
    }

    private String apiData(LimitPlan plan, boolean relationScript) {
        String apiData;
        if (MechanismPlanType.reminderPlan.name().equals(plan.getType())) {
            apiData = "data.data";
        } else {
            // 联动规则叫apiData 其余是data
            if (relationScript) {
                apiData = "apiData";
            } else {
                apiData = "data";
            }
        }
        return apiData;
    }

}
