package com.digiwin.athena.datamap.mechanism.limithandler;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.datamap.mechanism.convert.DynamicFunction;
import com.digiwin.athena.datamap.mechanism.support.MechanismParseContext;
import com.digiwin.athena.datamap.spi.DataMapKgService;
import com.digiwin.athena.datamap.spi.PresetLibraryService;
import com.digiwin.athena.mechanism.common.MechanismPlanType;
import com.digiwin.athena.mechanism.common.MechanismVariable;
import com.digiwin.athena.mechanism.mechanismEnum.LimitEnum;
import com.digiwin.athena.mechanism.widgets.SourceWidget;
import com.digiwin.athena.mechanism.widgets.choose.SingleStrategyWidget;
import com.digiwin.athena.mechanism.widgets.config.RuleContent;
import com.digiwin.athena.mechanism.widgets.plan.ReminderPlan;
import com.digiwin.athena.preset.Rule;
import com.google.common.collect.ImmutableMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service
public class ReminderLimitHandler extends LimitCommonUtil implements LimitHandler {

    @Autowired
    PresetLibraryService presetLibraryService;

    @Autowired
    DataMapKgService dataMapKgService;

    @Override
    public boolean accept(SingleStrategyWidget singleStrategyWidget) {
        return singleStrategyWidget.getPositiveTarget() != null && MechanismPlanType.reminderPlan.name().equalsIgnoreCase(singleStrategyWidget.getPositiveTarget().getType());
    }

    @Override
    public void handler(SingleStrategyWidget singleStrategyWidget, MechanismParseContext parseContext) throws Exception {
        Rule rule = buildRule(singleStrategyWidget, parseContext);
        presetLibraryService.saveRule(rule);
    }

    private Rule buildRule(SingleStrategyWidget singleStrategyWidget, MechanismParseContext parseContext) throws Exception {
        ReminderPlan reminderPlan = mechanismHelpService.convert(singleStrategyWidget.getPositiveTarget(),
                ReminderPlan.class);

        Rule rule = new Rule();
        Map<String, Object> content = new HashMap<>();
        rule.setContent(content);
        ruleCommonSet(parseContext, rule);
        content.put("description", "limitTaskAction");
        content.put("errorMessage", reminderPlan.getMessage());
        content.put("lang", handleLang(reminderPlan.getLang()));
        RuleContent ruleContent = reminderPlan.getRuleContent();
        SourceWidget sourceWidget = parseContext.getSourceWidget();
        String operationType = !ObjectUtils.isEmpty(sourceWidget.getOperationType()) ? sourceWidget.getOperationType() : sourceWidget.getOperationTypes().get(0);
        content.put("targetScope", "page");
        if (!"open".equals(operationType)) {
            content.put("targetScope", "operation");
            content.put("targetType", operationType);
        }

        // 条件不同 拼接不同的if()中的内容
        content.put("key", "api-trigger");

        // 开始组装condition
        Set<DynamicFunction> dynamicFunctions = new HashSet<>();
        StringBuilder sb = new StringBuilder();
        ArrayList<String> expressionList = new ArrayList<>();
        expression(singleStrategyWidget, reminderPlan, parseContext, dynamicFunctions, expressionList);

        if (LimitEnum.mechanismParameter.equals(reminderPlan.getMessageType())) {
            // 机制变量的欧博士 1 插入函数 2 去修改activityConfigs表中的配置
            expressionList.add("mechanismParameter");
            dynamicFunctions.add(DynamicFunction.builder().functionName("mechanismParameter").parameter(ImmutableMap.of(
                    "parameter1", String.valueOf(reminderPlan.getMessage()))).build());
            addMechanismParameter(parseContext, reminderPlan.getMessage().toString());
        }

        String expression = String.join(" && ", expressionList);
        sb.append("if(").append(expression).append("){");
        String functionExp = jsExpressionConverter.dynamicFunctionExpression(dynamicFunctions);
        if (null != functionExp) {
            sb.insert(0, functionExp);
        }
        // 拼接 输出欧博士
        List<MechanismVariable> variables = reminderPlan.getVariables();

        if (LimitEnum.mechanismParameter.equals(reminderPlan.getMessageType())) {
            sb.append("const oDoctorReminder = {'list': [{'msg': ").append("dynamicMechanismParameter").append("}]};" +
                    "$nlpMessage.next(oDoctorReminder);}");
        } else {
            Map<String, String> msgLangMap;
            if (reminderPlan.getLang() != null && reminderPlan.getLang().containsKey("message")) {
                msgLangMap = reminderPlan.getLang().get("message");
            } else {
                msgLangMap = initLangMsgMap(reminderPlan.getMessage());
            }
            Map<String, String> langMap = handleODoctorReminder(variables, reminderPlan, msgLangMap);
            sb.append("var processLocale = sessionStorage.getItem('language'); ")
                    .append("var msg = processLocale === 'zh_TW' ? '")
                    .append(langMap.get("zh_TW"))
                    .append("': processLocale === 'en_US' ? '")
                    .append(langMap.get("en_US")).append("':'")
                    .append(langMap.get("zh_CN")).append("'; ")
                    .append("const oDoctorReminder = {'list': [{'msg': msg}]};" +
                            "$nlpMessage.next(oDoctorReminder);}");
        }
        if (null != ruleContent) {
            ruleContent.getTrigger().setCondition(sb.toString());
            content.putAll(JSON.parseObject(JSON.toJSONString(ruleContent)));
        }
        content.put("condition", sb.toString());
        return rule;
    }

    private Map<String, String> initLangMsgMap(Object message) {
        Map<String, String> result = new HashMap<>();
        if (message == null) {
            result.put("zh_CN", "");
            result.put("zh_TW", "");
            result.put("en_US", "");
            return result;
        }
        String msg = message.toString();
        result.put("zh_CN", msg);
        result.put("zh_TW", msg);
        result.put("en_US", msg);
        return result;
    }

    private Map<String, Map<String, String>> handleLang(Map<String, Map<String, String>> lang) {
        if (lang == null) {
            return Collections.emptyMap();
        }
        if (lang.containsKey("message")) {
            Map<String, Map<String, String>> result = new HashMap<>();
            result.put("errorMessage", lang.get("message"));
            result.putAll(lang);
            return result;
        }
        return lang;
    }

    private static Map<String, String> handleODoctorReminder(List<MechanismVariable> variables, ReminderPlan reminderPlan,
                                                             Map<String, String> msgLangMap) {
        Map<String, String> result = new HashMap<>();
        if (CollectionUtils.isEmpty(variables)) {
            result.putAll(msgLangMap);
            return result;
        }
        for (Map.Entry<String, String> entry : msgLangMap.entrySet()) {
            result.put(entry.getKey(), handleVariables(variables, entry.getValue()));
        }
        return result;
    }

    private static String handleVariables(List<MechanismVariable> variables, Object message) {
        String mes = String.valueOf(message);
        ArrayList<String> sbList = new ArrayList<>();
        variables.sort(Comparator.comparingInt(MechanismVariable::getIndex));
        Map<Integer, MechanismVariable> indexMap =
                variables.stream().collect(Collectors.toMap(MechanismVariable::getIndex,
                        Function.identity(), (a, b) -> b));
        int startIndex = 0;
        for (Map.Entry<Integer, MechanismVariable> entry : indexMap.entrySet()) {
            Integer index = entry.getKey();
            MechanismVariable variable = entry.getValue();
            String path = variable.getPath();
            String[] split = path.split("\\.");
            String rep = "taskData." + split[0] + "[0]." + variable.getData_name();
            sbList.add("'" + mes.substring(startIndex, index) + "'");
            sbList.add(rep);
            startIndex = index + 1;
        }
        sbList.add("'" + mes.substring(startIndex) + "'");
        return StringUtils.join(sbList, "+");
    }
}
