package com.digiwin.athena.datamap.povo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class FindTaskFromUserRequest {

    /**
     * 租户id
     */
    private String tenantId;
    /**
     * 任务类型名称
     */
    private String taskDefName;
    /**
     * 包含的业务类型
     */
    private List<String> includeCategoryList;
    /**
     * 不包含的业务类型
     */
    private List<String> excludeCategoryList;
    /**
     * 兼容驱动2.0 过滤筛选mongo task集合drivenCategory字段
     */
    private List<String> drivenCategory;
    /**
     * 应用列表
     */
    private List<String> applicationList;
    /**
     * 执行类型
     */
    private String executeType;
    /**
     * 页码
     */
    private Integer pageNum;
    /**
     * 每页数据数
     */
    private Integer pageSize;
}
