package com.digiwin.athena.datamap.povo.monitorrule;

import com.digiwin.app.container.exceptions.DWBusinessException;
import lombok.EqualsAndHashCode;

@EqualsAndHashCode(of = {"name", "type"})
public class ActionParamDTO {

    private String name;
    private ActionParamTypeEnum type;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ActionParamTypeEnum getType() {
        return type;
    }

    public void setType(ActionParamTypeEnum type) {
        this.type = type;
    }

    public static ActionParamDTO parseFromDO(ActionParamConfigDO configDO) throws DWBusinessException {
        if (configDO.getType() == ActionParamTypeEnum.FUNCTION) {
            return FunctionActionParamDTO.parseFromDO(configDO);
        } else if (configDO.getType() == ActionParamTypeEnum.COLUMN ||
                configDO.getType() == ActionParamTypeEnum.CONSTANT) {
            return ColumnActionParamDTO.parseFromDO(configDO);
        } else {
            throw new DWBusinessException("Cannot parse from from config to ActionParam");
        }
    }
}
