package com.digiwin.athena.datamap.service;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.service.DWService;
import com.digiwin.app.service.restful.DWRequestMapping;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.app.service.restful.DWRestfulService;

import java.util.List;

/**
 * 数据字段服务
 * @javadoc
 */
@DWRestfulService
public interface IDictService extends DWService {
    /**
     * 根据key获取字典信息
     * @param key 字典key
     * @return
     * @throws DWBusinessException
     */
    @DWRequestMapping(path = "/dict/dictByKey", method = {DWRequestMethod.GET})
    Object getDictByKey(String key) throws DWBusinessException;

    /**
     * 根据字典key值和code值获取数据
     * @param key 键值
     * @param code code值
     * @return
     * @throws DWBusinessException
     */
    @DWRequestMapping(path = "/dict/dictByKeyAndCode", method = {DWRequestMethod.GET})
    Object getDictByKeyAndCode(String key, String code) throws DWBusinessException;

    /**
     * 根据字典key值集合获取字典数据
     * @param keyList 键值集合
     * @return
     * @throws DWBusinessException
     */
    @DWRequestMapping(path = "/dict/findDictByKeyList", method = {DWRequestMethod.POST})
    Object postFindDictByKeyList(List<String> keyList) throws DWBusinessException;
}
