package com.digiwin.athena.datamap.service;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.service.AllowAnonymous;
import com.digiwin.app.service.DWService;
import com.digiwin.app.service.restful.DWRequestMapping;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.app.service.restful.DWRestfulService;
import com.digiwin.athena.datamap.povo.DataRequest;
import com.digiwin.athena.domain.core.MonitorRuleAdapter;
import com.digiwin.athena.domain.core.Project;
import com.digiwin.athena.domain.customBizTask.CustBizTaskConfigDTO;
import com.digiwin.athena.domain.customBizTask.CustGroupSkipCondition;
import com.digiwin.athena.dto.BasicQuery;

import java.util.List;

/**
 * 项目服务类
 * @javadoc
 */
@DWRestfulService
public interface IProjectService extends DWService {

    /**
     * 根据query条件查询项目集合
     * @param query 查询调价
     * @return 项目集合
     * @throws DWException
     */
    @DWRequestMapping(path = "/project/projects", method = {DWRequestMethod.POST})
    List<Project> postProjects(BasicQuery query) throws DWException;

    /**
     * 根据query条件查询项目
     * @param request 查询条件
     * @return 项目
     * @throws DWException
     */
    @DWRequestMapping(path = "/project/project", method = {DWRequestMethod.POST})
    Project postProject(BasicQuery request) throws DWException;

    /**
     * 根据项目code查询项目
     * @param code 项目code
     * @return 项目
     * @throws DWException
     */
    @DWRequestMapping(path = "/project/projectByCode", method = {DWRequestMethod.GET})
    Project getProjectByCode(String code) throws DWException;

    /**
     * 根据项目code设置完成时间
     * @param code 项目code
     * @return 项目
     * @throws DWException
     */
    @DWRequestMapping(path = "/project/fixProjectByCode", method = {DWRequestMethod.POST})
    Project postFixProjectByCode(String code) throws DWException;

    /**
     * 根据项目code和运营单元信息获取项目
     * @param request 查询参数
     * @return 项目
     * @throws DWException
     */
    @DWRequestMapping(path = "/project/projectByCode", method = {DWRequestMethod.POST})
    Project postProjectByCode(DataRequest request) throws DWException;

    /**
     * 根据应用code和租户id获取项目
     * @param code 应用code
     * @param tenantId 租户id
     * @return 应用数据
     * @throws DWException
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/project/projectByCode2", method = {DWRequestMethod.GET})
    Project getProjectByCode2(String code, String tenantId) throws DWException;

    // TODO liugla 2024/10/22 15:13 MonitorRuleAdapter
    /**
     * 根据数据事件id获取侦测数据
     * @param id 数据事件id
     * @return 侦测数据
     * @throws DWException
     */
    @DWRequestMapping(path = "/project/monitorConfig", method = {DWRequestMethod.GET})
    MonitorRuleAdapter getMonitorConfig(String id) throws DWException;

    /**
     * 根据鉴权前缀获取项目
     * @param authorityPrefix 鉴权前缀
     * @return 项目
     * @throws DWException
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/project/projectByAuthorityPrefix", method = {DWRequestMethod.GET})
    List<Project> getProjectByAuthorityPrefix(String authorityPrefix) throws DWException;

    /**
     * 根据应用code查询可自定义业务流项目
     *
     * @param appCode 应用code
     * @return 项目
     * @throws DWException
     */
    @DWRequestMapping(path = "/project/getCustBizProjectByApp", method = {DWRequestMethod.GET})
    List<Project> getCustBizProjectByApp(String appCode) throws DWException;

    /**
     * 根据应用code和项目code获取条件字段
     *
     * @param appCode     应用code
     * @param projectCode 项目code
     * @return 条件字段
     * @throws DWException
     */
    @DWRequestMapping(path = "/project/getCustBizField", method = {DWRequestMethod.GET})
    List<CustGroupSkipCondition> getCustBizField(String appCode, String projectCode) throws DWException;

    /**
     * 保存租户级业务流自定义配置
     *
     * @param configDTO 配置信息
     * @return 是否保存成功
     */
    @DWRequestMapping(path = "/project/saveCustBizConfig", method = {DWRequestMethod.POST})
    CustBizTaskConfigDTO saveCustBizConfig(CustBizTaskConfigDTO configDTO) throws DWException;
}
