package com.digiwin.athena.datamap.service;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.service.DWService;
import com.digiwin.app.service.restful.DWRequestMapping;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.app.service.restful.DWRestfulService;
import com.digiwin.athena.datamap.povo.SearchRequest;
import com.digiwin.athena.domain.core.app.Application;

import java.util.List;

/**
 * @program: athena2_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2022-03-09 19:16
 **/
@DWRestfulService
public interface ISearchService extends DWService {

    /**
     * 根据租户id查询租户授权应用
     * @param request 查询条件
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/search/tenantApps", method = {DWRequestMethod.POST})
    List<Application> postTenantApps(SearchRequest request) throws DWException;

    /**
     * 根据useId查询用户授权应用
     * @param request 查询条件
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/search/userApps", method = {DWRequestMethod.POST})
    List<Application> postUserApps(SearchRequest request) throws DWException;

    /**
     * 根据应用code从应用关联关系表中获取项目
     * @param request 查询条件
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/search/appProject", method = {DWRequestMethod.POST})
    Object postAppProject(SearchRequest request) throws DWException;

    /**
     * 根据应用code从应用关联关系表中获取任务
     * @param request
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/search/appTask", method = {DWRequestMethod.POST})
    Object postAppTask(SearchRequest request) throws DWException;

}
