package com.digiwin.athena.datamap.service;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.service.AllowAnonymous;
import com.digiwin.app.service.DWService;
import com.digiwin.app.service.restful.DWRequestMapping;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.app.service.restful.DWRestfulService;

import java.util.Map;

/**
 * 测试服务
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2022-05-12 16:45
 * @javadoc
 **/
@DWRestfulService
public interface ITestService extends DWService {

    /**
     * 测试方法 - 日志打印
     * @param input 输入数据
     * @return
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/test/test01", method = {DWRequestMethod.GET})
    String getTest01(String input);

    /**
     * 测试方法
     * @param input 输入数据
     * @return
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/test/test02", method = {DWRequestMethod.POST})
    Object postTest02(Map<String, Object> input);

    /**
     * 测试方法
     * @param input 输入数据
     * @return
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/test/test_neo4j", method = {DWRequestMethod.GET})
    Object getTest_neo4j(String input);

    /**
     * 测试方法 - 测试日志级别
     * @param level 日志等级
     * @return
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/test/logLevel", method = {DWRequestMethod.GET})
    String getLogLevel(String level);

    /**
     * 测试方法 - 根据code获取任务
     * @param input 输入数据
     * @return
     */
    @DWRequestMapping(path = "/test/test04", method = {DWRequestMethod.GET})
    Object getTest04(String input) throws DWBusinessException;

    /**
     * 测试方法 - 根据code获取任务
     * @param input 输入数据
     * @return
     */
    @DWRequestMapping(path = "/test/test05", method = {DWRequestMethod.GET})
    Object getTest05(String input) throws DWBusinessException;

    /**
     * 测试方法 - 设置redis中的值
     * @param key redis中的key
     * @param value redis中的value
     * @return
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/test/redisSet", method = {DWRequestMethod.GET})
    String getRedisSet(String key, String value);

    /**
     * 测试方法 - 根据key获取redis中的值
     * @param key redis中的key
     * @return
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/test/redisGet", method = {DWRequestMethod.GET})
    String getRedisGet(String key);

    @AllowAnonymous
    @DWRequestMapping(path = "/test/statics", method = {DWRequestMethod.GET})
    Object getStatics(String input);

    @AllowAnonymous
    @DWRequestMapping(path = "/test/stack", method = {DWRequestMethod.GET})
    Object getStack(String input);

}
