package com.digiwin.athena.datamap.service.inner;

import com.digiwin.athena.kmservice.utils.ServiceUtils;
import com.digiwin.athena.domain.common.BaseObject;
import com.digiwin.athena.domain.core.view.WordDict;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@Slf4j
// @Service
public class TranslateService {

    @Autowired
    @Qualifier("dataMapSystem")
    MongoTemplate mongoTemplate;

    Cache<String, Map<String, String>> langCache = Caffeine.newBuilder()
            .expireAfterWrite(24, TimeUnit.HOURS)
            .initialCapacity(2000)
            .maximumSize(10000)
            .build();

    public String translate(String key, String locale) {
        if (null != key && null != locale) {
            Map<String, String> lang = langCache.getIfPresent(key);
            if (null == lang) {
                WordDict dict = mongoTemplate.findOne(Query.query(Criteria.where("key").is(key)), WordDict.class);
                if (null != dict && null != dict.getLang()) {
                    lang = dict.getLang();
                    langCache.put(key, lang);
                }
            }
            if (null != lang) {
                String translated = lang.get(locale);
                if (null != translated) {
                    return translated;
                }
            }
        }
        return key;
    }

    public void clean() {
        langCache.cleanUp();
    }

    /*
     * todo 注意没有处理对象循环问题
     */
    public void dealLangRecusive(Object entity, String locale) {
        if (null == entity || null == locale || ServiceUtils.isPrimitive(entity.getClass())) {
            return;
        }
        if (entity instanceof BaseObject) {
            dealLang((BaseObject) entity, locale);
            dealFields(entity, locale);
        } else if (entity instanceof Collection) {
            Collection collection = (Collection) entity;
            for (Object obj : collection) {
                dealLangRecusive(obj, locale);
            }
        } else if (entity.getClass().isArray()) {
            Object[] arr = (Object[]) entity;
            for (Object obj : arr) {
                dealLangRecusive(obj, locale);
            }
        } else if (entity instanceof Map) {
            Map map = (Map) entity;
            if (map.get("lang") != null) {
                Map<String, Map> lang = (Map<String, Map>) map.get("lang");
                lang.forEach((k, m) -> {
                    if (null != m.get(locale)) {
                        map.put(k, m.get(locale));
                    } else {
                        if (null != m.get(locale.toLowerCase())) {
                            map.put(k, m.get(locale));
                        }
                    }
                });
            }
            Map translatedMap = new HashMap();
            map.forEach((k, v) -> {
                if (v instanceof String) {
                    String translated = translateWord((String) v, locale);
                    if (null != translated) {
                        translatedMap.put(k, translated);
                    }
                }
                dealLangRecusive(v, locale);
            });
            map.putAll(translatedMap);
        } else {
            // 复合类型
            dealFields(entity, locale);
        }

    }

    private void dealFields(Object entity, String locale) {
        List<Field> fields = ServiceUtils.getFields(entity.getClass());
        for (Field f : fields) {
            f.setAccessible(true);
            try {
                Object obj = f.get(entity);
                if (obj instanceof String) {
                    String translated = translateWord((String) obj, locale);
                    if (null != translated) {
                        Method method = ServiceUtils.getSetMethod(entity.getClass(), f.getName());
                        if (null != method) {
                            try {
                                method.invoke(entity, translated);
                            } catch (Exception e0) {
                                log.error(e0.getMessage(), e0);
                            }
                        }
                    }
                    continue;
                }
                dealLangRecusive(obj, locale);
            } catch (IllegalAccessException e) {
                log.error(e.toString());
            }
        }
    }

    private void dealLang(BaseObject entity, String locale) {
        if (null != entity && null != locale) {
            Map<String, Map<String, String>> lang = entity.getLang();
            if (null != lang) {
                lang.forEach((k, v) -> {
                    if (v != null) {
                        String langName = v.get(locale);
                        if (langName != null) {
                            Method method = ServiceUtils.getSetMethod(entity.getClass(), k);
                            if (null != method) {
                                try {
                                    method.invoke(entity, langName);
                                } catch (Exception e) {
                                    log.error(e.toString());
                                    // 忽略异常
                                }
                            } else {
                                log.warn("can not find set method by class {} and filed {}", entity.getClass().getName(), k);
                            }

                        }
                    }
                });

                // entity.setLang(null);
            }
        }

    }

    private String translateWord(String str, String locale) {
        if (null != str && str.startsWith("#{") && str.endsWith("}")) {
            String key = str.substring(2, str.length() - 1).trim();
            if (StringUtils.isNotEmpty(key)) {
                return translate(key, locale);
            }
        }

        return null;
    }

}
