package com.digiwin.athena.datamap.spi;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.datamap.povo.CardGroupGroup;
import com.digiwin.athena.datamap.povo.DapResponse;
import com.digiwin.athena.datamap.utils.DataMapUtils;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
@Slf4j
public class AtmcService {

    @Value("${atmcUrl}")
    private String atmcUrl;

    @Autowired
    private RestTemplate restTemplate;

    /*
     * atmc:cache:* uibot:cache:* Athena:agileInteraction:audc:cache:*
     */
    public Object cleanCache() {
        Map<String, Object> params = new HashMap<>();
        DapResponse resp = DataMapUtils.request(atmcUrl + "/v1/cache/reset", "get", params);
        return resp.getResponse();
    }

    public List<CardGroupGroup> getGroupDimension(String routerKey) {
        String tenantToken = ServiceUtils.getToken();
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("token", tenantToken);
        if (StringUtils.isNotEmpty(routerKey)) {
            headers.add("routerKey", routerKey);
        }

        HttpEntity<Object> requestEntity = new HttpEntity<>(headers);
        log.info("getGroupDimension tenantId:{}, url:{}", routerKey, atmcUrl + "/api/atmc/v1/backlog/group/dimension");
        ResponseEntity<DapResponse> resEntity = restTemplate.exchange(atmcUrl + "/api/atmc/v1/backlog/group/dimension", HttpMethod.GET, requestEntity, DapResponse.class);
        DapResponse body = resEntity.getBody();
        log.info("getGroupDimension result:{}", body);
        List<CardGroupGroup> cardGroupGroups = JSONObject.parseArray(JSON.toJSONString(body.getResponse()), CardGroupGroup.class);

        return cardGroupGroups;
    }

}
