package com.digiwin.athena.datamap.spi;

import com.digiwin.athena.datamap.povo.DapResponse;
import com.digiwin.athena.datamap.utils.DataMapUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

@Service
@Slf4j
public class DataMapTagSystemService {

    @Value("${tagSystemUrl}")
    private String tagSystemUrl;
    private String kghost = null;

    public Object syncTags(Map<String, Object> param) {
        Map<String, Object> params = new HashMap<>();
        params.put("req", param);
        DapResponse resp = DataMapUtils.request(tagSystemUrl + "/tag/batchTags", "post", params);
        return resp.getResponse();
    }

    public Object cleanTags(Map<String, Object> param) {
        Map<String, Object> params = new HashMap<>();
        params.put("req", param);
        DapResponse resp = DataMapUtils.request(tagSystemUrl + "/tag/cleanPlugin", "post", params);
        return resp.getResponse();
    }

    public Object postTagsByAction(Map<String, Object> param) {
        Map<String, Object> params = new HashMap<>();
        params.put("req", param);
        DapResponse resp = DataMapUtils.request(tagSystemUrl + "/tag/tagsByAction", "post", params);
        return resp.getResponse();
    }
}
