package com.digiwin.athena.datamap.spi;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.datamap.povo.DapResponse;
import com.digiwin.athena.datamap.utils.DataMapUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.Map;

@Service
@Slf4j
public class DatamapEocService {

    @Value("${eocUrl}")
    private String eocUrl;


    @Value("${iamApToken}")
    private  String appToken = null;

    public Object eocInfo() {
        Map<String, Object> params = new HashMap<>();
        DapResponse resp = DataMapUtils.request(eocUrl + "/api/eoc/v2/corp/all", "get", params);
        return resp.getData();
    }

    public void syncDuty(Map<String, Object> params){

        requestEoc("/api/eoc/v2/duty","post",params);
    }

    public void synclevel(Map<String, Object> params){

        requestEoc("/api/eoc/v2/emp/level","post",params);
    }

    public Map requestEoc(String url, String method, Map<String, Object> params) {
        if (CollectionUtils.isEmpty(params)) {
            params = new HashMap<>();
        }
        Map<String, String> headers = new HashMap<>();
        headers.put("digi-middleware-auth-app", appToken);
        String resp = DataMapUtils.requestString(eocUrl + url, method, params, headers);
        return JSONObject.parseObject(resp, Map.class);
    }
}
