package com.digiwin.athena.datamap.utils;

import com.digiwin.athena.domain.core.app.ApplicationRelation;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

import java.io.FileOutputStream;
import java.util.List;

public class ExcelExporter {

    public void exportToExcel(List<ApplicationRelation> applicationRelations) throws Exception {
        // 创建一个新的工作簿
        Workbook workbook = new XSSFWorkbook();
        // 创建一个工作表
        Sheet sheet = workbook.createSheet("Application Relations");
        // 创建标题行
        Row headerRow = sheet.createRow(0);
        headerRow.createCell(0).setCellValue("App Code");
        headerRow.createCell(1).setCellValue("App Name");
        headerRow.createCell(2).setCellValue("Code");
        headerRow.createCell(3).setCellValue("Name");

        // 遍历数据并写入工作表
        int rowNum = 1;
        for (ApplicationRelation relation : applicationRelations) {
            Row row = sheet.createRow(rowNum++);
            row.createCell(0).setCellValue(relation.getAppCode());
            row.createCell(1).setCellValue(relation.getAppName());
            row.createCell(2).setCellValue(relation.getCode());
            row.createCell(3).setCellValue(relation.getName());
        }

        // 将工作簿写入文件
        try (FileOutputStream outputStream = new FileOutputStream("application_relations.xlsx")) {
            workbook.write(outputStream);
        }
    }

}
