package com.digiwin.athena.datamap.configuration;

import com.digiwin.athena.esp.sdk.init.EspSdkInitialize;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

import javax.annotation.PostConstruct;

/**
 * @ClassName EspConfig
 * @Description TODO
 * @Author zhuangli
 * @Date 2021/4/14 16:58
 * @Version 1.0
 **/
@Configuration
public class DataMapEspSdkInitConfig {

    @Value("${espUrl}")
    private String espDomain;
    @Value("${mdcUrl}")
    private String mdcDomain;
    @Value("${thememapUrl}")
    private String tmHost;
    @Value("${appId}")
    private String appId;
    @Value("${iamApToken}")
    private String token;
    @Value("${lmcUrl}")
    private String lmcUrl;

    @PostConstruct
    public void init() {
        System.out.println("======EspSdkInitConfig init=====");
        EspSdkInitialize.initConfig(espDomain, mdcDomain, tmHost);
        EspSdkInitialize.initAppConfig(appId, token);
        EspSdkInitialize.initLmcConfig(lmcUrl);
        EspSdkInitialize.enableEspRouting(true);
    }

}
