package com.digiwin.athena.datamap.mechanism.activitybuilder;

import com.alibaba.fastjson.JSON;

import com.digiwin.athena.config.ActivityType;
import com.digiwin.athena.config.ScriptMode;
import com.digiwin.athena.config.StandardMode;
import com.digiwin.athena.datamap.mechanism.support.MechanismParseContext;
import com.digiwin.athena.datamap.service.inner.DataMapPickService;
import com.digiwin.athena.domain.core.Activity;
import com.digiwin.athena.mechanism.widgets.ActivityWidget;
import com.digiwin.athena.mechanism.widgets.activity.HttpActivityWidget;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
http类型提供2种形式
 1.标准模式 内部转换为脚本模式
 2.script模式，提供用户写脚本的方式

 **/
@Service
@Order(1)
public class HttpActivityBuildService implements ActivityBuildService {

    @Autowired
    DataMapPickService dataPickService;

    @Override
    public boolean accept(ActivityWidget ma) {
        return ActivityType.http.name().equals(ma.getType());
    }

    @Override
    public List<Activity> build(ActivityWidget ma, MechanismParseContext context) {

        List<Activity> result = new ArrayList<>();
        HttpActivityWidget http = dataPickService.convert(ma, HttpActivityWidget.class);
        Activity activity = new Activity();
        activity.setType("http");
        activity.setName(http.getName());
        activity.setMilestone(false);

        if (null != http.getHttpConfig() && "standard".equalsIgnoreCase(http.getHttpConfig().getExecutionMode())) {
            http.getHttpConfig().setExecutionMode("script");
            StandardMode standardMode = http.getHttpConfig().getStandardMode();
            ScriptMode scriptMode = new ScriptMode();
            if ("json".equalsIgnoreCase(http.getHttpConfig().getContentType())) {
                scriptMode.setRequestScript(requestScript(standardMode.getJson()));
            } else {
                scriptMode.setRequestScript(requestScript(standardMode.getParams()));
            }
            scriptMode.setResponseScript(responseScript(standardMode));
            http.getHttpConfig().setScriptMode(scriptMode);

            Map<String, Object> config = JSON.parseObject(JSON.toJSONString(http.getHttpConfig()));
            activity.setConfig(config);
            // todo 设计时无法知道产品名称，需要咋应用到租户时进行配置
            if (null != http.getHttpConfig().getProduct()) {
                config.put("product", null);
            } else {
                config.put("product", context.getBindingContext().getParam().get("product"));
            }
        } else {
            activity.setConfig(http.getConfig());
        }

        result.add(activity);

        return result;
    }

    /**
     var request = {\n    \"empId\": $(executorInfo).executor_no\n};\nreturn request;
     */

    protected String requestScript(Map<String, Object> request) {
        StringBuilder sb = new StringBuilder();
        sb.append("var request = ")
                .append(JSON.toJSONString(request))
                .append(";return request;");
        return sb.toString();
    }

    protected String requestScript(String json) {
        StringBuilder sb = new StringBuilder();
        sb.append("var request = ")
                .append(json)
                .append(";return request;");
        return sb.toString();
    }

    protected String responseScript(StandardMode standardMode) {
        StringBuilder sb = new StringBuilder();
        sb.append("var response = $(response);");

        if (null != standardMode.getRespVariables()) {
            standardMode.getRespVariables().forEach((k, v) -> {
                sb.append("var ").append(k).append("=").append(v).append(";");
            });
        }

        sb.append("return {");

        if (null != standardMode.getRespVariables()) {
            standardMode.getRespVariables().forEach((k, v) -> {
                sb.append("\"").append(k).append("\":").append(k).append(",");
            });
            sb.append("\"").append("__innerMechanism").append("\":").append(1).append("");
        }

        sb.append("};");
        return sb.toString();
    }

    public static void main(String[] args) {
        // Map<String,Object> param = new HashMap<>();
        // param.put("empId","emp001");
        // param.put("empId2",3);
        // param.put("empId3","$(aaa).bbb");
        // System.out.println(requestScript(param));
        //
        // StandardMode standardMode = new StandardMode();
        // Map<String,String> vars = new HashMap<>();
        // vars.put("key1","response.aa.bb.cc");
        // vars.put("key2","response.aa.bb.dd");
        // standardMode.setRespVariables(vars);
        // System.out.println(responseScript(standardMode));

    }

}
