package com.digiwin.athena.datamap.mechanism.component;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.datamap.mechanism.MechanismHelpService;
import com.digiwin.athena.datamap.mechanism.convert.HooksConverter;
import com.digiwin.athena.datamap.mechanism.convert.HooksInfo;
import com.digiwin.athena.datamap.mechanism.convert.MechanismParserFactory;
import com.digiwin.athena.datamap.mechanism.convert.parsers.judgeBasis.ConditionParser;
import com.digiwin.athena.datamap.mechanism.convert.parsers.judgeBasis.JudgeBasisParser;
import com.digiwin.athena.datamap.mechanism.decisionHandler.DecisionCommonUtil;
import com.digiwin.athena.datamap.mechanism.support.BindingContext;
import com.digiwin.athena.datamap.mechanism.support.MechanismParseContext;
import com.digiwin.athena.domain.component.ComponentTypeEnum;
import com.digiwin.athena.domain.core.Task;
import com.digiwin.athena.domain.core.view.PageView;
import com.digiwin.athena.mechanism.bo.DecisionAbilityBO;
import com.digiwin.athena.mechanism.common.MechanismAbility;
import com.digiwin.athena.mechanism.dto.MechanismApiInfoDTO;
import com.digiwin.athena.mechanism.dto.MechanismComponentDTO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2022-07-27 15:16
 **/
@Service
@Slf4j
public class DecisionAbilityHandler extends AbstractAbilityComponentHandler {

    @Autowired
    HooksConverter hooksConverter;

    @Autowired
    MechanismHelpService mechanismHelpService;

    @Autowired
    DecisionCommonUtil decisionCommonUtil;

    @Autowired
    MechanismParserFactory mechanismParserFactory;

    @Autowired
    ConditionParser conditionParser;

    @Override
    public void apply(MechanismAbility ability, BindingContext context) throws DWException {
        unapply(ability, context);
        DecisionAbilityBO bo = (DecisionAbilityBO) ability;
        String taskCode = bo.getCheckSource().getTarget();
        Task task = dataPickService.findBetter(taskCode, Task.class);
        if (null != task && null != task.getPageCode()) {
            PageView pageView = dataPickService.findByCode(task.getPageCode(), PageView.class);
            HooksInfo hooksInfoAll = new HooksInfo();
            if (null != pageView) {
                // 根据不同条件类型（condition，api）解析数据
                JudgeBasisParser judgeBasisParser = mechanismParserFactory.getJudgeParserByType(bo.getSubType());
                if (null != judgeBasisParser) {
                    judgeBasisParser.parse(ability, pageView, context, hooksInfoAll);
                } else {
                    log.error("DecisionAbilityHandler.apply 获取JudgeParser失败，入参{}", context);
                }
                MechanismParseContext parseContext = buildContext(ability, context);
                decisionCommonUtil.postRemovePlugin(parseContext.getBindingContext().getTenantId(), parseContext.getBindingContext().getPluginId());
                decisionCommonUtil.addMechanismParameter(parseContext, hooksInfoAll, pageView);

                // mongoTemplate.save(pageView);
            }
        }
    }

    @Override
    public void unapply(MechanismAbility ability, BindingContext context) throws DWException {
        mechanismHelpService.unapplyCommon(context);
    }

    @Override
    public boolean accept(MechanismComponentDTO dto) {
        return ComponentTypeEnum.MechanismDecision.name().equalsIgnoreCase(dto.getType());
    }

    @Override
    public Object parseScene(MechanismApiInfoDTO apiInfoDTO) {
        return conditionParser.parseScene(apiInfoDTO);
    }
}
