package com.digiwin.athena.datamap.mechanism.component;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.datamap.mechanism.support.BindingContext;
import com.digiwin.athena.datamap.mechanism.support.MechanismParseContext;
import com.digiwin.athena.domain.component.ComponentTypeEnum;
import com.digiwin.athena.domain.core.DataState;
import com.digiwin.athena.domain.core.Project;
import com.digiwin.athena.domain.core.Task;
import com.digiwin.athena.domain.definition.Identity;
import com.digiwin.athena.domain.definition.UserDefinition;
import com.digiwin.athena.domain.plugin.PluginBindingPo;
import com.digiwin.athena.mechanism.bo.DriveAbilityBo;
import com.digiwin.athena.mechanism.common.MechanismAbility;
import com.digiwin.athena.mechanism.dto.MechanismApiInfoDTO;
import com.digiwin.athena.mechanism.dto.MechanismComponentDTO;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2022-08-19 10:45
 **/
@Service
public class DriveAbilityHandler extends AbstractAbilityComponentHandler {

    @Override
    public void apply(MechanismAbility ability, BindingContext context) throws DWException {
        unapply(ability, context);
        DriveAbilityBo bo = (DriveAbilityBo) ability;
        MechanismParseContext parseContext = buildTaskFlow(bo, context);

        buildGateway1(bo.getChoose(), parseContext);

        endTaskFlow(parseContext.getLastLink(), parseContext);

        buildProject(bo.getProjectCode(), parseContext);

    }

    @Override
    public void unapply(MechanismAbility ability, BindingContext context) throws DWException {
        PluginBindingPo binding = PluginBindingPo.of(context.getTenantId(), context.getPluginId());
        pluginService.postRemovePlugin(binding);
    }

    @Override
    public boolean accept(MechanismComponentDTO dto) {
        return ComponentTypeEnum.MechanismDrive.name().equalsIgnoreCase(dto.getType());
    }

    public void buildProject(String code, MechanismParseContext context) {
        Task task = context.getTask();
        Project project = new Project();
        project.setCode(code);
        project.setTenantId(context.getBindingContext().getTenantId());
        project.setPluginId(context.getBindingContext().getPluginId());
        project.setExecuteType("mainline");
        project.setType("BUSINESS");
        project.setName("机制驱动项目");
        DataState dataState1 = new DataState();
        dataState1.setCode(context.getStartState());
        dataState1.setDataCode(context.getDataCode());
        project.setInit(dataState1);
        DataState dataState2 = new DataState();
        dataState2.setCode(context.getEndState());
        dataState2.setDataCode(context.getDataCode());
        project.setEnd(dataState2);

        // 后台运行的项目随便指定个负责人
        UserDefinition charge = new UserDefinition();
        charge.setChoosePolicy("single");
        List<Identity> identities = new ArrayList<>();
        charge.setIdentities(identities);
        Identity identity = new Identity();
        identity.setPerformerType("duty");
        identity.setPerformerValue("athena_buyers");
        identities.add(identity);
        project.setPersonInCharge(charge);

        // mongoTemplate.save(project);
        dataPickService.saveTenantObject(project, Project.class);

    }

    @Override
    public Object parseScene(MechanismApiInfoDTO apiInfoDTO) {
        return null;
    }
}
