package com.digiwin.athena.datamap.mechanism.component;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.config.DataType;
import com.digiwin.athena.config.OpType;
import com.digiwin.athena.datamap.mechanism.convert.HooksInfo;
import com.digiwin.athena.datamap.mechanism.convert.MechanismParserFactory;
import com.digiwin.athena.datamap.mechanism.convert.parsers.judgeBasis.JudgeBasisParser;
import com.digiwin.athena.datamap.mechanism.limithandler.LimitCommonUtil;
import com.digiwin.athena.datamap.mechanism.limithandler.ReminderLimitHandler;
import com.digiwin.athena.datamap.mechanism.support.BindingContext;
import com.digiwin.athena.datamap.mechanism.support.MechanismParseContext;
import com.digiwin.athena.datamap.service.inner.DataMapPickService;
import com.digiwin.athena.datamap.service.inner.PluginService;
import com.digiwin.athena.datamap.spi.DataMapKgService;
import com.digiwin.athena.datamap.spi.PresetLibraryService;
import com.digiwin.athena.domain.component.ComponentTypeEnum;
import com.digiwin.athena.domain.core.Task;
import com.digiwin.athena.domain.core.TenantObjectAdaptation;
import com.digiwin.athena.domain.core.flow.FlowLink;
import com.digiwin.athena.domain.core.view.PageUIElement;
import com.digiwin.athena.domain.core.view.PageView;
import com.digiwin.athena.domain.definition.actions.ActionParam;
import com.digiwin.athena.domain.plugin.PluginBindingPo;
import com.digiwin.athena.kmservice.service.DataPickService;
import com.digiwin.athena.mechanism.bo.LimitAbilityBo;
import com.digiwin.athena.mechanism.common.MechanismAbility;
import com.digiwin.athena.mechanism.common.MechanismEnum;
import com.digiwin.athena.mechanism.common.MechanismPlanType;
import com.digiwin.athena.mechanism.dto.MechanismApiInfoDTO;
import com.digiwin.athena.mechanism.dto.MechanismComponentDTO;
import com.digiwin.athena.mechanism.widgets.PlanWidget;
import com.digiwin.athena.mechanism.widgets.SourceWidget;
import com.digiwin.athena.mechanism.widgets.choose.SingleStrategyWidget;
import com.digiwin.athena.mechanism.widgets.plan.ReminderPlan;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2022-08-09 16:57
 **/
@Service
@Slf4j
public class LimitAbilityHandler extends AbstractAbilityComponentHandler {

    @Autowired
    PluginService pluginService;
    @Autowired
    @Qualifier("dataMapSystem")
    MongoTemplate mongoTemplate;
    @Autowired
    DataMapPickService dataPickService;
    @Autowired
    LimitCommonUtil limitCommonUtil;

    @Autowired
    PresetLibraryService presetLibraryService;
    @Autowired
    DataMapKgService dataMapKgService;

    @Autowired
    MechanismParserFactory mechanismParserFactory;

    @Autowired
    ReminderLimitHandler reminderLimitHandler;

    @Override
    public void apply(MechanismAbility ability, BindingContext context) throws Exception {
        unapply(ability, context);
        LimitAbilityBo bo = (LimitAbilityBo) ability;
        MechanismParseContext parseContext = buildContext(bo, context);

        String taskCode = bo.getCheckSource().getTarget();
        String pageCode = null;
        if (parseContext.getSourceWidget().getType().equalsIgnoreCase("taskSource")) {
            Task task = dataPickService.findBetter(taskCode, Task.class);
            pageCode = task == null ? null : task.getPageCode();
        } else if (parseContext.getSourceWidget().getType().equalsIgnoreCase("projectSource")) {
            pageCode = "start_" + bo.getCheckSource().getTarget();
        }

        if (preHandleReminder(ability, context)) {
            // 使用欧博士提醒时删除原有的hook
            limitCommonUtil.postRemovePlugin(parseContext.getBindingContext().getTenantId(), parseContext.getBindingContext().getPluginId());

            // 解决机制参数欧博士提示为空的问题
            setActionParams(parseContext, bo);
            return;
        }

        if (null != pageCode) {
            PageView pageView = dataPickService.findBetter(pageCode, PageView.class);
            HooksInfo hooksInfoAll = new HooksInfo();
            if (null != pageView) {
                // 根据不同条件类型（condition，api）解析数据
                JudgeBasisParser judgeBasisParser = mechanismParserFactory.getJudgeParserByType(
                        MechanismEnum.ConditionType.LIMIT_CONDITION.getCode());
                if (null != judgeBasisParser) {
                    judgeBasisParser.parse(ability, pageView, context, hooksInfoAll);
                } else {
                    log.error("LimitAbilityHandler.apply 获取JudgeParser失败，入参{}", context);
                }
                limitCommonUtil.postRemovePlugin(parseContext.getBindingContext().getTenantId(), parseContext.getBindingContext().getPluginId());
                limitCommonUtil.addMechanismParameter(bo, parseContext, hooksInfoAll, pageView);

                // mongoTemplate.save(pageView);
                dataPickService.saveTenantObject(pageView, PageView.class);
            }
        }
    }

    /**
     * 解决机制参数欧博士提示为空的问题
     * @param parseContext
     * @param bo
     */
    private void setActionParams(MechanismParseContext parseContext, LimitAbilityBo bo) {
        try {
            log.info("Route==>LimitAbilityHandler method=setActionParams ability:{}", JSON.toJSONString(bo));

            List<SingleStrategyWidget> strategies = bo.getStrategies();
            // 为空取不到机制参数，没必要继续执行了
            if (CollectionUtils.isEmpty(strategies)) {
                log.info("Route==>LimitAbilityHandler method=setActionParams strategies isEmpty ability:{}", JSON.toJSONString(bo));
                return;
            }
            SingleStrategyWidget singleStrategyWidget = strategies.get(0);
            PlanWidget positiveTarget = singleStrategyWidget.getPositiveTarget();

            // 为空取不到机制参数，没必要继续执行了
            if (Objects.isNull(positiveTarget)) {
                log.info("Route==>LimitAbilityHandler method=setActionParams positiveTarget isNull ability:{}", JSON.toJSONString(bo));
                return;
            }
            // 获取机制参数code
            Object message = ((ReminderPlan) positiveTarget).getMessage();

            // 任务卡欧博士为空逻辑
            if (parseContext.getSourceWidget().getType().equalsIgnoreCase("taskSource")) {

                BindingContext bindingContext = parseContext.getBindingContext();
                SourceWidget sourceWidget = parseContext.getSourceWidget();

                TenantObjectAdaptation tenantObjectAdaptation = new TenantObjectAdaptation();
                tenantObjectAdaptation.setType("TM_VARIABLE");
                tenantObjectAdaptation.setCode(sourceWidget.getTarget());
                tenantObjectAdaptation.setTenantId(bindingContext.getTenantId());
                tenantObjectAdaptation.setPluginId(bindingContext.getPluginId());
                tenantObjectAdaptation.setPath("$.pages.task-detail.dataStates[0].submitActions[0].actionParams");
                ActionParam actionParam = new ActionParam();
                actionParam.setType("TM_VARIABLE");
                actionParam.setValue(message + "");
                actionParam.setName(message + "");
                tenantObjectAdaptation.setValue(actionParam);
                tenantObjectAdaptation.setDateType(DataType.array);
                tenantObjectAdaptation.setOp(OpType.add);
                tenantObjectAdaptation.setBusinessKey(ComponentTypeEnum.MechanismLimit.name());
                tenantObjectAdaptation.setExt(new HashMap<>());

                // 新增PageViewAdaptation表，补欧博士为空的问题
                dataPickService.tenantTemplate().save(tenantObjectAdaptation, DataPickService.tableTenantObjectAdaptation(PageView.class));

                // 基础资料欧博士为空逻辑,增加dataViewCode不为空处理数据
            } else if (parseContext.getSourceWidget().getType().equalsIgnoreCase("dataEntrySource") && !StringUtils.isEmpty(bo.getDataViewCode())) {

                BindingContext bindingContext = parseContext.getBindingContext();

                TenantObjectAdaptation tenantObjectAdaptation = new TenantObjectAdaptation();
                tenantObjectAdaptation.setType("TM_VARIABLE");
                tenantObjectAdaptation.setCode(bo.getDataViewCode());
                tenantObjectAdaptation.setTenantId(bindingContext.getTenantId());
                tenantObjectAdaptation.setPluginId(bindingContext.getPluginId());
                tenantObjectAdaptation.setPath("$.elements..submitActions[0].actionParams");
                ActionParam actionParam = new ActionParam();
                actionParam.setType("TM_VARIABLE");
                actionParam.setValue(message + "");
                actionParam.setName(message + "");
                tenantObjectAdaptation.setValue(actionParam);
                tenantObjectAdaptation.setDateType(DataType.array);
                tenantObjectAdaptation.setOp(OpType.add);
                tenantObjectAdaptation.setBusinessKey(ComponentTypeEnum.MechanismLimit.name());
                tenantObjectAdaptation.setExt(new HashMap<>());

                // 新增PageUIElementAdaptation表，补欧博士为空的问题
                dataPickService.tenantTemplate().save(tenantObjectAdaptation, DataPickService.tableTenantObjectAdaptation(PageUIElement.class));

            }
        } catch (Exception e) {
            log.error("Route==>LimitAbilityHandler method=setActionParams error:", e);
        }
    }

    /**
     * 提前处理欧博士
     * @param ability
     * @param context
     * @return 返回数据
     */
    private boolean preHandleReminder(MechanismAbility ability, BindingContext context) {
        boolean result = false;
        LimitAbilityBo bo = (LimitAbilityBo) ability;
        // 非欧博士的删除数据
        presetLibraryService.cleanRule(bo.getCode());
        try {
            List<SingleStrategyWidget> strategies = bo.getStrategies();
            if (null != strategies) {
                Optional<SingleStrategyWidget> first = strategies.stream().filter(
                        widget -> widget.getPositiveTarget() != null &&
                                MechanismPlanType.reminderPlan.name().equalsIgnoreCase(widget.getPositiveTarget().getType()))
                        .findFirst();
                if (first.isPresent()) {
                    MechanismParseContext parseContext = buildParseContext(bo, context);
                    parseContext.getBindingContext().setMechanismVersion(context.getMechanismVersion());
                    for (SingleStrategyWidget widget : strategies) {
                        if (null != widget.getCondition() && null != widget.getCondition().getVariables()) {
                            FlowLink lastLink = applyVariables(parseContext.getLastLink(),
                                    widget.getCondition().getVariables(), parseContext);
                            parseContext.setLastLink(lastLink);
                        }

                        if (widget.getPositiveTarget() != null && MechanismPlanType.reminderPlan.name().equalsIgnoreCase(widget.getPositiveTarget().getType())) {
                            reminderLimitHandler.handler(widget, parseContext);
                            result = true;
                        }

                    }
                }
            }
        } catch (Exception e) {
            log.error("LimitAbilityHandler.preHandleReminder failed", e);
            return true;
        }
        return result;
    }

    private MechanismParseContext buildParseContext(LimitAbilityBo runnableAbility, BindingContext bindingContext) {
        MechanismParseContext parseContext = new MechanismParseContext();
        parseContext.setSourceWidget(runnableAbility.getCheckSource());
        parseContext.setBo(runnableAbility);
        parseContext.setBindingContext(bindingContext);
        parseContext.setSourceTarget(runnableAbility.getCheckSource().getTarget());
        return parseContext;
    }

    @Override
    public void unapply(MechanismAbility ability, BindingContext context) throws DWException {
        PluginBindingPo binding = PluginBindingPo.of(context.getTenantId(), context.getPluginId());
        pluginService.postRemovePlugin(binding);
        // 清除定义中机制插入的机制参数 重新存储
        LimitAbilityBo bo = (LimitAbilityBo) ability;
        if ("dataEntrySource".equals(bo.getCheckSource().getType())) {
            // kgService.cleanActionsByPluginId(bo.getCheckSource().getTarget(),context.getPluginId());
            // 清空欧博士机制参数
            Query query = new Query();
            query.addCriteria(Criteria.where("pluginId").is(context.getPluginId()).and("tenantId").is(context.getTenantId()).and("code").is(bo.getDataViewCode()));
            dataPickService.tenantTemplate().remove(query, DataPickService.tableTenantObjectAdaptation(PageUIElement.class));
        }
        if ("taskSource".equals(bo.getCheckSource().getType())) {
            Query query = new Query();
            query.addCriteria(Criteria.where("pluginId").is(context.getPluginId()).and("tenantId").is(context.getTenantId()).and("code").is(bo.getCheckSource().getTarget()));
            dataPickService.tenantTemplate().remove(query, DataPickService.tableTenantObjectAdaptation(PageView.class));
        }
        if ("projectSource".equals(bo.getCheckSource().getType())) {
            Query query = new Query();
            query.addCriteria(Criteria.where("pluginId").is(context.getPluginId()).and("tenantId").is(context.getTenantId()).and("code").is(bo.getCheckSource().getTarget()));
            dataPickService.tenantTemplate().remove(query, DataPickService.tableTenantObjectAdaptation(PageView.class));
        }
    }

    @Override
    public boolean accept(MechanismComponentDTO dto) {
        // 此类为限制能力2.0版本，旧数据走LimitAbilityHandlerOld.java
        return ComponentTypeEnum.MechanismLimit.name().equalsIgnoreCase(dto.getType()) && "2.0".equalsIgnoreCase(dto.getMechanismVersion());
    }

    @Override
    public Object parseScene(MechanismApiInfoDTO apiInfoDTO) {
        Boolean parseResult = mechanismParserFactory.getLimitConditionParserByType(apiInfoDTO.getLimitConditionType()).parse(apiInfoDTO);
        // 如果限制的条件判断为未通过，则直接退出
        if (Boolean.TRUE.compareTo(parseResult) == 1) {
            log.info("LimitAbilityHandler.parseScene getLimitConditionParserByType判断未通过！直接返回");
            return null;
        }
        try {
            return mechanismParserFactory.getLimitActionParserByType(apiInfoDTO.getLimitActionType()).parse(apiInfoDTO);
        } catch (Exception e) {
            log.error("LimitAbilityHandler parseScene failed, e={}", e);
        }
        return null;
    }
}
