package com.digiwin.athena.datamap.mechanism.controlSourcehandlers;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.mechanism.support.MechanismParseContext;
import com.digiwin.athena.mechanism.common.MechanismCheckSourceType;
import com.digiwin.athena.mechanism.widgets.SourceWidget;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2022-08-19 10:54
 **/
@Service
public class ScheduleSourceHandler extends AbstractControlSourceHandler {

    @Autowired
    @Qualifier("dataMapSystem")
    MongoTemplate mongoTemplate;

    @Override
    public boolean accept(SourceWidget source) {
        return MechanismCheckSourceType.scheduleSource.name().equals(source.getType());
    }

    @Override
    public void parse(SourceWidget source, MechanismParseContext context) throws DWBusinessException {
        // do nothing for now

    }

}
