package com.digiwin.athena.datamap.mechanism.convert;

import com.digiwin.athena.datamap.utils.CommonUtils;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2023-03-31 09:31
 **/
@Service
public class JSFunctions implements InitializingBean {

    public static Map<String, String> functions = new HashMap<>();

    public String function(String name) {
        return functions.get(name);
    }

    public void loadFunction(String name) {
        String content = CommonUtils.loadStream("functions/" + name + ".js");
        functions.put(name, content);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
        Resource[] resources = resourcePatternResolver.getResources("classpath*:files/functions/*.js");
        for (Resource resource1 : resources) {
            String name = resource1.getFilename().split("\\.")[0];
            String content = IOUtils.toString(resource1.getInputStream(), "utf-8");
            functions.put(name, content);
        }
    }

    public static void main(String[] args) {
        System.out.println("parseDate.js".split("\\.")[0]);
    }
}
