package com.digiwin.athena.datamap.mechanism.convert;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.mechanism.support.BindingContext;
import com.digiwin.athena.mechanism.widgets.config.MechanismConditionConfig;

public interface JsExpressionParser {

    boolean accept(MechanismConditionConfig config);

    JsExpression parse(MechanismConditionConfig config, BindingContext context) throws DWBusinessException;

    default String pathExpr(String name, BindingContext context) {
        switch (context.getJsExpressionType()) {
            // 这边解析未来应该还要拓展 如果规则协议各处的不一样
            case currentControl:
                return "currentControl.parent.get('" + name + "').value";
            case data:
                return "data." + name;
            case taskData:
                return "taskData." + name;
            default:
                break;
        }
        return "data." + name;
    }

}
