package com.digiwin.athena.datamap.mechanism.convert.parsers.customFunction;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.mechanism.common.MechanismEnum;
import com.digiwin.athena.mechanism.common.MechanismVariable;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/**
 * @Description 是否存在函数解析
 * @Author liugl
 * @Date 2024/7/1 9:53
 **/
@Service
@Slf4j
public class ExistParser implements CustomFuncParser {

    @Override
    public boolean accept(String type) {
        return MechanismEnum.FunctionType.EXIST.getCode().equalsIgnoreCase(type);
    }

    @Override
    public String getOutPutTypeByName(String dataType) {
        return MechanismEnum.FunctionType.EXIST.getOutputType();
    }

    @Override
    public Boolean parse(MechanismVariable mechanismVariable, JSONArray metaDataList) {
        if (CollectionUtils.isEmpty(metaDataList)) {
            return null;
        }
        String dataName = mechanismVariable.getData_name();
        Object condValueObj = mechanismVariable.getMechanismFunction().getFunctionValue();
        if (condValueObj == null) {
            return Boolean.FALSE;
        }
        long count = metaDataList.stream().map(v -> {
            JSONObject metaDataObj = JSON.parseObject(JSON.toJSONString(v));
            Object sourceValueObj = metaDataObj.get(dataName);
            if (sourceValueObj != null) {
                return sourceValueObj.toString();
            }
            return null;
        }).filter(v -> !StringUtils.isEmpty(v) && StringUtils.equalsIgnoreCase(condValueObj.toString(), v)).count();
        return count > 0;
    }
}
