package com.digiwin.athena.datamap.mechanism.convert.parsers.hooks;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.mechanism.convert.HooksInfo;
import com.digiwin.athena.datamap.mechanism.support.BindingContext;
import com.digiwin.athena.domain.core.view.PageView;
import com.digiwin.athena.mechanism.common.MechanismAbility;
import com.digiwin.athena.mechanism.widgets.config.MechanismConditionConfig;

import java.util.Map;

/**
 * @Description hooks相关解析器，主要是api条件和基础条件、高级条件
 * @Author liugl
 * @Date 2024/6/28 10:20
 **/
public interface HooksParser {

    /**
     * 判断选择解析器
     * @param config
     * @return 结果
     */
    boolean accept(MechanismConditionConfig config);

    /**
     * api条件解析器
     * @param config
     * @param context
     * @param pageView
     * @param parameters
     * @return
     * @throws DWBusinessException
     */
    HooksInfo parse(MechanismConditionConfig config, BindingContext context, PageView pageView, Map<String, Object> parameters) throws DWBusinessException;

    /**
     * 构建参数
     * @param ability
     * @param parameters
     * @return 返回结果
     */
    Map<String, Object> buildParameters(MechanismAbility ability, Map<String, Object> parameters);
}
