package com.digiwin.athena.datamap.mechanism.convert.parsers.rightCond;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.datamap.mechanism.convert.CustomFuncResult;
import com.digiwin.athena.datamap.mechanism.convert.MechanismParserFactory;
import com.digiwin.athena.mechanism.bo.MechanismFunctionBO;
import com.digiwin.athena.mechanism.common.MechanismEnum;
import com.digiwin.athena.mechanism.common.MechanismVariable;
import com.digiwin.athena.mechanism.widgets.config.MechanismConditionConfig;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

/**
 * @Description 自定义函数解析
 * @Author liugl
 * @Date 2024/7/1 10:12
 **/
@Service
@Slf4j
public class CustomFunctionParser implements RightCondTypeParser {

    @Autowired
    MechanismParserFactory mechanismParserFactory;

    @Override
    public boolean accept(String type) {
        return MechanismEnum.RightCondType.CUSTOM_FUNCTION.getCode().equalsIgnoreCase(type);
    }

    @Override
    public CustomFuncResult preParse(MechanismConditionConfig conditionConfig, JSONArray metaDataList) {
        if (CollectionUtils.isEmpty(metaDataList)) {
            return new CustomFuncResult().setIsNeedNextJudge(Boolean.FALSE);
        }
        try {
            MechanismVariable right = conditionConfig.getRight();
            if (!ObjectUtils.isEmpty(right.getFrom().getMechanismFunction().getFunction())) {
                MechanismFunctionBO mechanismFunctionFrom = right.getFrom().getMechanismFunction();
                String functionNameFrom = mechanismFunctionFrom.getFunction();
                Object parseResultFrom = mechanismParserFactory.getCustomFuncParserByName(functionNameFrom).parse(right.getFrom(), metaDataList);
                right.getFrom().setFunctionValue(parseResultFrom);
                right.getFrom().setFunctionValueType(mechanismFunctionFrom.getOutputType());
            }

            MechanismFunctionBO mechanismFunctionTo = right.getTo().getMechanismFunction();
            String functionNameTo = mechanismFunctionTo.getFunction();
            Object parseResultTo = mechanismParserFactory.getCustomFuncParserByName(functionNameTo).parse(right.getTo(), metaDataList);
            right.getTo().setFunctionValue(parseResultTo);
            right.getTo().setFunctionValueType(mechanismFunctionTo.getOutputType());
        } catch (Exception e) {
            log.error("CustomFunctionParser.preParse 失败，e={}", e);
        }
        return new CustomFuncResult().setIsNeedNextJudge(Boolean.TRUE);
    }

    @Override
    public CustomFuncResult parse(MechanismConditionConfig config, JSONObject metaDataObj, JSONArray metaDataList) {
        if (ObjectUtils.isEmpty(metaDataObj) && ObjectUtils.isEmpty(metaDataList)) {
            return new CustomFuncResult().setIsNeedNextJudge(Boolean.FALSE);
        }
        // 非开窗数据
        if (ObjectUtils.isEmpty(config.getOpenWindowActionId())) {
            MechanismFunctionBO mechanismFunction = config.getRight().getMechanismFunction();
            String functionName = mechanismFunction.getFunction();
            Object parseResult = mechanismParserFactory.getCustomFuncParserByName(functionName).parse(config.getRight(), metaDataList);
            Object value = config.getRight().getTo().getValue();
            boolean equals = StringUtils.equals(parseResult != null ? String.valueOf(parseResult) : null,
                    parseResult != null ? String.valueOf(value) : null);
            // 右侧条件是自定义函数时，如果符合条件则组要操作所有数据
            return new CustomFuncResult().setIsNeedNextJudge(Boolean.FALSE).setMetaDataList(equals ? metaDataList : null);
        }
        return new CustomFuncResult().setIsNeedNextJudge(Boolean.FALSE);
    }

    /**
     * 提前处理左侧自定义函数
     *
     * @param left
     * @param metaDataList
     * @return 返回结果
     */
    public CustomFuncResult preParseLeftCond(MechanismVariable left, JSONArray metaDataList) {
        // 左侧判断条件只需把计算的值放入 left
        MechanismFunctionBO mechanismFunction = left.getMechanismFunction();
        String functionName = mechanismFunction.getFunction();
        Object parseResult = mechanismParserFactory.getCustomFuncParserByName(functionName).parse(left, metaDataList);
        left.setFunctionValue(parseResult);
        left.setFunctionValueType(mechanismFunction.getOutputType());
        // 用函数输出类型替换整个左边类型
        left.setData_type(mechanismFunction.getOutputType());
        return new CustomFuncResult().setIsNeedNextJudge(Boolean.TRUE);
    }
}
