package com.digiwin.athena.datamap.mechanism.convert.parsers.rightCond;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.datamap.mechanism.convert.CustomFuncResult;
import com.digiwin.athena.mechanism.common.MechanismEnum;
import com.digiwin.athena.mechanism.common.MechanismVariable;
import com.digiwin.athena.mechanism.widgets.config.MechanismConditionConfig;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @Description 自定义值解析
 * @Author liugl
 * @Date 2024/7/1 9:53
 **/
@Service
@Slf4j
public class CustomValueParser implements RightCondTypeParser {

    @Override
    public boolean accept(String type) {
        return MechanismEnum.RightCondType.CUSTOM_VALUE.getCode().equalsIgnoreCase(type);
    }

    @Override
    public CustomFuncResult preParse(MechanismConditionConfig conditionConfig, JSONArray metaDataList) {
        MechanismVariable right = conditionConfig.getRight();
        right.getFrom().setFunctionValue(right.getFrom().getValue());
        right.getTo().setFunctionValue(right.getTo().getValue());
        return new CustomFuncResult().setIsNeedNextJudge(Boolean.TRUE);
    }

    @Override
    public CustomFuncResult parse(MechanismConditionConfig config, JSONObject metaDataObj, JSONArray metaDataList) {
        // 自定义值，暂不用做任何操作，直接返回
        return new CustomFuncResult().setIsNeedNextJudge(Boolean.TRUE);
    }
}
