package com.digiwin.athena.datamap.mechanism.convert.parsers.rightCond;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.datamap.mechanism.convert.CustomFuncResult;
import com.digiwin.athena.datamap.service.IMechanismService;
import com.digiwin.athena.datamap.spi.DataMapKgService;
import com.digiwin.athena.mechanism.common.MechanismEnum;
import com.digiwin.athena.mechanism.common.MechanismVariable;
import com.digiwin.athena.mechanism.widgets.config.MechanismConditionConfig;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * @Description 机制参数解析器
 * @Author liugl
 * @Date 2024/7/1 10:14
 **/
@Service
@Slf4j
public class MechanismVariableParser implements RightCondTypeParser {

    @Autowired
    IMechanismService mechanismService;

    @Autowired
    DataMapKgService dataMapKgService;

    @Override
    public boolean accept(String type) {
        return MechanismEnum.RightCondType.MECHANISM_VARIABLE.getCode().equalsIgnoreCase(type);
    }

    @Override
    public CustomFuncResult preParse(MechanismConditionConfig conditionConfig, JSONArray metaDataList) {
        if (CollectionUtils.isEmpty(metaDataList)) {
            return new CustomFuncResult().setIsNeedNextJudge(Boolean.FALSE);
        }
        try {
            MechanismVariable right = conditionConfig.getRight();
            String dataNameFrom = right.getFrom().getData_name();
            String dataNameTo = right.getTo().getData_name();

            List<String> variableIds = Lists.newArrayList(dataNameFrom, dataNameTo);
            Object variableObj = dataMapKgService.getVariableListSimple(variableIds, Boolean.TRUE);
            JSONObject variableJsonObj = JSONObject.parseObject(JSON.toJSONString(variableObj));

            // functionValue用于高级条件 value用于基本条件
            right.getFrom().setFunctionValue(variableJsonObj.get(dataNameFrom));
            right.getFrom().setValue(variableJsonObj.get(dataNameFrom));
            right.getTo().setFunctionValue(variableJsonObj.get(dataNameTo));
            right.getTo().setValue(variableJsonObj.get(dataNameTo));
        } catch (Exception e) {
            log.error("MechanismVariableParser.preParse 失败，e={}", e);
        }
        return new CustomFuncResult().setIsNeedNextJudge(Boolean.TRUE);
    }

    @Override
    public CustomFuncResult parse(MechanismConditionConfig config, JSONObject metaDataObj, JSONArray metaDataList) {
        // 机制参数，暂不用做任何操作，直接返回
        return new CustomFuncResult().setIsNeedNextJudge(Boolean.TRUE);
    }
}
