package com.digiwin.athena.datamap.povo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class TaskCardFieldVO implements Serializable {

    /**
     * pageView的code
     */
    private String code;

    /**
     * 自定义列
     */
    private List<ColumnVO> columns;

    /**
     * 开发平台配置的自定义列
     */
    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class ColumnVO {

        private String code;

        private String name;

        private Map<String, Map<String, String>> lang;

        private String value;

    }

}
