package com.digiwin.athena.datamap.povo;

import com.digiwin.athena.datamap.enums.SourceType;
import com.digiwin.athena.datamap.enums.WSConfigType;
import com.digiwin.athena.datamap.enums.WSPageCode;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.List;
import java.util.Map;

@Document(collection = "workbenchSetting")
@AllArgsConstructor
@NoArgsConstructor
@Data
public class WorkbenchSetting {

    @Id
    private String id;

    private String tenantId;

    private WSConfigType configType;

    private WSPageCode pageCode;

    /**
     * 条件配置
     */
    private List<WSCondition> condition;
    /**
     * 默认的条件配置
     */
    private List<WSCondition> defaultCondition;

    /**
     * 交付设计器的待办工作台设置中的条件
     */
    @AllArgsConstructor
    @NoArgsConstructor
    @Data
    public static class WSCondition {

        /**
         * 名称
         */
        private String aliasName;
        /**
         * 代号
         */
        private String aliasCode;
        /**
         * 类型
         */
        private String dataType;

        private SourceType sourceType;

        private List<PointInTime> pointInTime;

        private List<Dimensionality> dimensionality;
        /**
         * 是否默认启用
         */
        private Boolean defaultEffective;

        /**
         * 是否启用
         */
        private Boolean enable;

        /**
         * 分组下，是否默认分组项
         */
        private Boolean defaultGroup;

        public Map<String, Map<String, String>> lang;

        /**
         * 生效范围
         */
        private List<ConditionScope> conditionScope;

        /**
         * 待办工作台设定中的条件生效范围
         */
        @AllArgsConstructor
        @NoArgsConstructor
        @Data
        public static class ConditionScope {

            private String appCode;
            /**
             * 任务名称或项目名称
             */
            private String name;
            /**
             * 原始编码
             */
            private String fieldCode;

            /**
             * 任务和项目编码
             */
            private String code;

            public Map<String, Map<String, String>> lang;
        }
    }
}
