package com.digiwin.athena.datamap.povo.monitorrule;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.kg.monitorRule.DynamicConditionTypeEnum;

import java.util.HashMap;
import java.util.Map;

public class DynamicConditionDTO {

    private DynamicConditionTypeEnum type;

    public DynamicConditionTypeEnum getType() {
        return type;
    }

    public void setType(DynamicConditionTypeEnum type) {
        this.type = type;
    }

    public static DynamicConditionDTO parseFromDO(DynamicConditionConfigDO configDO) throws DWBusinessException {
        return parseFromDO(configDO, new HashMap());
    }

    public static DynamicConditionDTO parseFromDO(DynamicConditionConfigDO configDO, Map constantMap) throws DWBusinessException {
        if (configDO.getType() == DynamicConditionTypeEnum.SINGLE) {
            return DynamicSingleConditionDTO.parseFromDO(configDO, constantMap);
        } else if (configDO.getType() == DynamicConditionTypeEnum.AND_GROUP ||
                configDO.getType() == DynamicConditionTypeEnum.OR_GROUP) {
            return DynamicGroupConditionDTO.parseFromDO(configDO, constantMap);
        } else {
            throw new DWBusinessException("Cannot parse from from config to DynamicCondition");
        }
    }
}
