package com.digiwin.athena.datamap.povo.monitorrule;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.povo.monitorrule.ActionParamDTO;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MonitorRuleDTO {

    private String rule_id;
    private String tenant_id;
    private String action_id;
    private List<ActionParamDTO> action_params;
    private MonitorTypeEnum monitor_type;
    private String action_type;
    private String table;
    private List<ReturnColumnDTO> return_columns;
    private List<DefaultParamDTO> default_params;
    private DynamicConditionDTO dynamic_condition;
    private String product_name;
    private String product_uid;
    private TriggerDTO standard_polling_rule;
    private String alias;
    private String select_type;
    private List<JoinParamDTO> join_params;
    private MonitorRuleCategoryEnum category;
    // private ApiSettingDTO apiSetting;
    // private TimeSettingDTO timeSetting;
    private boolean is_continue;
    private String monitor_action_id;
    private List<DynamicParamsDO> dynamic_params;
    private List<StaticParamsDO> static_params;
    private Boolean is_polling_ids = false;
    // 运营单元层级
    private String eocLevel;
    // 多个排程日期
    private List<TriggerDTO> standard_polling_rules;

    private Extension extension;

    // 存储过程名称以及参数配置
    private String procedure_name;
    private List<ProcedureParam> procedure_input;

    // 是否需要去重，默认false.当设置true时必须配置bk_info
    private Boolean is_deduplication;
    private BkInfo2 bk_info;

    private String script;

    private Integer db_tag;

    private Integer execute_page_size;

    // 给sd的防抖冷却时间
    private Integer chill_interval;

    private String table_name;

    private String change_type;

    private String eoc_company_id;

    private String eoc_site_id;

    private List<ChangeFieldsDTO> change_fields;

    private List<DynamicConditionConfigDO> filter_condition;

    private List<DynamicParamsDO> filter_params;

    private Boolean is_need_eoc;

    private String eoc_company_key;

    private String eoc_site_key;
    /***
     * MQTT 和 CDC 两种侦测类型的使用这个字段
     */
    private String start_time;

    private String valid;

    private List<ObserveDO> observe;

    private String db_name;

    // 敏捷报表 场景
    private RuleSceneDTO scene;
    // 敏捷报表 执行引擎入参
    private Map<String, List<PullingParamDTO>> actionParamDefine;
    // 二次计算定义
    private Map<String, List<QueryStepDTO>> recast;
    /*****************************MQTT start类型的侦测参数************************/
    private String mqttTopic;
    private String mqttSource;
    // 基于dynamic_condition转化出来的过滤条件，例如MQTT类型的侦测，组户籍之间通过侦测参数配置一些过滤条件
    private List<JSONObject> conversionFilterCondition;

    public void setMqttSource(String mqttSource) {
        this.mqttSource = mqttSource;
    }

    public List<JSONObject> getConversionFilterCondition() {
        return conversionFilterCondition;
    }

    public void setConversionFilterCondition(List<JSONObject> conversionFilterCondition) {
        this.conversionFilterCondition = conversionFilterCondition;
    }

    public String getMqttTopic() {
        return mqttTopic;
    }

    public void setMqttTopic(String mqttTopic) {
        this.mqttTopic = mqttTopic;
    }

    public String getMqttSource() {
        return mqttSource;
    }

    /****************************MQTT end 类型的侦测参数*************************/

    public String getStart_time() {
        return start_time;
    }

    public void setStart_time(String start_time) {
        this.start_time = start_time;
    }

    public Integer getChill_interval() {
        return chill_interval;
    }

    public void setChill_interval(Integer chill_interval) {
        this.chill_interval = chill_interval;
    }

    public String getAction_type() {
        return action_type;
    }

    public void setAction_type(String action_type) {
        this.action_type = action_type;
    }

    public String getProcedure_name() {
        return procedure_name;
    }

    public void setProcedure_name(String procedure_name) {
        this.procedure_name = procedure_name;
    }

    public List<ProcedureParam> getProcedure_input() {
        return procedure_input;
    }

    public void setProcedure_input(List<ProcedureParam> procedure_input) {
        this.procedure_input = procedure_input;
    }

    public Boolean getIs_deduplication() {
        return is_deduplication;
    }

    public void setIs_deduplication(Boolean is_deduplication) {
        this.is_deduplication = is_deduplication;
    }

    public BkInfo2 getBk_info() {
        return bk_info;
    }

    public void setBk_info(BkInfo2 bk_info) {
        this.bk_info = bk_info;
    }

    public String getRule_id() {
        return rule_id;
    }

    public void setRule_id(String rule_id) {
        this.rule_id = rule_id;
    }

    public String getTenant_id() {
        return tenant_id;
    }

    public void setTenant_id(String tenant_id) {
        this.tenant_id = tenant_id;
    }

    public String getAction_id() {
        return action_id;
    }

    public void setAction_id(String action_id) {
        this.action_id = action_id;
    }

    public String getProduct_name() {
        return product_name;
    }

    public void setProduct_name(String product_name) {
        this.product_name = product_name;
    }

    public String getProduct_uid() {
        return product_uid;
    }

    public void setProduct_uid(String product_uid) {
        this.product_uid = product_uid;
    }

    public TriggerDTO getStandard_polling_rule() {
        return standard_polling_rule;
    }

    public void setStandard_polling_rule(TriggerDTO standard_polling_rule) {
        this.standard_polling_rule = standard_polling_rule;
    }

    public MonitorTypeEnum getMonitor_type() {
        return monitor_type;
    }

    public void setMonitor_type(MonitorTypeEnum monitor_type) {
        this.monitor_type = monitor_type;
    }

    public String getTable() {
        return table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public List<ActionParamDTO> getAction_params() {
        return action_params;
    }

    public void setAction_params(List<ActionParamDTO> action_params) {
        this.action_params = action_params;
    }

    public List<ReturnColumnDTO> getReturn_columns() {
        return return_columns;
    }

    public void setReturn_columns(List<ReturnColumnDTO> return_columns) {
        this.return_columns = return_columns;
    }

    public List<DefaultParamDTO> getDefault_params() {
        return default_params;
    }

    public void setDefault_params(List<DefaultParamDTO> default_params) {
        this.default_params = default_params;
    }

    public DynamicConditionDTO getDynamic_condition() {
        return dynamic_condition;
    }

    public void setDynamic_condition(DynamicConditionDTO dynamic_condition) {
        this.dynamic_condition = dynamic_condition;
    }

    public String getAlias() {
        return alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getSelect_type() {
        return select_type;
    }

    public void setSelect_type(String select_type) {
        this.select_type = select_type;
    }

    public List<JoinParamDTO> getJoin_params() {
        return join_params;
    }

    public void setJoin_params(List<JoinParamDTO> join_params) {
        this.join_params = join_params;
    }

    public void setJoinParamsFromDO(List<JoinParamDO> joinParams) throws DWBusinessException {
        List<JoinParamDTO> paras = new ArrayList<>(joinParams.size());
        for (JoinParamDO p : joinParams) {
            paras.add(JoinParamDTO.parseFromDO(p));
        }
        this.join_params = paras;
    }

    public MonitorRuleCategoryEnum getCategory() {
        return category;
    }

    public void setCategory(MonitorRuleCategoryEnum category) {
        this.category = category;
    }

    // public ApiSettingDTO getApiSetting() {
    // return apiSetting;
    // }
    //
    // public void setApiSetting(ApiSettingDTO apiSetting) {
    // this.apiSetting = apiSetting;
    // }
    //
    // public TimeSettingDTO getTimeSetting() {
    // return timeSetting;
    // }
    //
    // public void setTimeSetting(TimeSettingDTO timeSetting) {
    // this.timeSetting = timeSetting;
    // }

    public boolean isIs_continue() {
        return is_continue;
    }

    public void setIs_continue(boolean is_continue) {
        this.is_continue = is_continue;
    }

    public String getMonitor_action_id() {
        return monitor_action_id;
    }

    public void setMonitor_action_id(String monitor_action_id) {
        this.monitor_action_id = monitor_action_id;
    }

    public List<DynamicParamsDO> getDynamic_params() {
        return dynamic_params;
    }

    public void setDynamic_params(List<DynamicParamsDO> dynamic_params) {
        this.dynamic_params = dynamic_params;
    }

    public List<StaticParamsDO> getStatic_params() {
        return static_params;
    }

    public void setStatic_params(List<StaticParamsDO> static_params) {
        this.static_params = static_params;
    }

    public Boolean getIs_polling_ids() {
        return is_polling_ids;
    }

    public void setIs_polling_ids(Boolean is_polling_ids) {
        this.is_polling_ids = is_polling_ids;
    }

    public String getEocLevel() {
        return this.eocLevel;
    }
    public void setEocLevel(String eocLevel) {
        this.eocLevel = eocLevel;
    }

    public List<TriggerDTO> getStandard_polling_rules() {
        return standard_polling_rules;
    }

    public void setStandard_polling_rules(List<TriggerDTO> standard_polling_rules) {
        this.standard_polling_rules = standard_polling_rules;
    }

    public Extension getExtension() {
        return this.extension;
    }

    public void setExtension(Extension extension) {
        this.extension = extension;
    }

    public String getScript() {
        return script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public Integer getDb_tag() {
        return db_tag;
    }

    public void setDb_tag(Integer db_tag) {
        this.db_tag = db_tag;
    }

    public Integer getExecute_page_size() {
        return execute_page_size;
    }

    public void setExecute_page_size(Integer execute_page_size) {
        this.execute_page_size = execute_page_size;
    }

    public String getTable_name() {
        return table_name;
    }

    public void setTable_name(String table_name) {
        this.table_name = table_name;
    }

    public String getChange_type() {
        return change_type;
    }

    public void setChange_type(String change_type) {
        this.change_type = change_type;
    }

    public String getEoc_company_id() {
        return eoc_company_id;
    }

    public void setEoc_company_id(String eoc_company_id) {
        this.eoc_company_id = eoc_company_id;
    }

    public String getEoc_site_id() {
        return eoc_site_id;
    }

    public void setEoc_site_id(String eoc_site_id) {
        this.eoc_site_id = eoc_site_id;
    }

    public List<ChangeFieldsDTO> getChange_fields() {
        return change_fields;
    }

    public void setChange_fields(List<ChangeFieldsDTO> change_fields) {
        this.change_fields = change_fields;
    }

    public List<DynamicConditionConfigDO> getFilter_condition() {
        return filter_condition;
    }

    public void setFilter_condition(List<DynamicConditionConfigDO> filter_condition) {
        this.filter_condition = filter_condition;
    }

    public List<DynamicParamsDO> getFilter_params() {
        return filter_params;
    }

    public void setFilter_params(List<DynamicParamsDO> filter_params) {
        this.filter_params = filter_params;
    }

    public Boolean getIs_need_eoc() {
        return is_need_eoc;
    }

    public void setIs_need_eoc(Boolean is_need_eoc) {
        this.is_need_eoc = is_need_eoc;
    }

    public String getEoc_company_key() {
        return eoc_company_key;
    }

    public void setEoc_company_key(String eoc_company_key) {
        this.eoc_company_key = eoc_company_key;
    }

    public String getEoc_site_key() {
        return eoc_site_key;
    }

    public void setEoc_site_key(String eoc_site_key) {
        this.eoc_site_key = eoc_site_key;
    }

    public String getValid() {
        return valid;
    }

    public void setValid(String valid) {
        this.valid = valid;
    }

    public List<ObserveDO> getObserve() {
        return observe;
    }

    public void setObserve(List<ObserveDO> observe) {
        this.observe = observe;
    }

    public String getDb_name() {
        return db_name;
    }

    public void setDb_name(String db_name) {
        this.db_name = db_name;
    }

    public RuleSceneDTO getScene() {
        return scene;
    }

    public void setScene(RuleSceneDTO scene) {
        this.scene = scene;
    }

    public Map<String, List<PullingParamDTO>> getActionParamDefine() {
        return actionParamDefine;
    }

    public void setActionParamDefine(Map<String, List<PullingParamDTO>> actionParamDefine) {
        this.actionParamDefine = actionParamDefine;
    }

    public Map<String, List<QueryStepDTO>> getRecast() {
        return recast;
    }

    public void setRecast(Map<String, List<QueryStepDTO>> recast) {
        this.recast = recast;
    }
}
