package com.digiwin.athena.datamap.service;

import com.digiwin.app.service.AllowAnonymous;
import com.digiwin.app.service.DWService;
import com.digiwin.app.service.restful.DWRequestMapping;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.app.service.restful.DWRestfulService;

/**
 * 权限服务
 * @javadoc
 */
@DWRestfulService
public interface IAuthorityService extends DWService {

    /**
     * 根据应用code生成权限
     * @param appCode
     * @return
     * @throws Exception
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/authority/startProjectAuthorityByAppCode", method = {DWRequestMethod.POST})
    Object postStartProjectAuthorityByAppCode(String appCode) throws Exception;
}
