package com.digiwin.athena.datamap.service;

import com.digiwin.app.service.DWService;
import com.digiwin.app.service.restful.DWRequestMapping;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.app.service.restful.DWRestfulService;
import com.digiwin.athena.domain.core.Task;
import com.digiwin.athena.mechanism.dto.MechanismApiInfoDTO;
import com.digiwin.athena.mechanism.dto.MechanismComponentDTO;
import com.digiwin.athena.mechanism.dto.MechanismConfigReq;
import com.digiwin.athena.mechanism.dto.MechanismFilterDTO;

import java.util.List;

/**
 * 机制服务
 * @program: athena2_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2021-06-30 19:24
 * @javadoc
 **/
@DWRestfulService
public interface IMechanismService extends DWService {

    /**
     * 机制组件生效
     * @param component 机制组件
     * @return
     * @throws Exception
     */
    @DWRequestMapping(path = "/mechanism/componentApply", method = {DWRequestMethod.POST})
    public Object postComponentApply(MechanismComponentDTO component) throws Exception;

    /**
     * 机制组件失效
     * @param component 机制组件
     * @return
     * @throws Exception
     */
    @DWRequestMapping(path = "/mechanism/componentUnApply", method = {DWRequestMethod.POST})
    public Object postComponentUnApply(MechanismComponentDTO component) throws Exception;

    /**
     *
     * @param masterCode
     * @return
     * @throws Exception
     */
    List<Task> attachTasks(String masterCode) throws Exception;

    /**
     * 获取绑定的机制规则
     * @param req
     * @return
     * @throws Exception
     */
    @DWRequestMapping(path = "/mechanism/config", method = {DWRequestMethod.POST})
    public Object postMechanismConfig(MechanismConfigReq req) throws Exception;

    /**
     * 查询api运行后的结果
     * @param apiInfoDTO 查询入参
     * @return
     * @throws Exception
     */
    @DWRequestMapping(path = "/mechanism/postQueryApiResult", method = {DWRequestMethod.POST})
    Object postQueryApiResult(MechanismApiInfoDTO apiInfoDTO) throws Exception;

    /**
     * 判断业务条件是否满足
     * @param apiInfoDTO 查询入参
     * @return
     * @throws Exception
     */
    @DWRequestMapping(path = "/mechanism/judgeBusinessCondition", method = {DWRequestMethod.POST})
    Boolean judgeBusinessCondition(MechanismApiInfoDTO apiInfoDTO) throws Exception;

    /**
     * 根据业务条件过滤数据
     * @param mechanismFilterDTO 过滤条件
     * @return
     */
    @DWRequestMapping(path = "/mechanism/filterListByBusinessCondition", method = {DWRequestMethod.POST})
    Object postFilterListByBusinessCondition(MechanismFilterDTO mechanismFilterDTO);
}
