package com.digiwin.athena.datamap.service;

import com.digiwin.app.service.DWService;
import com.digiwin.app.service.restful.DWRequestMapping;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.app.service.restful.DWRestfulService;
import com.digiwin.athena.preset.PresetFeatureEnum;
import com.digiwin.athena.preset.Rule;
import com.digiwin.athena.preset.dto.RuleDTO;

import java.util.List;
import java.util.Map;

@DWRestfulService
public interface IRuleService extends DWService {

    @DWRequestMapping(path = "/rule/query", method = {DWRequestMethod.POST})
    Object postQuery(String activityId, int count, Map<PresetFeatureEnum, Object> features) throws Exception;

    @DWRequestMapping(path = "/rule/query", method = {DWRequestMethod.POST})
    Object postQuery(String activityId, int count) throws Exception;

    @DWRequestMapping(path = "/rule", method = {DWRequestMethod.PUT})
    Object put(RuleDTO rule) throws Exception;

    @DWRequestMapping(path = "/rule/save", method = {DWRequestMethod.POST})
    Object postSave(Rule rule) throws Exception;

    @DWRequestMapping(path = "/rule/batchSave", method = {DWRequestMethod.POST})
    Object postBatchSave(List<Rule> rules) throws Exception;

    @DWRequestMapping(path = "/rule/removeByPluginId", method = {DWRequestMethod.POST})
    Object postRemoveByPluginId(Rule rule) throws Exception;

    @DWRequestMapping(path = "/rule", method = {DWRequestMethod.DELETE})
    Object delete(String key) throws Exception;

    @DWRequestMapping(path = "/rule/batchSaveTanentRule", method = {DWRequestMethod.POST})
    Object postBatchSaveTanentRule(List<Rule> rules) throws Exception;

    @DWRequestMapping(path = "/rule/romeveTanentRule", method = {DWRequestMethod.POST})
    Object postRomeveTanentRule(String pluginId) throws Exception;
}