package com.digiwin.athena.datamap.service;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.service.AllowAnonymous;
import com.digiwin.app.service.DWService;
import com.digiwin.app.service.restful.DWRequestMapping;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.app.service.restful.DWRestfulService;
import com.digiwin.athena.datamap.povo.*;
import com.digiwin.athena.domain.core.Project;
import com.digiwin.athena.domain.core.Task;
import com.digiwin.athena.dto.ActivityBaseInfoVO;
import com.digiwin.athena.dto.TaskSchedule;

import javax.validation.Valid;
import java.util.List;
import java.util.Map;

/**
 * 视图服务
 * @javadoc
 */
@DWRestfulService
public interface IViewService extends DWService {

    /**
     * 根据项目code查询项目，包含pageView视图数据，项目任务目标，里程碑
     * @param request 查询参数 - 项目code
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/view/project", method = {DWRequestMethod.POST})
    Map<String, Object> postProject(ViewRequest request) throws DWException;

    /**
     * 根据项目code查询项目，包含pageView视图数据，项目任务目标，里程碑
     * @param request 查询参数 - 项目code
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/view/project2", method = {DWRequestMethod.POST})
    Map<String, Object> postProject2(ViewRequest request) throws DWException;

    /**
     * 根据条件查询项目，包含pageView视图数据，项目任务目标，里程碑
     * @param request 查询条件
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/view/projectList", method = {DWRequestMethod.POST})
    List<Object> postProjectList(ViewRequest request) throws DWException;

    /**
     * 根据条件查询项目，包含pageView视图数据，项目任务目标，里程碑
     * @param request 查询条件
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/view/projectList2", method = {DWRequestMethod.POST})
    List<Object> postProjectList2(ViewRequest request) throws DWException;

    /**
     * 根据条件查询项目
     * @param request 查询条件
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/view/projectListBasic", method = {DWRequestMethod.POST})
    List<Project> postProjectListBasic(ViewRequest request) throws DWException;

    /**
     * 根据条件查询任务
     * @param request 查询条件
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/view/taskList", method = {DWRequestMethod.POST})
    List<Task> postTaskList(ViewRequest request) throws DWException;

    /**
     * 根据条件查询签核任务
     * @param request 查询条件
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/view/taskListApprove", method = {DWRequestMethod.POST})
    List<ActivityBaseInfoVO> postTaskListApprove(ViewRequest request) throws DWException;

    /**
     * 根据项目code获取项目，包含项目下的任务
     * @param request 查询条件 - 项目code
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/view/tasks", method = {DWRequestMethod.POST})
    Map<String, Object> postTasks(ViewRequest request) throws DWException;

    /**
     * 根据条件查询任务定义
     * @param request 查询条件
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/view/task", method = {DWRequestMethod.POST})
    Map<String, Object> postTask(ViewRequest request) throws DWException;

    /**
     * 根据项目获取任务
     * @param request 查询条件
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/view/tasksByProject", method = {DWRequestMethod.POST})
    List<ActivityBaseInfoVO> postTasksByProject(ViewRequest request) throws DWException;

    // @DWRequestMapping(path = "/view/words", method = {DWRequestMethod.POST})
    // Object postWords(WordQuery request) throws DWException;
    //
    // @DWRequestMapping(path = "/view/wordsByAbility", method = {DWRequestMethod.POST})
    // Object postWordsByAbility(WordQuery request) throws DWException;

    /**
     * 根据邮件模板code获取邮件视图
     * @param request 查询条件
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/view/emails", method = {DWRequestMethod.POST})
    Object postEmails(ViewRequest request) throws DWException;

    /**
     * 根据邮件code获取邮件视图
     * @param request 查询条件
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/view/email", method = {DWRequestMethod.POST})
    Object postEmail(ViewRequest request) throws DWException;

    /**
     * 更新项目
     * @param project 项目
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/view/updateProject", method = {DWRequestMethod.POST})
    Object postUpdateProject(Project project) throws DWException;

    /**
     * 更新任务
     * @param task 任务
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/view/updateTask", method = {DWRequestMethod.POST})
    Object postUpdateTask(Task task) throws DWException;

    /**
     * 更新任务轻量级标签
     * @param task
     * @throws DWException
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/view/updateTaskScheduleFlag", method = {DWRequestMethod.POST})
    void postUpdateTaskScheduleFlag(Task task) throws DWException;

    /**
     * 更新任务轻量级侦测定义
     * @param taskSchedule
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/view/taskSchedule", method = {DWRequestMethod.POST})
    Object postTaskSchedule(TaskSchedule taskSchedule) throws DWException;

    /**
     * 删除任务轻量级侦测定义
     */
    @DWRequestMapping(path = "/view/deleteTaskSchedule", method = {DWRequestMethod.POST})
    Object postDeleteTaskSchedule(TaskSchedule taskSchedule) throws DWException;

    /**
     * 根据项目code获取项目任务
     * @param request 查询条件 - 项目code
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/view/projectTasks", method = {DWRequestMethod.POST})
    Object postProjectTasks(ViewRequest request) throws DWException;

    /**
     * 根据项目code和任务code获取发起当前签核任务的任务code
     * @param request 查询条件 - 项目code和任务code
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/view/activityStartTargetCode", method = {DWRequestMethod.POST})
    Map<String, Object> postActivityStartTargetCode(ViewRequest request) throws DWException;

    /**
     * 根据项目code获取项目输入数据
     * @param request 请求参数
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/view/projectInputData", method = {DWRequestMethod.POST})
    Map<String, Object> postProjectInputData(ViewRequest request) throws DWException;

    /**
     * 根据任务code获取任务输入数据
     * @param request 请求参数
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/view/taskInputData", method = {DWRequestMethod.POST})
    Object postTaskInputData(ViewRequest request) throws DWException;

    /**
     * 获取任务数据源和数据状态集合
     * @param request 请求参数
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/view/tasksForWord", method = {DWRequestMethod.POST})
    Object postTasksForWord(WordTaskReq request) throws DWException;
    /**
     * 获取任务数据源和数据状态集合
     * @param request 请求参数
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/view/tasksForWord2", method = {DWRequestMethod.POST})
    Object postTasksForWord2(WordTaskReq request) throws DWException;

    /**
     * 根据项目code获取侦测规则，开窗推荐和基础参数
     * @param request 请求参数
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/view/mechanism", method = {DWRequestMethod.POST})
    Object postMechanism(ViewRequest request) throws DWException;

    /**
     * 根据任务code获取开窗推荐
     * @param request
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/view/openWindows", method = {DWRequestMethod.POST})
    Object postOpenWindows(ViewRequest request) throws DWException;

    /**
     * 根据任务code获取开窗推荐
     * @param request
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/view/openWindowDecisions", method = {DWRequestMethod.POST})
    Object postOpenWindowDecisions(ViewRequest request) throws DWException;

    /**
     * 获取项目卡配置
     * @param request
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/view/cardConfig", method = {DWRequestMethod.POST})
    Object postCardConfig(ViewRequest request) throws DWException;

    /**
     * 查询任务卡分组条件配置项
     * @param request
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/view/newCardConfig", method = {DWRequestMethod.POST})
    List<WSConditionDTO> postNewCardConfig(ViewRequest request) throws DWException;

    /**
     * 查询配置的自定义筛选/排序/分组条件
     *
     * @param request
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/view/workbenchSetting", method = {DWRequestMethod.POST})
    List<WSConditionDTO> postWorkbenchSetting(WorkbenchSettingRequest request) throws DWException;

    /**
     * 查询配置的自定义筛选/排序/分组条件,可以同时查询筛选/排序/分组条件（or）
     *
     * @param request
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/view/workbenchSetting/configTypes", method = {DWRequestMethod.POST})
    Object postWorkbenchSettingByConfigTypes(WorkbenchSettingByConfigTypeRequest request) throws DWException;

    /**
     * 根据条件查询视图数据
     * @param request
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/view/pageUIElement", method = {DWRequestMethod.POST})
    Object getPageUIElement(ViewRequest request) throws DWException;

    /**
     * 查询pageView中taskCardField字段里的值
     * @param request
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/view/taskCardField", method = {DWRequestMethod.POST})
    List<TaskCardFieldVO> taskCardField(@Valid TaskCardFieldRequest request) throws DWException;
    /**
     *  根据code集合查询当前任务卡的名称
     * @param request
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/view/taskNamesByCodes", method = {DWRequestMethod.POST})
    List<Task> postTaskNamesByCodes(ViewRequest request) throws DWException;
    /**
     *  根据code集合查询当前项目卡的名称
     * @param request
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/view/projectNamesByCodes", method = {DWRequestMethod.POST})
    List<Project> postProjectNamesByCodes(ViewRequest request) throws DWException;

    /**
     * 查询pageUIElement中elements.systemHooks字段里的值
     * @param request
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/view/systemHooks", method = {DWRequestMethod.POST})
    List<Object> getSystemHooks(ViewRequest request) throws DWException;

    /**
     * 获取项目/任务/api级别bk信息
     * 支持项目/任务/api级别bk信息获取,
     * 对于项目和任务如果BkInfo已经配置bk信息则优先取该配置,如果没有则取inputData中的信息
     * api则必须要进行配置
     * @param request
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/view/bk", method = {DWRequestMethod.POST})
    BkResponse postBk(BkRequest request) throws DWException;

    /**
     * 仅有任务支持校验规则获取.
     * 校验规则以侦测规则形式进行配置.bkinfo中包含ruleId指向对应的校验信息
     * 如果传入任务code表示仅查询一个任务的校验信息,如果不传入则需要查询所有任务的校验信息并做合并Action_params和Return_columns两项
     * @param request
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/view/bkMeta", method = {DWRequestMethod.POST})
    BkResponse postBkMeta(BkRequest request) throws DWException;

    /**
     * 适配定制页面支持导出文件加密
     * @param request
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/view/tasksWithCustomize", method = {DWRequestMethod.POST})
    Object postTasksWithCustomize(TasksWithCustomizeRequest request) throws DWException;

    /**
     * 适配定制页面支持导出文件加密
     * @param request
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/view/activityInputDataEntityName", method = {DWRequestMethod.POST})
    Object postActivityInputDataEntityName(BkRequest request) throws DWException;

}
