package com.digiwin.athena.datamap.service;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.service.DWService;
import com.digiwin.app.service.restful.DWRequestMapping;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.app.service.restful.DWRequestParam;
import com.digiwin.app.service.restful.DWRestfulService;
import com.digiwin.athena.datamap.enums.WSConfigType;
import com.digiwin.athena.datamap.enums.WSPageCode;
import com.digiwin.athena.datamap.povo.WorkbenchSettingVO;

/**
 * 交付设计器，待办工作台配置
 * @javadoc
 */
@DWRestfulService
public interface IWorkbenchSettingService extends DWService {

    /**
     * 查询交付设计器，待办工作台配置
     *
     * @param pageCode
     * @param configType
     * @return
     */
    @DWRequestMapping(path = "/workbenchSetting", method = {DWRequestMethod.GET})
    WorkbenchSettingVO getWorkbenchSetting(@DWRequestParam WSPageCode pageCode,
                                           @DWRequestParam WSConfigType configType,
                                           @DWRequestParam Boolean appCondition) throws DWException;

}
