package com.digiwin.athena.datamap.service.impl;


import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.service.IDutyService;
import com.digiwin.athena.datamap.spi.DatamapEocService;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.kg.domain.Duty;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.repository.neo4j.DutyRepository;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @program: athena_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2020-09-22 09:06
 **/
@Lang
@Service
public class DataMapDutyService implements IDutyService {

    static Logger logger = LoggerFactory.getLogger(DataMapDutyService.class);

    static Log log = LogFactory.getLog(DataMapDutyService.class);

    @Autowired
    private DutyRepository repository;

    @Value("${iamApToken}")
    String appToken;

    @Autowired
    DatamapAppService datamapAppService;

    @Autowired
    DatamapEocService datamapEocService;

    @Override
    public Object getDutyByCode(String code) {


        return repository.findOneByCode(code);
    }

    @Override
    public Object getList() {

        List<Duty> dutyList = new ArrayList<>();
        repository.findAll().forEach(d->{
            dutyList.add(d);
        });

        return dutyList;
    }

    @Override
    public Object syncAllDuty() throws DWBusinessException {
        List<Duty> dutyList = (List<Duty>) getList();
        int count = 0;

        for(Duty d:dutyList){
            Map<String,Object> param = new HashMap<>();
            param.put("id",d.getCode());
            param.put("name",d.getName());
            param.put("modify",true);
          //  String resp = AthenaUtils.postEoc("/api/eoc/v2/duty",null, JSON.toJSONString(param), appToken);
            datamapEocService.syncDuty(param);
        }

        return null;
    }

    @Override
    public Object syncAllDuty(String token, String appCode, String tenantId) throws Exception {
        List<Duty> dutyList = (List<Duty>) getList();
        //根据应用查询所有关联Duty
        List<ApplicationRelation> applicationRelations = datamapAppService.getApplicationRelationByTypeAndAppCode("duty", appCode);
        List<String> appDutyCodes = CollectionUtils.isEmpty(applicationRelations) ?
                Collections.EMPTY_LIST : applicationRelations.stream().map(ApplicationRelation::getCode)
                .collect(Collectors.toList());
        //对dutyList过滤
        for (Duty d : dutyList) {
            if (appDutyCodes.contains(d.getCode())) {
                Map<String, Object> param = new HashMap<>();
                param.put("id", d.getCode());
                param.put("name", d.getName());
                param.put("modify", true);
                datamapEocService.syncDuty(param);
             //   String resp = AthenaUtils.postEoc("/api/eoc/v2/duty", null, JSON.toJSONString(param), token, appToken);
            }
        }

        return null;
    }

    @Override
    public Object syncAllDuty(String token) throws DWBusinessException {
        List<Duty> dutyList = (List<Duty>) getList();
        int count = 0;

        for(Duty d:dutyList){
            Map<String,Object> param = new HashMap<>();
            param.put("id",d.getCode());
            param.put("name",d.getName());
            param.put("modify",true);
         //   String resp = AthenaUtils.postEoc("/api/eoc/v2/duty",null, JSON.toJSONString(param), token, appToken);
            datamapEocService.syncDuty(param);
        }

        return null;
    }

    @Override
    public Object getTest(String p) {

        return null;
    }


//    @ApolloConfigChangeListener
//    private void someOnChange(ConfigChangeEvent changeEvent) {
//        System.out.println(changeEvent);
//    }
}
