package com.digiwin.athena.datamap.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWArgumentException;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.datamap.mechanism.component.ComponentHandler;
import com.digiwin.athena.datamap.mechanism.convert.MechanismParserFactory;
import com.digiwin.athena.datamap.mechanism.convert.parsers.judgeBasis.ConditionParser;
import com.digiwin.athena.datamap.povo.Product;
import com.digiwin.athena.datamap.service.IMechanismService;
import com.digiwin.athena.datamap.service.inner.DataMapKgDataPickService;
import com.digiwin.athena.datamap.service.inner.PluginService;
import com.digiwin.athena.datamap.spi.PresetLibraryService;
import com.digiwin.athena.domain.core.Task;
import com.digiwin.athena.dto.BasicQuery;
import com.digiwin.athena.kg.domain.VariableDefinition;
import com.digiwin.athena.kmservice.action.execution.ProductNameResolver;
import com.digiwin.athena.kmservice.cache.Cache;
import com.digiwin.athena.kmservice.cache.CacheConfig;
import com.digiwin.athena.kmservice.service.DataPickService;
import com.digiwin.athena.kmservice.utils.I18nUtils;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import com.digiwin.athena.mechanism.dto.MechanismApiInfoDTO;
import com.digiwin.athena.mechanism.dto.MechanismComponentDTO;
import com.digiwin.athena.mechanism.dto.MechanismConfigReq;
import com.digiwin.athena.mechanism.dto.MechanismFilterDTO;
import com.digiwin.athena.preset.Rule;
import com.mongodb.client.MongoCollection;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.mongodb.client.model.Filters.and;
import static com.mongodb.client.model.Filters.eq;

/**
 * @program: athena2_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2021-07-03 13:15
 **/
@MyExceptionHandler
@Slf4j
@Service
public class DataMapMechanismService implements IMechanismService {


    private static final String MECHANISM_VARIABLE_COLLECTION_NAME = "mechanismVariable";
    private static final String MECHANISM_VARIABLE_ID_KEY_NAME = "variableId";
    private static final String MECHANISM_VARIABLE_VALUE_FIELD_NAME = "value";
    private static final String TENANT_ID_KEY_NAME = "tenantId";
    private static final String MECHANISM_VARIABLE_INDEX_NAME = "mechanismVariable";
    private static final String MECHANISM_TENANT_PARADIGM = "mechanismTenantParadigm";
    private static final String SYSTEM = "SYSTEM";

    @Autowired
    DataPickService dataPickService;

    @Autowired
    DataMapKgDataPickService kdDataPickService;

    @Autowired
    PluginService pluginService;

    @Autowired
    ProjectService projectService;

    @Autowired
    List<ComponentHandler> componentHandlers;

    @Autowired
    PresetLibraryService presetLibraryService;

    @Autowired
    ConditionParser conditionParser;

    @Autowired
    MechanismParserFactory mechanismParserFactory;

    @Autowired
    ProductNameResolver productNameResolver;
    @Autowired
    @Qualifier("kgSystem")
    MongoTemplate kgSystem;
    @Autowired
    @Qualifier("kgTenant")
    MongoTemplate kgTenant;

    @Autowired
            @Lazy
    DataMapMechanismService self;

    @Override
    public Object postComponentApply(MechanismComponentDTO component) throws Exception {

        log.info("postComponentApply....{}", component);
        System.out.println("开始应用组件，component=" + JSON.toJSONString(component));

        Object obj = null;

        for (ComponentHandler handler : componentHandlers) {
            if (handler.accept(component)) {
                obj = handler.handlerApply(component);
                break;
            }
        }

        return obj;
    }

    @Override
    public Object postComponentUnApply(MechanismComponentDTO component) throws Exception {
        Object obj = null;
        log.info("postComponentUnApply....{}", component);
        for (ComponentHandler handler : componentHandlers) {
            if (handler.accept(component)) {
                obj = handler.handlerUnApply(component);
                break;
            }
        }

        return obj;
    }

    @Override
    public List<Task> attachTasks(String masterCode) throws DWBusinessException {

        Map<String, Object> param = new HashMap<>();
        param.put("masterCode", masterCode);
        param.put("assistantType", "MECHANISM");

        List<Task> tasks = dataPickService.find(BasicQuery.of(param, null), Task.class);

        return tasks;
    }

    @Override
    public Object postMechanismConfig(MechanismConfigReq req) throws DWException {
        Map<String, Object> result = new HashMap<>();
        if (null == req.getAction()) {
            return result;
        }
        switch (req.getAction()) {
            case "rules":
                result.put("rules", mechanismRules(req.getCode()));
                break;
            default:;

        }

        return result;
    }

    public List<Rule> mechanismRules(String taskCode) {
        List<Rule> rulesMech = new ArrayList<>();
        try {
            List<Rule> rulesAll = presetLibraryService.rules(taskCode);
            for (Rule r : rulesAll) {
                if (null != r.getPluginId()) {
                    rulesMech.add(r);
                }
            }
        } catch (Exception e) {
            log.error("mechanismRules error", e);
        }
        return rulesMech;
    }

    @Override
    public Object postQueryApiResult(MechanismApiInfoDTO apiInfoDTO) {
        log.info("MechanismService.postQueryApiResult beginning...apiInfoDTO={}", apiInfoDTO);
        JSONObject result = new JSONObject();
        Object handleResult = mechanismParserFactory.getAbilityHandlerByType(apiInfoDTO.getAbilityType()).parseScene(apiInfoDTO);
        result.put("meta_data_list", handleResult);
        return result;
    }

    @Override
    public Boolean judgeBusinessCondition(MechanismApiInfoDTO apiInfoDTO) {
        log.info("MechanismService.judgeBusinessCondition beginning...apiInfoDTO={}", apiInfoDTO);
        Object handleResult = mechanismParserFactory.getAbilityHandlerByType(apiInfoDTO.getAbilityType()).parseScene(apiInfoDTO);
        JSONArray handleResultJson = JSONObject.parseArray(JSON.toJSONString(handleResult));
        return !CollectionUtils.isEmpty(handleResultJson);
    }

    @Override
    public Object postFilterListByBusinessCondition(MechanismFilterDTO mechanismFilterDTO) {
        log.info("MechanismService.postFilterListByBusinessCondition beginning...mechanismFilterDTO={}", mechanismFilterDTO);
        Map<String, Object> resultMap = conditionParser.parseSingleScene(mechanismFilterDTO.getGroups(), mechanismFilterDTO.getDataList(), null, null);
        log.info("MechanismService.postFilterListByBusinessCondition ending...resultMap={}", resultMap);
        if (!CollectionUtils.isEmpty(resultMap)) {
            return resultMap.get("list");
        }
        return null;
    }




    private Map<String, Object> getStringObjectMap(String variableName, String tenantId, boolean isGetDefault) throws DWBusinessException {
        if (variableName == null || variableName.isEmpty()) {
            throw new DWArgumentException("variable", I18nUtils.getValue("knowledgegraph.variableEmpty"));
        }
        Map<String, Object> result = new HashMap<String, Object>();
        //add by srj 6609需求，是否依赖地端根据用户是否设置产品的公司或域信息确认
        if(StringUtils.equals(variableName, "hasGroundEnd")){
            Object hasGroundEnd = self.getHasGroundEnd();
            result.put(variableName, hasGroundEnd);
            result.put(TENANT_ID_KEY_NAME, tenantId);
            return result;
        }
        MongoCollection<Document> col = kgTenant.getCollection(MECHANISM_VARIABLE_COLLECTION_NAME);
        //改为使用公用mongodb
        Document doc = col.find(and(eq(MECHANISM_VARIABLE_ID_KEY_NAME, variableName), eq(TENANT_ID_KEY_NAME,
                tenantId))).first();

        if (doc != null) {
            Object val = doc.get(MECHANISM_VARIABLE_VALUE_FIELD_NAME);
            if (isGetDefault) {//需要设默认值 则尝试获取variableDefition做比对
                val = getDefValue(val, variableName);
            }
            result.put(variableName, val);
            result.put(TENANT_ID_KEY_NAME, doc.get("tenantId"));
        } else {
            if (!isGetDefault) {
                return result;
            }
            //没有找到租户下的参数变量值 则使用预设值
            VariableDefinition def = getDefinition(variableName);
            if (def != null) {
                result.put(variableName, def.getDefaultValue());
                result.put(TENANT_ID_KEY_NAME, tenantId);
            }
        }
        return result;
    }

    public VariableDefinition getDefinition(String variableName) throws DWBusinessException {
        return kdDataPickService.findByCode(variableName, VariableDefinition.class, "variableDefinition");
    }


    @Cache(key = CacheConfig.cachePrefix_tenant+"'getHasGroundEnd'")
    public Object getHasGroundEnd() throws DWBusinessException {
        String tenantId = ServiceUtils.getTenantId();
        List<String> allSteadyProductList = (List<String>)getAllSteadyProduct();
        try {
            Object o = productNameResolver.tenantProductOperationList(tenantId);
            JSONObject jsonObject = JSON.parseObject(JSON.toJSONString(o));
            JSONArray gateways = jsonObject.getJSONArray("prod_eoc_mapping");
            if(gateways == null){
                return "N";
            }
            for(int i = 0; i < gateways.size(); i++){
                String prod_name = gateways.getJSONObject(i).getString("prod_name");
                if(allSteadyProductList.contains(prod_name)){
                    return (!ObjectUtils.isEmpty(gateways.getJSONObject(i).get("org_type_company"))
                            || !ObjectUtils.isEmpty(gateways.getJSONObject(i).get("org_type_region"))) ? "Y" : "N";
                }

            }
        } catch (Exception e) {
            log.error("hasGroundEnd获取产品信息失败:{}" , e);
            return "N";
        }
        return "N";
    }

    public Object getAllSteadyProduct() throws DWBusinessException {
        Query query = new Query();
        query.fields().include("product");
        List<Product> products = this.kgSystem.find(query, Product.class);
        return products.stream()
                .map(Product::getProduct)
                .distinct()
                .collect(Collectors.toList());
    }

    private Object getDefValue(Object val, String variableName) throws DWBusinessException {
        //存值为List的情况下处理
        if (val instanceof List) {
            //获取 key
            String key = null;
            String valKey = null;
            VariableDefinition def = getDefinition(variableName);
            if (def != null) {
                if (StringUtils.equals(def.getDisplayType(),"TABLE") && def.getDisplayTypeDefinition() != null && def.getDisplayTypeDefinition() instanceof Map) {
                    Map typeDef = (Map) def.getDisplayTypeDefinition();
                    //仅处理 TABLE 且为 radioboxgroup 的参数
                    if (typeDef.get("category").equals("radioboxgroup") && typeDef.get("columns") instanceof List) {
                        List cols = (List) typeDef.get("columns");
                        if (!CollectionUtils.isEmpty(cols) && cols.get(0) instanceof Map) {
                            Map col = (Map) cols.get(0);
                            key = (String) col.get("key");
                            List exts = (List) col.get("extends");
                            if (!CollectionUtils.isEmpty(exts) && exts.get(0) instanceof Map) {
                                Map ext = (Map) exts.get(0);
                                valKey = (String) ext.get("key");
                            }
                        }
                    }
                }

                if (StringUtils.isEmpty(key) || StringUtils.isEmpty(valKey)) {
                    return val;
                }

                if (def.getDefaultValue() != null && def.getDefaultValue() instanceof List) {
                    List<Map> defValList = (List<Map>) def.getDefaultValue();
                    List<Map> valList = (List<Map>) val;
                    for (Map defVal : defValList) {
                        boolean exist = false;
                        for (Map v : valList) {
                            if (defVal.get(key).equals(v.get(key))) {
                                exist = true;
                                break;
                            }
                        }
                        if (!exist) {//在已存的值里没有找到的默认值 添加到返回值中
                            Map d = new HashMap();
                            d.put(key, defVal.get(key));
                            d.put(valKey, defVal.get(valKey));
                            valList.add(d);
                        }
                    }
                }
            }
        }
        return val;
    }



    public Object getVariable(String variableName, String tenantId) throws DWBusinessException {
        log.info("enter getVariable "+variableName+" "+tenantId);
        Map<String, Object> result = getStringObjectMap(variableName, tenantId, true);
        return result;
    }


}
