package com.digiwin.athena.datamap.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.alibaba.fastjson.TypeReference;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.datamap.domain.FatPageView;
import com.digiwin.athena.kmservice.constants.KnowledgeGraphDb;
import com.digiwin.athena.datamap.domain.TaskCardFields;
import com.digiwin.athena.datamap.enums.BusinessMessageSourceMethod;
import com.digiwin.athena.datamap.enums.SourceType;
import com.digiwin.athena.datamap.enums.WSConfigType;
import com.digiwin.athena.datamap.enums.WSPageCode;
import com.digiwin.athena.datamap.povo.*;
import com.digiwin.athena.datamap.povo.monitorrule.ActionParamDTO;
import com.digiwin.athena.datamap.povo.monitorrule.MonitorRuleDTO;
import com.digiwin.athena.datamap.povo.monitorrule.ReturnColumnDTO;
import com.digiwin.athena.datamap.service.IViewService;
import com.digiwin.athena.datamap.service.inner.DataMapPickService;
import com.digiwin.athena.datamap.spi.*;
import com.digiwin.athena.datamap.utils.CommonUtils;
import com.digiwin.athena.domain.common.*;
import com.digiwin.athena.domain.component.ComponentTypeEnum;
import com.digiwin.athena.domain.core.*;
import com.digiwin.athena.domain.core.flow.FlowGraph;
import com.digiwin.athena.domain.core.view.EmailView;
import com.digiwin.athena.domain.core.view.PageUIElement;
import com.digiwin.athena.domain.core.view.PageView;
import com.digiwin.athena.domain.definition.TaskRef;
import com.digiwin.athena.domain.definition.actions.ActionParam;
import com.digiwin.athena.domain.definition.actions.DataEntityMetadataDTO;
import com.digiwin.athena.domain.definition.times.ExpectedDuration;
import com.digiwin.athena.domain.definition.times.TimeDefinition;
import com.digiwin.athena.dto.ActivityBaseInfoVO;
import com.digiwin.athena.dto.ApiDataFieldMetadataDTO;
import com.digiwin.athena.dto.BasicQuery;
import com.digiwin.athena.dto.TaskSchedule;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kmservice.utils.MergeUtil;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import com.digiwin.athena.mechanism.entity.OpenWindowDecision;
import com.digiwin.athena.preset.Rule;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.jayway.jsonpath.JsonPath;
import com.mongodb.client.model.Filters;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.util.*;
import java.util.stream.Collectors;

@MyExceptionHandler
@Service
@Lang
public class DataMapViewService implements IViewService {

    private static Logger log = LoggerFactory.getLogger(DataMapViewService.class);

    @Autowired
    @Qualifier("dataMapSystem")
    MongoTemplate mongoTemplate;

    @Autowired
    ProjectService projectService;

    @Autowired
    DataMapTaskService dataMapTaskService;

    @Autowired
    DataMapPickService dataPickService;

    @Autowired
    SmartDataService smartDataService;

    @Autowired
    PresetLibraryService presetLibraryService;

    @Autowired
    DataMapKgService dataMapKgService;

    @Autowired
    GenericService genericService;

    @Autowired
    DataMapTagSystemService dataMapTagSystemService;

    @Autowired
    private IKnowledgeGraphService knowledgeGraphService;

    @Autowired
    private DataMapActivityService dataMapActivityService;

    @Autowired
    @Lazy
    RecordService recordService;

    @Override
    public Map<String, Object> postProject(ViewRequest request) throws DWException {
        if (null == request.getProjectCode()) {
            return null;
        }
        BasicQuery query = BasicQuery.of(new HashMap<>(), request.getEocInfo());
        query.getQuery().put("code", request.getProjectCode());
        Project project = dataPickService.findOne(query, Project.class);
        Map<String, Object> view = projectToView(project, request.getEocInfo());
        return view;
    }

    public Object postAppCardFields(AppCardFieldsVO request) throws DWException {
        String application = request.getApplication();
        Query query = Query.query(Criteria.where("application").is(application));
        List<PageView> pageViews = mongoTemplate.find(query, PageView.class);
        if (org.springframework.util.CollectionUtils.isEmpty(pageViews)) {
            return Collections.EMPTY_LIST;
        }
        List<TaskCardFields> taskCardFieldsList = new LinkedList<>();
        pageViews.forEach(item -> {
            Map<String, Object> pages = item.getPages();
            if (!org.springframework.util.CollectionUtils.isEmpty(pages)) {
                Map<String, Object> taskCard = (Map<String, Object>) pages.get("task-card");
                if (!org.springframework.util.CollectionUtils.isEmpty(taskCard)) {
                    List<Map> dataStates = (List<Map>) taskCard.get("dataStates");
                    if (!org.springframework.util.CollectionUtils.isEmpty(dataStates)) {
                        List<Map> cardFieldsDataStates = dataStates.stream().filter(map -> "all".equals(map.get("type")))
                                .collect(Collectors.toList());
                        if (!org.springframework.util.CollectionUtils.isEmpty(cardFieldsDataStates)) {
                            Map<String, Object> cardField = cardFieldsDataStates.get(0);
                            TaskCardFields taskCardFields = JSON.parseObject(JSON.toJSONString(cardField), TaskCardFields.class);
                            taskCardFields.setCode(item.getCode());
                            taskCardFieldsList.add(taskCardFields);
                        }
                    }
                }
            }
        });
        return taskCardFieldsList;
    }

    @Override
    public Map<String, Object> postProject2(ViewRequest request) throws DWException {
        if (null == request.getProjectCode()) {
            return null;
        }
        com.digiwin.athena.kmservice.utils.ServiceUtils.getContext().setEocInfo(request.getEocInfo());
        Project project = projectService.getProjectByCode(request.getProjectCode());
        Map<String, Object> view = projectToView(project, request.getEocInfo());
        return view;
    }

    @Override
    public List<Object> postProjectList(ViewRequest request) throws DWException {

        List<Project> projects = dataPickService.findBetters(BasicQuery.of(request.getQuery(), request.getEocInfo()), Project.class);
        List<Object> views = new ArrayList<>();
        projects.forEach(p -> {
            try {
                views.add(projectToView(p, request.getEocInfo()));
            } catch (DWException e) {
                log.error(e.toString());
            }
        });

        return views;
    }

    @Override
    public List<Object> postProjectList2(ViewRequest request) throws DWException {
        boolean cn = ServiceUtils.getCurrentLocale().equals("zh_CN");
        List<Project> projects = dataPickService.findBetters(BasicQuery.of(request.getQuery(), request.getEocInfo()), Project.class);
        List<Object> views = new ArrayList<>();
        // 操作类型 未来会从定义取 现在只能写死
        List<Object> operations = new ArrayList<>();
        HashMap<Object, Object> map1 = new HashMap<>();
        map1.put("value", "open");
        map1.put("label", cn ? "打开时" : "打開時");
        map1.put("lang", ImmutableMap.of("label", ImmutableMap.of("zh_CN", "打开时", "zh_TW", "打開時")));
        operations.add(map1);
        HashMap<Object, Object> map2 = new HashMap<>();
        map2.put("value", "update");
        map2.put("label", cn ? "修改时" : "修改時");
        map2.put("lang", ImmutableMap.of("label", ImmutableMap.of("zh_CN", "修改时", "zh_TW", "修改時")));
        operations.add(map2);
        projects.forEach(p -> {
            try {
                Map<String, Object> map = projectToView2(p, request.getEocInfo());
                map.put("operations", operations);
                views.add(map);
            } catch (DWException e) {
                log.error(e.toString());
            }
        });

        return views;
    }

    @Override
    public List<Project> postProjectListBasic(ViewRequest request) throws DWException {
        List<Project> projects = dataPickService.find(BasicQuery.of(request.getQuery(), request.getEocInfo()), Project.class);
        return projects;
    }

    @Override
    public List<Task> postTaskList(ViewRequest request) throws DWException {
        List<Task> tasks = dataPickService.find(BasicQuery.of(request.getQuery(), request.getEocInfo()), Task.class);
        return tasks;
    }

    @Override
    public List<ActivityBaseInfoVO> postTaskListApprove(ViewRequest request) throws DWException {
        List<Task> tasks = postTaskList(request);
        List<ActivityBaseInfoVO> result = new ArrayList<>();
        String locale = ServiceUtils.getCurrentLocale();

        List<String> codes = new ArrayList<>();
        for (Task t : tasks) {
            codes.add(t.getCode());
            ActivityBaseInfoVO vo = new ActivityBaseInfoVO();
            vo.setTaskId(t.getCode());
            request.setTaskCode(t.getCode());
            Map map = (Map) postTask(request);
            if (map.get("dynamicApproves") != null) {
                Object dynamicApproves = map.get("dynamicApproves");
                if (dynamicApproves instanceof List) {
                    List<Map<Object, Object>> subApproveMap = new ArrayList<>();
                    List dynamicApprovesList = (List) dynamicApproves;
                    for (Object o : dynamicApprovesList) {
                        if (o instanceof Map) {
                            Map o1 = (Map) o;
                            subApproveMap.add(o1);
                        }
                    }
                    vo.setSubApprove(subApproveMap);
                }
            }
            vo.setAllowSubLevel(t.getAllowSubLevel());
            vo.setNeedEnableApprove(t.getNeedEnableApprove());
            vo.setActivityId(t.getCode());
            vo.setActivityName(t.getName());
            if (null != locale && null != t.getLang() && null != t.getLang().get("name") && null != t.getLang().get("name").get(locale)) {
                vo.setActivityName(t.getLang().get("name").get(locale));
            }

            result.add(vo);
        }
        // 查询签核任务需要把任务对应的项目也查出来
        Map<String, Object> q2 = new HashMap<>();
        q2.put("mainLineTasks", codes);
        List<Project> projects = dataPickService.find(BasicQuery.of(q2, request.getEocInfo()), Project.class);
        for (ActivityBaseInfoVO vo : result) {
            for (Project p : projects) {
                if (p.getMainLineTasks().contains(vo.getActivityId())) {
                    if ("mainline".equals(p.getExecuteType())) { // 手动发起项目判断是否主项目
                        vo.setMainLineTaskId(p.getCode());
                        vo.setManualAble(p.getManualAble());
                        vo.setAuthorityPrefix(p.getAuthorityPrefix());
                    }
                    vo.setTaskId(p.getCode());
                    vo.setTaskName(p.getName());
                    if (null != locale && null != p.getLang() && null != p.getLang().get("name") && null != p.getLang().get("name").get(locale)) {
                        vo.setTaskName(p.getLang().get("name").get(locale));
                    }
                }
            }
        }

        return result;
    }

    /**
     * 将项目对象转换成视图map集合，包含pageView视图数据，项目任务目标，里程碑
     * @param project 项目
     * @param eocInfo 运营单元信息
     * @return
     * @throws DWException
     */
    private Map<String, Object> projectToView(Project project, Map<String, Object> eocInfo) throws DWException {

        if (null == project) {
            return null;
        }
        boolean comeFromDesigner = null == ServiceUtils.getHeader("designer") ? false : true;
        String locale = com.digiwin.athena.kmservice.utils.ServiceUtils.getLocale();
        String tenantId = com.digiwin.athena.kmservice.utils.ServiceUtils.getTenantId();
        Map<String, Object> viewMap = MergeUtil.mergeObjectToMap(new HashMap<>(), project, null);
        viewMap.put("taskId", project.getCode());
        viewMap.put("sequence", project.getSequence());
        viewMap.put("chargePerson", project.getPersonInCharge());
        viewMap.put("notifyParty", project.getNotifyParty());
        viewMap.put("presetVariables", project.getPresetVariables());

        if (ProjectType.BUSINESS.equalsIgnoreCase(project.getType())) {
            viewMap.put("completedReport", true);
        }
        // 在项目中设置pageView数据
        if (null != project.getPageCode()) {
            PageView page = dataPickService.findBetter(project.getPageCode(), PageView.class);
            if (null != page) {
                page.setName(null);
                MergeUtil.mergeObjectToMap(viewMap, page, Arrays.asList("id", "code", "name"));
            }
        }
        if (Boolean.TRUE.equals(project.getManualAble())) {
            Map<String, Object> param = new HashMap<>();
            param.put("project", project.getCode());
            param.put("pageType", 1);
            List<PageView> pageViewList = dataPickService.findBetters(BasicQuery.of(param, eocInfo), PageView.class);
            viewMap.put("presetActivities", pageViewList);
        }

        if (null != project.getLang()) {
            if (null != locale && null != project.getLang().get("name") && null != project.getLang().get("name").get(locale)) {
                viewMap.put("name", project.getLang().get("name").get(locale));
            }
            viewMap.put("taskName", project.getLang().get("name"));
            viewMap.put("sourceName", project.getLang().get("sourceName"));
            viewMap.put("dueDateName", project.getLang().get("dueDateName"));
            project.getLang().remove("name");
            project.getLang().remove("sourceName");
            project.getLang().remove("dueDateName");
        }
        if (null != project.getTarget()) {
            viewMap.put("taskTargetId", project.getTarget().getCode());
            viewMap.put("taskTargetName", project.getTarget().getName());
            if (null != project.getTarget().getLang()) {
                viewMap.put("taskTargetName", project.getTarget().getLang().get("name"));
                project.getTarget().getLang().remove("name");
            }
        }
        List<Task> activities = new ArrayList<>();
        if (null == project.getPhases()) {
            if (null != project.getMainLineTasks() && project.getMainLineTasks().size() > 0) {
                Map<String, Object> q = new HashMap<>();
                q.put("code", project.getMainLineTasks());
                List<Task> tasks = dataPickService.find(BasicQuery.of(q, eocInfo), Task.class);
                if (null != tasks && tasks.size() > 0) {
                    Map<String, Task> codeTasks = new HashMap<>();
                    Map<String, String> taskNames = new HashMap<>();
                    tasks.forEach(tv -> {
                        activities.add(tv);
                        codeTasks.put(tv.getCode(), tv);
                        taskNames.put(tv.getCode(), tv.getName());
                        if (null != tv.getLang() && null != tv.getLang().get("name") && null != tv.getLang().get("name").get(locale)) {
                            taskNames.put(tv.getCode(), tv.getLang().get("name").get(locale));
                        }
                    });
                    viewMap.put("taskNames", taskNames);
                    // 为了兼容之前的项目定义，如果没有定义phase，则根据mainline定义每个任务生成一个阶段
                    if (null == project.getPhases() || project.getPhases().size() == 0) {
                        List<Phase> phases = new ArrayList<>();
                        project.getMainLineTasks().forEach(tcode -> {
                            Task tv = codeTasks.get(tcode);
                            if (null != tv) {
                                Phase phase = new Phase();
                                phase.setCode(tv.getCode());
                                phase.setName(tv.getName());
                                if (null != tv.getLang() && null != tv.getLang().get("name") && null != tv.getLang().get("name").get(locale)) {
                                    phase.setName(tv.getLang().get("name").get(locale));
                                }
                                phase.setTaskCodes(new ArrayList<>());
                                phase.setTasks(new ArrayList<>());
                                phase.getTaskCodes().add(tv.getCode());
                                TaskRef ref = new TaskRef();
                                ref.setCode(tv.getCode());
                                ref.setName(tv.getName());
                                ref.setLang(tv.getLang());
                                phase.getTasks().add(ref);
                                phases.add(phase);
                            }
                        });
                        viewMap.put("phases", phases);
                    }
                }
            }

        } else {
            // 兼容流程引擎控制里程碑显示或隐藏，任务引擎的任务执行跳过应用自己控制流程
            if (!comeFromDesigner) {
                Iterator<Phase> refs2 = project.getPhases().iterator();
                while (refs2.hasNext()) {
                    Phase p = refs2.next();
                    if (p.getConfig() != null && null != p.getConfig().get(PhaseConfigKey.skipActionId)) {
                        String skipActionId = (String) p.getConfig().get(PhaseConfigKey.skipActionId);
                        String skipMechanismKey = (String) p.getConfig().get(PhaseConfigKey.skipMechanismKey);
                        if (null == skipMechanismKey) {
                            skipMechanismKey = PhaseConfigKey.skipMechanismDefaultValue;
                        }
                        SmartDataExecutePo po = new SmartDataExecutePo();
                        po.setTenantId(tenantId);
                        po.setActionId(skipActionId);
                        Object obj = smartDataService.engineExecute(po);
                        if (null != obj) {
                            Map resp = (Map) obj;
                            Object inv_scrap = resp.get(skipMechanismKey);
                            if (Boolean.FALSE.equals(inv_scrap)) {
                                refs2.remove();
                            }
                        }
                    }
                }
            }

            List<String> codes = new ArrayList<>();
            Map<String, TaskRef> reftemp = new HashMap<>();
            project.getPhases().forEach(phase -> {
                if (null != phase.getTaskCodes()) {
                    codes.addAll(phase.getTaskCodes());
                    // todo 兼容
                    if (null == phase.getTasks()) {
                        phase.setTasks(new ArrayList<>());
                        phase.getTaskCodes().forEach(t -> {
                            TaskRef ref = new TaskRef();
                            ref.setCode(t);
                            phase.getTasks().add(ref);
                            reftemp.put(t, ref);
                        });
                    }
                }
            });
            if (codes.size() > 0) {
                Map<String, Object> q = new HashMap<>();
                q.put("code", codes);
                List<Task> tasks = dataPickService.find(BasicQuery.of(q, null), Task.class);
                Map<String, String> taskNames = new HashMap<>();
                tasks.forEach(tv -> {
                    activities.add(tv);
                    taskNames.put(tv.getCode(), tv.getName());
                    if (null != tv.getLang() && null != tv.getLang().get("name") && null != tv.getLang().get("name").get(locale)) {
                        taskNames.put(tv.getCode(), tv.getLang().get("name").get(locale));
                    }
                    TaskRef ref = reftemp.get(tv.getCode());
                    if (null != ref) {
                        ref.setLang(tv.getLang());
                        ref.setName(tv.getName());
                    }
                });
                viewMap.put("taskNames", taskNames);
            }

        }

        activities.forEach(tv -> {
            tv.setActivityId(tv.getCode());
            tv.setActivityName(tv.getName());
            if (null != tv.getLang()) {
                tv.setActivityName(tv.getLang().get("name"));
            }
        });

        viewMap.put("activities", activities);

        // 如果不是从设计器过来的请求则删除里程碑内隐藏的任务
        if (!comeFromDesigner) {
            List<Phase> phases = (List<Phase>) viewMap.get("phases");
            if (null != phases) {
                phases.forEach(p -> {
                    if (null != p.getTasks()) {
                        Iterator<TaskRef> refs = p.getTasks().iterator();
                        while (refs.hasNext()) {
                            TaskRef ref = refs.next();
                            if (Boolean.TRUE.equals(ref.getHidden())) {
                                refs.remove();
                            }
                        }
                    }
                });
                Iterator<Phase> refs2 = phases.iterator();
                while (refs2.hasNext()) {
                    Phase p = refs2.next();
                    if (p.getTasks() == null || p.getTasks().size() == 0) {
                        refs2.remove();
                    }
                }

            }
        }
        return viewMap;
    }

    private Map<String, Object> projectToView2(Project project, Map<String, Object> eocInfo) throws DWException {

        if (null == project) {
            return null;
        }

        String locale = ServiceUtils.getCurrentLocale();
        String tenantId = ServiceUtils.getTenantId();
        Map<String, Object> viewMap = MergeUtil.mergeObjectToMap(new HashMap<>(), project, null);
        viewMap.put("taskId", project.getCode());
        viewMap.put("sequence", project.getSequence());
        viewMap.put("chargePerson", project.getPersonInCharge());
        viewMap.put("presetVariables", project.getPresetVariables());

        if (ProjectType.BUSINESS.equalsIgnoreCase(project.getType())) {
            viewMap.put("completedReport", true);
        }
        if (null != project.getPageCode()) {
            PageView page = dataPickService.findBetter(project.getPageCode(), PageView.class);
            if (null != page) {
                page.setName(null);
                MergeUtil.mergeObjectToMap(viewMap, page, null);
            }
        }
        if (Boolean.TRUE.equals(project.getManualAble())) {
            Map<String, Object> param = new HashMap<>();
            param.put("project", project.getCode());
            param.put("pageType", 1);
            List<PageView> pageViewList = dataPickService.findBetters(BasicQuery.of(param, eocInfo), PageView.class);
            viewMap.put("presetActivities", pageViewList);
        }

        if (null != project.getLang()) {
            if (null != locale && null != project.getLang().get("name") && null != project.getLang().get("name").get(locale)) {
                viewMap.put("name", project.getLang().get("name").get(locale));
            }
            viewMap.put("taskName", project.getLang().get("name"));
            viewMap.put("sourceName", project.getLang().get("sourceName"));
            viewMap.put("dueDateName", project.getLang().get("dueDateName"));
            project.getLang().remove("name");
            project.getLang().remove("sourceName");
            project.getLang().remove("dueDateName");
        }
        if (null != project.getTarget()) {
            viewMap.put("taskTargetId", project.getTarget().getCode());
            viewMap.put("taskTargetName", project.getTarget().getName());
            if (null != locale && null != project.getTarget().getLang()
                    && null != project.getTarget().getLang().get("name") && null != project.getTarget().getLang().get("name").get(locale)) {
                viewMap.put("taskTargetName", project.getTarget().getLang().get("name"));
                project.getTarget().getLang().remove("name");
            }

        }

        List<Task> activities = new ArrayList<>();
        Set<String> taskCodes = new HashSet<>();
        if (null != project.getPhases()) {
            project.getPhases().forEach(phase -> {
                if (null != phase.getTaskCodes()) {
                    taskCodes.addAll(phase.getTaskCodes());
                }
            });
        }
        if (null != project.getMainLineTasks()) {
            taskCodes.addAll(project.getMainLineTasks());
        }

        if (taskCodes.size() > 0) {
            Map<String, Object> q = new HashMap<>();
            q.put("code", taskCodes);
            activities = dataPickService.findBetters(BasicQuery.of(q, eocInfo), Task.class);
        }

        activities.forEach(tv -> {
            tv.setActivityId(tv.getCode());
            tv.setActivityName(tv.getName());
            if (null != tv.getLang() && null != locale && null != tv.getLang().get("name") && null != tv.getLang().get("name").get(locale)) {
                tv.setActivityName(tv.getLang().get("name").get(locale));
                tv.setName(tv.getLang().get("name").get(locale));
            }
        });

        viewMap.put("activities", activities);

        return viewMap;
    }

    @Override
    public Map<String, Object> postTasks(ViewRequest request) throws DWException {
        com.digiwin.athena.kmservice.utils.ServiceUtils.getContext().setEocInfo(request.getEocInfo());
        Assert.notNull(request.getProjectCode(), "projectCode is null!");
        Project project = projectService.getProjectByCode(request.getProjectCode());
        if (null == project) {
            return null;
        }
        Map<String, Object> viewMap = MergeUtil.mergeObjectToMap(new HashMap<>(), project, null);
        if (null != project.getTarget()) {
            viewMap.put("taskTargetId", project.getTarget().getCode());
            viewMap.put("taskTargetName", project.getTarget().getName());
            if (null != project.getTarget().getLang()) {
                viewMap.put("taskTargetName", project.getTarget().getLang().get("name"));
                project.getTarget().getLang().remove("name");
            }

        }
        List<Task> tasks = fillMainlineTaskInfo(project);
        viewMap.put("activities", tasks);
        return viewMap;
    }

    /**
     * 从项目中获取任务
     * @param project 项目数据
     * @return
     * @throws DWBusinessException
     */
    private List<Task> fillMainlineTaskInfo(Project project) throws DWBusinessException {
        List<Task> activities = new ArrayList<>();
        if (null != project.getMainLineTasks() && project.getMainLineTasks().size() > 0) {
            Map<String, Object> q = new HashMap<>();
            q.put("code", project.getMainLineTasks());
            List<Task> tasks = dataPickService.find(BasicQuery.of(q, null), Task.class);
            if (null != tasks && tasks.size() > 0) {
                tasks.forEach(tv -> {
                    tv.setActivityId(tv.getCode());
                    tv.setActivityName(tv.getName());
                    if (null != tv.getLang()) {
                        tv.setActivityName(tv.getLang().get("name"));
                    }
                    activities.add(tv);
                });
            }
        }

        return activities;
    }

    /**
     * task任务对象转换成map集合
     * @param task 任务对象
     * @return 返回集合
     */
    public static Map<String, Object> taskToMap(Task task) {
        if (null == task) {
            return null;
        }
        Map<String, Object> viewMap = MergeUtil.mergeObjectToMap(new HashMap<>(), task, null);
        viewMap.put("activityId", task.getCode());
        viewMap.put("activityName", task.getName());
        viewMap.put("resCode", task.getResCode());
        viewMap.put("feeInfo", task.getFeeInfo());
        if (null != task.getLang()) {
            if (null != task.getLang().get("name")) {
                viewMap.put("activityName", task.getLang().get("name"));
            }
        }
        return viewMap;
    }

    @Override
    public Map<String, Object> postTask(ViewRequest request) throws DWException {
        if (null == request.getTaskCode()) {
            return null;
        }
        com.digiwin.athena.kmservice.utils.ServiceUtils.getContext().setEocInfo(request.getEocInfo());
        Map<String, Object> viewMap;
        // 查询任务以及流程和页面信息
        Task task = dataPickService.findBetter(request.getTaskCode(), Task.class);
        if (null == task) {
            return null;
        }
        viewMap = taskToMap(task);
        if (null != task.getFlowCode()) {
            FlowGraph graph = dataPickService.findByCode(task.getFlowCode(), FlowGraph.class);
            // 个案任务可能把FlowGraph删掉了，需要比较租户id是否一样
            if (null != graph && graph.getTenantId().equals(task.getTenantId())) {
                Activity activity = dataMapTaskService.milestoneActivity(graph);
                if (null != activity) {
                    if (null != activity.getConfig()) {
                        viewMap.put("approve", activity.getConfig().get("approve"));
                        viewMap.put("dynamicApproves", activity.getConfig().get("dynamicApproves"));
                        viewMap.put("approveLevel", activity.getConfig().get("approveLevel"));

                    }
                    if (null != activity.getExecutor()) {
                        viewMap.put("personOnDuty", activity.getExecutor());
                    }
                    if (null != activity.getPresetVariables()) {
                        viewMap.put("presetVariables", activity.getPresetVariables());
                    }
                    viewMap.put("executorMeta", activity.getExecutorMeta());
                }
            }
        }

        if (null != task.getPageCode()) {
            PageView page = dataPickService.findBetter(task.getPageCode(), PageView.class);
            if (null != page && page.getTenantId().equals(task.getTenantId())) {
                page.setId(null);
                page.setName(null);
                page.setCode(null);
                if (null != page.getLang() && null != task.getLang()) {
                    page.getLang().putAll(task.getLang());
                }
                MergeUtil.mergeObjectToMap(viewMap, page, null);
                if (null != request.getPageCode() && null != page.getPages()) {
                    viewMap.put("pages", page.getPages().get(request.getPageCode()));
                }
            }
        }

        // 为了兼容两种引擎的逾期时间配置
        if (null != task.getDueDate() && null == task.getExpectedDuration()) {
            if (task.getDueDate().getValue() instanceof Number) {
                Number seconds = (Number) task.getDueDate().getValue();
                ExpectedDuration expectedDuration = new ExpectedDuration();
                int value = seconds.intValue() / 86400;
                int mod = seconds.intValue() % 86400;
                if (value > 0 && mod == 0) {
                    expectedDuration.setType("DAY");
                } else {
                    value = seconds.intValue() / 3600;
                    mod = seconds.intValue() % 3600;
                    if (value > 0 && mod == 0) {
                        expectedDuration.setType("HOUR");
                    } else {
                        value = seconds.intValue() / 60;
                        expectedDuration.setType("MINUTE");
                    }
                }
                expectedDuration.setValue(value);
                task.setExpectedDuration(expectedDuration);
                viewMap.put("expectedDuration", expectedDuration);
            }
        }

        // todo 这个要单独开一个接口 发起签核得任务也想知道它发起的是哪个签核任务--这个查的范围有点大...
        Map<String, Object> qq = new HashMap<>();
        qq.put("startApproveActivity", task.getCode());
        Task activityApprove = dataPickService.findOne(BasicQuery.of(qq, request.getEocInfo()), Task.class);
        if (null != activityApprove && activityApprove.getTenantId().equals(task.getTenantId())) {
            viewMap.put("targetApproveActivity", activityApprove.getCode());
        }

        return viewMap;
    }

    private List<Rule> rules(String taskCode) {
        List<Rule> rulesMech = new ArrayList<>();
        try {
            List<Rule> rulesAll = presetLibraryService.rules(taskCode);
            if (null == rulesAll) {
                return null;
            }
            for (Rule r : rulesAll) {
                if (null != r.getPluginId()) {
                    rulesMech.add(r);
                }
            }
        } catch (Exception e) {
            log.error("get rules error", e);
        }
        return rulesMech;
    }

    /*
     * 通过项目code获取项目下所有任务列表，但mainline字段其实已经不用了，改用phases，这里貌似也有问题
     */
    @Override
    public List<ActivityBaseInfoVO> postTasksByProject(ViewRequest request) throws DWException {
        if (null != request.getProjectCode()) {
            Project project = dataPickService.findBetter(request.getProjectCode(), Project.class);
            if (null != project && null != project.getMainLineTasks() && project.getMainLineTasks().size() > 0) {
                Map<String, Object> q = new HashMap<>();
                q.put("code", project.getMainLineTasks());
                List<Task> tasks = dataPickService.find(BasicQuery.of(q, request.getEocInfo()), Task.class);
                if (null != tasks && tasks.size() > 0) {
                    List<ActivityBaseInfoVO> vos = new ArrayList<>();
                    String locale = request.getLocale();
                    if (null == locale) {
                        locale = ServiceUtils.getCurrentLocale();
                    }
                    String finalLocale = locale;
                    tasks.forEach(t -> {
                        ActivityBaseInfoVO vo = new ActivityBaseInfoVO();
                        vo.setTaskId(project.getCode());
                        vo.setTaskName(dealLang("name", project, project.getName(), finalLocale));
                        vo.setActivityId(t.getCode());
                        vo.setActivityName(dealLang("name", t, t.getName(), finalLocale));
                        vo.setSequence(t.getSequence());
                        vos.add(vo);
                    });
                    return vos;
                }
            }
        }
        return null;
    }

    @Override
    public Object postEmails(ViewRequest request) throws DWException {
        if (null == request.getEmailTemplateCode()) {
            return null;
        }
        Map<String, Object> query = new HashMap<>();
        query.put("templateCode", request.getEmailTemplateCode());
        List<EmailView> views = dataPickService.find(BasicQuery.of(query, request.getEocInfo()), EmailView.class);
        views.forEach(v -> {
            v.setLocaleViews(null);
        });

        return views;
    }

    /*
     *
     * Deprecated 选定模板对应的国际化模板保存在kg表中
     */
    @Deprecated
    @Override
    public Object postEmail(ViewRequest request) throws DWException {
        if (null != request.getEmailCode()) {
            EmailView view = dataPickService.findBetter(request.getEmailCode(), EmailView.class);
            if (null != view) {
                Map<String, String> map = new HashMap<>();
                map.put("eventId", view.getLocaleViews().get(request.getLocale()));
                return map;
            }
        }
        return null;
    }

    @Override
    public Object postUpdateProject(Project project) throws DWException {
        dataPickService.setRootOperationUnitId(project);
        Project tp = dataPickService.tenantObjectToSave(project, Project.class);
        if (null != project.getChargePerson()) {
            tp.setPersonInCharge(project.getChargePerson());
        }
        dataPickService.saveTenantObject(tp, Project.class);
        return null;
    }

    @Override
    public Object postUpdateTask(Task task) throws DWException {
        dataPickService.setRootOperationUnitId(task);
        com.digiwin.athena.kmservice.utils.ServiceUtils.getContext().setEocInfo(task.getEocInfo());
        try {
            Task tp = dataPickService.tenantObjectToSave(task, Task.class);
            if (null != task.getExpectedDuration() && null != task.getExpectedDuration().getType()) {
                TimeDefinition dueDate = new TimeDefinition();
                dueDate.setDatatype("second");
                switch (task.getExpectedDuration().getType()) {
                    case "DAY":
                        dueDate.setValue(task.getExpectedDuration().getValue() * 24 * 3600);
                        break;
                    case "HOUR":
                        dueDate.setValue(task.getExpectedDuration().getValue() * 3600);
                        break;
                    case "MINUTE":
                        dueDate.setValue(task.getExpectedDuration().getValue() * 60);
                        break;
                    default:;
                }
                tp.setDueDate(dueDate);
            }

            Task taskAll = dataPickService.findBetter(tp.getCode(), Task.class);
            if (null == taskAll) {
                dataPickService.saveTenantObject(tp, Task.class);
                return null;
            }
            // 更新到主活动的部分
            String flowCode = taskAll.getFlowCode();
            if (null != flowCode) {
                FlowGraph graph = dataPickService.findBetter(flowCode, FlowGraph.class);
                if (null != graph) {
                    Activity activityInDb = dataMapTaskService.milestoneActivity(graph);
                    if (null != activityInDb) {
                        Activity activity = new Activity();
                        activity.setCode(activityInDb.getCode());
                        activity.setMilestone(activityInDb.getMilestone());
                        activity.setType(activityInDb.getType());
                        activity.setPattern(activityInDb.getPattern());
                        activity.setEocInfo(task.getEocInfo());
                        activity.setConfig(new HashMap<>());
                        boolean activityChanged = false;
                        // 签核配置需要配置到活动中
                        if (null != task.getApprove() && TaskType.approve.equalsIgnoreCase(taskAll.getType())) {
                            activity.getConfig().put("approve", task.getApprove());
                            activity.getConfig().put("dynamicApproves", task.getDynamicApproves());
                            activity.getConfig().put("approveLevel", task.getApproveLevel());
                            activityChanged = true;
                        }
                        if (null != task.getPersonOnDuty()) {
                            activity.setExecutor(task.getPersonOnDuty());
                            activityChanged = true;
                        }
                        if (activityChanged) {
                            // 把eocInfo设置到activity上
                            dataPickService.save(activity, Activity.class);
                        }
                    }
                }
            }
            dataPickService.saveTenantObject(tp, Task.class);

        } catch (DWException e) {
            log.error(e.getMessage(), e);
            throw new DWBusinessException(e.getMessage());
        }

        return null;
    }

    @Override
    public void postUpdateTaskScheduleFlag(Task task) throws DWException {
        Query query = Query.query(
                Criteria.where("code").is(task.getCode())
                        .and("version").is(task.getVersion()));
        Task targetTask = dataPickService.systemTemplate().findOne(query, Task.class);
        if (null == targetTask) {
            throw new DWBusinessException(String.format("task not found, code: %s", task.getCode()));
        }
        targetTask.setNeedLightDetection(task.getNeedLightDetection());
        targetTask.setNeedScheduledTaskDetail(task.getNeedScheduledTaskDetail());
        dataPickService.systemTemplate()
                .save(targetTask, dataPickService.systemTemplate().getCollectionName(Task.class));
    }

    @Override
    public Object postTaskSchedule(TaskSchedule taskSchedule) throws DWException {
        dataPickService.tenantTemplate().remove(new Query(Criteria.where("taskCode").is(taskSchedule.getTaskCode())
                .and("mechanismLogicCode").is(taskSchedule.getMechanismLogicCode())
                .and("tenantId").is(taskSchedule.getTenantId())), "taskSchedule");
        dataPickService.tenantTemplate().save(taskSchedule, "taskSchedule");
        return null;
    }

    @Override
    public Object postDeleteTaskSchedule(TaskSchedule taskSchedule) throws DWException {
        dataPickService.tenantTemplate().remove(new Query(Criteria.where("taskCode").is(taskSchedule.getTaskCode())
                .and("mechanismLogicCode").is(taskSchedule.getMechanismLogicCode())
                .and("tenantId").is(taskSchedule.getTenantId())), "taskSchedule");
        return null;
    }

    @Override
    public Object postProjectTasks(ViewRequest request) throws DWException {
        List<ActivityBaseInfoVO> results = new ArrayList<>();
        String projectCode = request.getProjectCode();
        if (null == projectCode) {
            return null;
        }
        Project project = projectService.getProjectByCode(request.getProjectCode());
        String locale = ServiceUtils.getCurrentLocale();
        if (null != project && null != project.getMainLineTasks() && !project.getMainLineTasks().isEmpty()) {
            Map<String, Object> q = new HashMap<>();
            q.put("code", project.getMainLineTasks());
            List<Task> tasks = dataPickService.find(BasicQuery.of(q, request.getEocInfo()), Task.class);
            tasks.forEach(t -> {
                ActivityBaseInfoVO vo = new ActivityBaseInfoVO();
                vo.setActivityId(t.getCode());
                vo.setActivityName(t.getName());
                if (null != locale && null != t.getLang() && null != t.getLang().get("name") && null != t.getLang().get("name").get(locale)) {
                    vo.setActivityName(t.getLang().get("name").get(locale));
                }
                vo.setConfig(t.getConfig());
                vo.setTaskId(projectCode);
                vo.setTaskName(project.getName());
                vo.setSequence(t.getSequence());
                vo.setActivityVersion(t.getVersion());
                vo.setAllowSubLevel(t.getAllowSubLevel());
                vo.setNeedEnableApprove(t.getNeedEnableApprove());
                vo.setStartApproveActivityName(t.getStartApproveActivityName());
                results.add(vo);
            });

        }

        return results;
    }

    @Override
    public Map<String, Object> postActivityStartTargetCode(ViewRequest request) throws DWException {
        Map<String, Object> map = new HashMap<>();
        if (null != request.getTaskCode()) {
            Map<String, Object> q = new HashMap<>();
            q.put("startApproveActivity", request.getTaskCode());
            Task better = dataPickService.findBetter(BasicQuery.of(q, request.getEocInfo()), Task.class);
            if (null != better) {
                map.put("targetApproveActivity", better.getCode());
            }
        }
        return map;
    }

    @Override
    public Map<String, Object> postProjectInputData(ViewRequest request) throws DWException {
        Project project = dataPickService.findByCode(request.getProjectCode(), Project.class);
        if (null != project && null != project.getInputData()) {
            Map<String, Object> result = new HashMap<>();
            result.put("taskId", request.getProjectCode());
            result.put("inputData", project.getInputData());
            return result;
        }
        return null;
    }

    @Override
    public Object postTaskInputData(ViewRequest request) throws DWException {
        Task task = dataPickService.findByCode(request.getTaskCode(), Task.class);
        if (null != task && null != task.getInputData()) {
            Map<String, Object> result = new HashMap<>();
            result.put("activity", request.getTaskCode());
            result.put("inputData", task.getInputData());
            return result;
        }
        return null;
    }

    @Override
    public Object postTasksForWord(WordTaskReq request) throws DWException {
        List<Map<String, Object>> viewMaps = new ArrayList<>();
        return viewMaps;
        // Query query = new Query();
        // query.addCriteria(Criteria.where("executeType").is("manual"));
        // if (CollectionUtils.isNotEmpty(request.getCategories())) {
        // query.addCriteria(Criteria.where("dimension.categories").in(request.getCategories()));
        // }
        // if (CollectionUtils.isNotEmpty(request.getDuty())) {
        // query.addCriteria(Criteria.where("dimension.duty").in(request.getDuty()));
        // }
        // if (CollectionUtils.isNotEmpty(request.getTime())) {
        // query.addCriteria(Criteria.where("dimension.time").in(request.getTime()));
        // }
        // if (CollectionUtils.isNotEmpty(request.getPlace())) {
        // query.addCriteria(Criteria.where("dimension.place").in(request.getPlace()));
        // }
        // List<Task> taskList = mongoTemplate.find(query, Task.class);
        //
        // if (taskList.size() > 0) {
        // List<String> pageCodes = taskList.stream().filter(task -> task.getPageCode() != null).map(task -> task.getPageCode()).collect(Collectors.toList());
        // Query query2 = new Query();
        // query2.addCriteria(Criteria.where("code").in(pageCodes));
        // List<PageView> pages = mongoTemplate.find(query2, PageView.class);
        //
        // Map<String, PageView> pageViewMap = new HashMap<>();
        // for (PageView page : pages) {
        // pageViewMap.put(page.getCode(), page);
        // page.setId(null);
        // page.setTenantId(null);
        // page.setCode(null);
        // page.setName(null);
        //
        // }
        //
        // for (Task task : taskList) {
        // Map<String, Object> viewMap = MergeUtil.mergeObjectToMap(new HashMap<>(), task, null);
        // viewMap.put("activityId", task.getCode());
        // viewMap.put("activityName", task.getName());
        // if (null != task.getPageCode()) {
        // PageView view = pageViewMap.get(task.getPageCode());
        // if (null != view) {
        // if (null != request.getPageCode() && null != view.getPages()) {
        // Map pageDetail = (Map) view.getPages().get(request.getPageCode());
        // if (null != pageDetail) {
        // viewMap.put("dataStates", pageDetail.get("dataStates"));
        // }
        // view.setPages(null);
        // }
        // MergeUtil.mergeObjectToMap(viewMap, view, null);
        // if (null != view.getDataSources()) {
        // List<String> dataSourceNames = new ArrayList<>();
        // view.getDataSources().forEach((k, v) -> {
        // dataSourceNames.add(k);
        // });
        // viewMap.put("dataSourceNames", dataSourceNames);
        // }
        // }
        //
        // }
        // viewMaps.add(viewMap);
        // }
        // }
        // return viewMaps;
    }

    @Override
    public Object postTasksForWord2(WordTaskReq request) throws DWException {
        Map<String, Object> viewMaps = new HashMap<>();
        if (null == request.getPageNum() || null == request.getPageSize() || request.getPageSize() > 1000) {
            viewMaps.put("msg", "pageNum pageSize is null or too big");
            return viewMaps;
        }

        List<Map<String, Object>> tasks = new ArrayList<>();
        viewMaps.put("data", tasks);

        Query query = new Query();
        query.addCriteria(Criteria.where("executeType").is("manual"));
        query.with(PageRequest.of(request.getPageNum(), request.getPageSize()));
        List<Task> taskList = mongoTemplate.find(query, Task.class);
        long total = mongoTemplate.count(query, Task.class);
        viewMaps.put("total", total);
        viewMaps.put("pageNum", request.getPageNum());
        viewMaps.put("pageSize", taskList.size());
        if (CollectionUtils.isEmpty(taskList)) {
            return viewMaps;
        }
        if (taskList.size() > 0) {
            List<String> pageCodes = taskList.stream().filter(task -> task.getPageCode() != null).map(task -> task.getPageCode()).collect(Collectors.toList());
            Query query2 = new Query();
            query2.addCriteria(Criteria.where("code").in(pageCodes));
            List<PageView> pages = mongoTemplate.find(query2, PageView.class);
            Map<String, PageView> pageViewMap = new HashMap<>();
            for (PageView page : pages) {
                pageViewMap.put(page.getCode(), page);
                page.setId(null);
                page.setTenantId(null);
                page.setCode(null);
                page.setName(null);
            }
            Set<String> actionIds = new HashSet<>();
            Map<String, Set<String>> taskActions = new HashMap<>();
            // 任务
            for (Task task : taskList) {
                Map<String, Object> viewMap = new HashMap<>();
                viewMap.put("activityId", task.getCode());
                viewMap.put("activityName", task.getName());
                viewMap.put("pageCode", task.getPageCode());
                viewMap.put("pattern", task.getPattern());
                viewMap.put("category", task.getCategory());
                viewMap.put("application", task.getApplication());
                viewMap.put("dimension", task.getDimension());
                Set<String> taskActionIds = new HashSet<>();
                viewMap.put("actionIds", taskActionIds);
                if (null != task.getPageCode()) {
                    PageView view = pageViewMap.get(task.getPageCode());
                    if (null != view && null != view.getDataSources()) {
                        view.getDataSources().forEach((k, v) -> {
                            try {
                                Map source = (Map) v;
                                String actionId = (String) source.get("actionId");
                                if (null != actionId) {
                                    taskActionIds.add(actionId);
                                    actionIds.add(actionId);
                                }
                            } catch (Exception e) {
                                log.error(e.getMessage());
                            }
                        });
                    }
                }
                tasks.add(viewMap);
                taskActions.put(task.getCode(), taskActionIds);
            }

            // 元数据
            Map<String, ApiDataFieldMetadataDTO> actionMetas = genericService.actionResponseDtos(actionIds);
            viewMaps.put("actionMetas", actionMetas);
            // tag
            Map<String, Object> param = new HashMap<>();
            param.put("taskActionIds", taskActions);
            Map actionTags = (Map) dataMapTagSystemService.postTagsByAction(param);
            if (null == actionTags) {
                throw new DWBusinessException("query tag error");
            }
            for (Map<String, Object> task : tasks) {
                String code = (String) task.get("activityId");
                Object tags = actionTags.get(code);
                task.put("tags", tags);
            }

        }
        return viewMaps;
    }

    // 针对于定制中需要能够获取到机制设置的rule，需要额外获取rule
    @Override
    public Object postMechanism(ViewRequest request) throws DWException {
        String tenantId = ServiceUtils.getTenantId();
        Map<String, Object> viewMap = new HashMap<>();
        String taskCode = request.getTaskCode();
        if (null == taskCode && null != request.getProjectCode()) {
            Project project = dataPickService.findBetter(request.getProjectCode(), Project.class);
            if (null != project && Boolean.TRUE.equals(project.getManualAble())) {
                Task taskMaster3 = projectService.manualProjectPageTask(project.getCode());
                if (null != taskMaster3) {
                    taskCode = taskMaster3.getCode();
                }
            }
        }
        Map<String, Object> mechnismConfig = new HashMap<>();
        viewMap.put("mechnismConfig", mechnismConfig);
        if (null != taskCode) {
            Task task = dataPickService.findBetter(taskCode, Task.class);

            // rules
            mechnismConfig.put("rules", rules(taskCode));

            // 开窗推荐
            if (null != task && null != task.getPageCode()) {
                Query query1 = Query.query(Criteria.where("businessKey").is("suggestAction").and("tenantId").is(tenantId).and("code").is(task.getPageCode()));
                List<TenantObjectAdaptation> adaptations = mongoTemplate.find(query1, TenantObjectAdaptation.class, DataMapPickService.tableTenantObjectAdaptation(PageView.class));
                List suggestActions = new ArrayList();
                adaptations.forEach(tenantObjectAdaptation -> {
                    suggestActions.add(tenantObjectAdaptation.getValue());
                });
                mechnismConfig.put("suggestAction", suggestActions);
            }

            Query query2 = Query.query(Criteria.where("type").is("TM_VARIABLE").and("tenantId").is(tenantId).and(
                    "code").is(taskCode));
            List<TenantObjectAdaptation> adaptations = dataPickService.tenantTemplate().find(query2, TenantObjectAdaptation.class, DataMapPickService.tableTenantObjectAdaptation(PageView.class));
            ArrayList<String> codeList = new ArrayList<>();
            for (TenantObjectAdaptation adaptation : adaptations) {
                if (ComponentTypeEnum.MechanismLimit.name().equals(adaptation.getBusinessKey())) {
                    ActionParam actionParam = JSON.parseObject(JSON.toJSONString(adaptation.getValue()), ActionParam.class);
                    codeList.add(actionParam.getValue().toString());
                }
            }
            Object variableListSimple = dataMapKgService.getVariableListSimple(codeList.stream().distinct().collect(Collectors.toList()), Boolean.FALSE);
            mechnismConfig.put("variablesParameter", variableListSimple);
        }
        return viewMap;
    }

    @Override
    public Object postOpenWindows(ViewRequest request) throws DWException {
        Map<String, Object> view = new HashMap<>();
        List list = new ArrayList();
        // 先查任务
        Task task = dataPickService.findBetter(request.getTaskCode(), Task.class);
        if (null == task || task.getPageCode() == null) {
            return list;
        }
        PageView pageView = dataPickService.findBetter(task.getPageCode(), PageView.class);
        if (null == pageView) {
            return list;
        }
        view.put("code", pageView.getCode());
        Object obj = null;
        try {
            Map map = JSON.parseObject(JSON.toJSONString(pageView));
            obj = JsonPath.read(map, "$.pages.task-detail.dataStates[*].operations[*]");
            view.put("operations", obj);
        } catch (Exception e) {
            log.error("get operations error", e);
        }

        return view;
    }

    @Override
    public Object postOpenWindowDecisions(ViewRequest request) throws DWException {
        List<OpenWindowDecision> decisions = dataPickService.find(BasicQuery.of(request.getQuery(), request.getEocInfo()), OpenWindowDecision.class);
        return decisions;
    }

    @Override
    public Object postCardConfig(ViewRequest request) throws DWException {
        List<Task> result = new ArrayList<>();
        String pageCode = request.getPageCode();
        Map<String, Task> pageCode2Task = new HashMap<>();
        Map<String, Object> viewMap = new HashMap<>();

        if ("project-card".equals(pageCode)) {
            request.getQuery().put("executeType", "user");
            BasicQuery basicQuery = BasicQuery.of(request.getQuery(), request.getEocInfo());
            basicQuery.setReturnFields(ListUtil.of("tenantId", "version", "code", "name", "lang", "pageCode"));
            List<Project> projectList = dataPickService.find(basicQuery, Project.class);
            if (CollectionUtils.isNotEmpty(projectList)) {
                projectList.forEach(e -> {
                    if (StringUtils.isNoneBlank(e.getPageCode())) {
                        Task task = new Task();
                        task.setPageCode(e.getPageCode());
                        task.setName(e.getName());
                        task.setLang(e.getLang());
                        task.setCode(e.getCode());
                        pageCode2Task.put(e.getCode(), task);
                    }
                });
            }
            viewMap.put("pages.project-card.dataStates.type", "all");
        } else {
            pageCode = "task-card";
            request.getQuery().put("executeType", "manual");
            BasicQuery basicQuery = BasicQuery.of(request.getQuery(), request.getEocInfo());
            basicQuery.setReturnFields(ListUtil.of("tenantId", "version", "code", "name", "lang", "pageCode"));
            List<Task> tasks = dataPickService.find(basicQuery, Task.class);
            tasks.forEach(task -> {
                if (null != task.getPageCode()) {
                    pageCode2Task.put(task.getPageCode(), task);
                }
            });
            if ("all".equals(request.getType())) {
                // 查询所有任务
            } else {
                viewMap.put("pages.task-card.dataStates.type", "all");
            }
        }
        viewMap.put("code", pageCode2Task.keySet());
        BasicQuery basicQuery2 = BasicQuery.of(viewMap, request.getEocInfo());
        basicQuery2.setReturnFields(ListUtil.of("tenantId", "version", "code", "pages"));
        List<PageView> pageViews = dataPickService.find(basicQuery2, PageView.class);
        if (CollectionUtils.isNotEmpty(pageViews)) {
            for (PageView pageView : pageViews) {
                Task task = pageCode2Task.get(pageView.getCode());
                if (null != pageView.getPages() && null != pageView.getPages().get(pageCode)) {
                    Map<String, Object> taskcard = (Map<String, Object>) pageView.getPages().get(pageCode);
                    List<Map> dataStates = (List<Map>) taskcard.get("dataStates");
                    if (null != dataStates) {
                        for (Map map : dataStates) {
                            if ("all".equals(map.get("type"))) {
                                Object taskCardFields = map.get("taskCardFields");
                                // 使用这个字段做承载
                                task.setFieldConfig(taskCardFields);
                                break;
                            }
                        }
                    }
                }

                result.add(task);
            }
        }
        return result;
    }

    @Override
    public List<WSConditionDTO> postNewCardConfig(ViewRequest request) throws DWException {
        Map<String, Object> query1 = request.getQuery();
        query1.put("executeType", "manual");
        BasicQuery basicQuery = BasicQuery.of(query1, request.getEocInfo());
        basicQuery.setReturnFields(ListUtil.of("tenantId", "version", "code", "name", "lang", "pageCode"));
        List<Task> tasks = dataPickService.find(basicQuery, Task.class);
        Map<String, Task> pageCode2Task = new HashMap<>();
        tasks.forEach(task -> {
            if (null != task.getPageCode()) {
                pageCode2Task.put(task.getPageCode(), task);
            }
        });
        HashMap<String, Object> query = new HashMap<>();
        query.put("code", pageCode2Task.keySet());
        query.put("pages.task-card.dataStates", Criteria.where("taskCardFields.taskCardField.groups").exists(true));
        BasicQuery basicQuery2 = BasicQuery.of(query, request.getEocInfo());
        basicQuery2.setReturnFields(Arrays.asList("tenantId", "version", "pages.task-card.dataStates.taskCardFields.taskCardField", "code", "createDate"));
        List<FatPageView> pageViews = dataPickService.find(basicQuery2, FatPageView.class);
        return pageViewtToConditionDTO(pageViews, pageCode2Task, null, "task-card", WSConfigType.groups, WSPageCode.task);
    }

    @Override
    public List<WSConditionDTO> postWorkbenchSetting(WorkbenchSettingRequest request) throws DWException {
        List<String> code = request.getCode();
        WSPageCode pageCode = request.getPageCode();
        WSConfigType configType = request.getConfigType();
        String pageCodeString = "";
        switch (pageCode) {
            case task:
                pageCodeString = "task-card";
                break;
            case project:
                pageCodeString = "project-card";
                break;
            default:
                break;
        }
        HashMap<String, Object> query = new HashMap<>();
        query.put("code", code);
        query.put("pages." + pageCodeString + ".dataStates", Criteria.where("taskCardFields.taskCardField." + configType.name()).exists(true));
        BasicQuery basicQuery = BasicQuery.of(query, null);
        basicQuery.setReturnFields(Arrays.asList("tenantId", "version", "pages." + pageCodeString + ".dataStates.taskCardFields.taskCardField", "code", "createDate"));
        List<FatPageView> pageViews = dataPickService.find(basicQuery, FatPageView.class);
        List<WSConditionDTO> result = new ArrayList<>();
        if (CollectionUtil.isNotEmpty(pageViews)) {
            Map<String, Task> pageCode2Task = new HashMap<>();
            Map<String, Project> pageCode2Project = new HashMap<>();
            if (pageCode == WSPageCode.task) {
                HashMap<String, Object> map = new HashMap<>();
                map.put("code", code);
                map.put("pageCode", pageViews.stream().map(v -> v.getCode()).collect(Collectors.toList()));
                BasicQuery basicQuery2 = BasicQuery.of(map, null);
                basicQuery2.setReturnFields(ListUtil.of("tenantId", "version", "code", "name", "pageCode", "lang"));
                List<Task> tasks = dataPickService.find(basicQuery2, Task.class);
                tasks.forEach(task -> {
                    if (null != task.getPageCode()) {
                        pageCode2Task.put(task.getPageCode(), task);
                    }
                });
            } else if (pageCode == WSPageCode.project) {
                HashMap<String, Object> map = new HashMap<>();
                map.put("code", code);
                BasicQuery basicQuery3 = BasicQuery.of(map, null);
                basicQuery3.setReturnFields(Arrays.asList("tenantId", "version", "pageCode", "name", "code", "lang"));
                List<Project> projects = dataPickService.find(basicQuery3, Project.class);
                for (Project project : projects) {
                    pageCode2Project.put(project.getPageCode(), project);
                }
            }
            result = pageViewtToConditionDTO(pageViews, pageCode2Task, pageCode2Project, pageCodeString, configType, pageCode);

        }
        return result;
    }

    /**
     * pageview转换成Condition
     * @param pageViews
     * @param pageCode2Task
     * @param pageCode2Project
     * @param pageCodeString
     * @param configType
     * @param pageCode
     * @return
     */
    private List<WSConditionDTO> pageViewtToConditionDTO(List<FatPageView> pageViews, Map<String, Task> pageCode2Task, Map<String, Project> pageCode2Project, String pageCodeString,
                                                         WSConfigType configType, WSPageCode pageCode) {
        ArrayList<WSConditionDTO> wsConditionList = new ArrayList<>();
        for (FatPageView pageView : pageViews) {
            HashMap map = (HashMap) pageView.getPages().get(pageCodeString);
            if (map != null && map.size() > 0) {
                ArrayList<HashMap> dataStates = (ArrayList<HashMap>) map.get("dataStates");
                if (CollectionUtil.isNotEmpty(dataStates)) {
                    for (HashMap dataState : dataStates) {
                        HashMap taskCardFields = (HashMap) dataState.get("taskCardFields");
                        if (taskCardFields != null) {
                            BusinessMessageSourceMethod businessMessageSourceMethod = null;
                            Object businessMessageSourceMethodString = taskCardFields.get("businessMessageSourceMethod");
                            if (businessMessageSourceMethodString != null) {
                                businessMessageSourceMethod = BusinessMessageSourceMethod.valueOf((String) businessMessageSourceMethodString);
                            }
                            HashMap taskCardField = (HashMap) taskCardFields.get("taskCardField");
                            ArrayList<HashMap> arrayList = (ArrayList<HashMap>) taskCardField.get(configType.name());
                            for (HashMap condition : arrayList) {
                                WSConditionDTO wsConditionDTO = new WSConditionDTO();
                                wsConditionDTO.setBusinessMessageSourceMethod(businessMessageSourceMethod);
                                wsConditionDTO.setCreateDate(pageView.getCreateDate());
                                wsConditionDTO.setAliasName((String) condition.get("name"));
                                wsConditionDTO.setAliasCode((String) condition.get("code"));
                                wsConditionDTO.setDefaultEffective(Boolean.valueOf(condition.get("defaultEffective") != null ? condition.get("defaultEffective").toString() : null));
                                wsConditionDTO.setEnable(Boolean.valueOf(condition.get("defaultEffective") != null ? condition.get("defaultEffective").toString() : null));
                                wsConditionDTO.setSourceType(SourceType.customer);
                                wsConditionDTO.setDataType(condition.get("dataType") != null ? condition.get("dataType").toString() : null);
                                Map<String, Map<String, String>> lang = (Map<String, Map<String, String>>) condition.get("lang");
                                wsConditionDTO.setLang(ImmutableMap.of("aliasName", lang.get("name")));
                                ConditionScopeDTO conditionScopeDTO = new ConditionScopeDTO();
                                if (pageCode == WSPageCode.task) {
                                    Task task = pageCode2Task.get(pageView.getCode());
                                    if (task != null) {
                                        wsConditionDTO.setTaskCode(task.getCode());
                                        wsConditionDTO.setTaskName(task.getName());
                                        conditionScopeDTO.setId(task.getId());
                                        conditionScopeDTO.setName(task.getName());
                                        conditionScopeDTO.setCode(task.getCode());
                                        conditionScopeDTO.setLang(task.getLang());
                                        conditionScopeDTO.setCardGroupTask(JSON.parseObject(JSON.toJSONString(task), ConditionScopeDTO.CardGroupTask.class));
                                    }
                                }
                                if (pageCode == WSPageCode.project) {
                                    Project project = pageCode2Project.get(pageView.getCode());
                                    if (project != null) {
                                        conditionScopeDTO.setId(project.getId());
                                        conditionScopeDTO.setName(project.getName());
                                        conditionScopeDTO.setCode(project.getCode());
                                        conditionScopeDTO.setLang(ImmutableMap.of("name", project.getLang().get("name")));
                                    }
                                }
                                conditionScopeDTO.setFieldCode(taskCardField.get("value") != null ? taskCardField.get("value").toString() : null);
                                wsConditionDTO.setConditionScope(Collections.singletonList(conditionScopeDTO));
                                wsConditionList.add(wsConditionDTO);

                            }
                        }
                    }
                }
            }
        }
        return wsConditionList;
    }

    @Override
    public Object postWorkbenchSettingByConfigTypes(WorkbenchSettingByConfigTypeRequest request) throws DWException {
        // List<WSConfigType> configTypes = request.getConfigTypes();
        // 返回分组下，同一个代理code只会取一条最新的配置信息
        WSPageCode pageCode = request.getPageCode();
        String pageCodeString = "";
        switch (pageCode) {
            case task:
                pageCodeString = "task-card";
                break;
            case project:
                pageCodeString = "project-card";
                break;
            default:
                break;
        }
        String tenantId = com.digiwin.athena.kmservice.utils.ServiceUtils.getTenantIdSilent();

        List<String> code = request.getCode();
        Map<String, Object> query = new HashMap<>();
        query.put("code", code);
        // query.put("tenantId",tenantId);
        List<String> fields = new ArrayList<>();
        fields.add("pages." + pageCodeString);
        fields.add("code");
        fields.add("version");
        fields.add("tenantId");
        BasicQuery basicQuery = BasicQuery.of(query, null);
        basicQuery.setReturnFields(fields);
        List<PageView> pageViews = dataPickService.find(basicQuery, PageView.class);
        // listMap.put(configType, pageViews);
        return pageViews;

    }

    @Override
    public List<TaskCardFieldVO> taskCardField(TaskCardFieldRequest request) throws DWException {
        List<String> code = request.getCode();
        String pageCode = request.getPageCode();
        String queryField = request.getQueryField();
        String tenantVersion = dataPickService.tenantVersion();
        HashMap<String, Object> query = new HashMap<>();
        query.put("version", tenantVersion);
        query.put("code", code);
        String queryFieldString = "taskCardFields.taskCardField";
        if (StringUtils.isNotBlank(queryField)) {
            queryFieldString = queryFieldString + "." + queryField;
        }
        query.put("pages." + pageCode + ".dataStates", Criteria.where(queryFieldString).exists(true));
        BasicQuery basicQuery = BasicQuery.of(query, null);
        basicQuery.setReturnFields(Arrays.asList("tenantId", "version", "pages." + pageCode + ".dataStates." + queryFieldString, "code"));
        List<FatPageView> pageViews = dataPickService.find(basicQuery, FatPageView.class);
        ArrayList<TaskCardFieldVO> taskCardFieldVOList = new ArrayList<>();
        for (FatPageView pageView : pageViews) {
            HashMap<String, Object> map = (HashMap<String, Object>) pageView.getPages().get(pageCode);
            ArrayList<HashMap<String, Object>> dataStates = (ArrayList<HashMap<String, Object>>) map.get("dataStates");
            for (HashMap<String, Object> dataState : dataStates) {
                HashMap<String, Object> taskCardFields = (HashMap) dataState.get("taskCardFields");
                if (taskCardFields != null) {
                    HashMap<String, Object> taskCardField = (HashMap<String, Object>) taskCardFields.get("taskCardField");
                    TaskCardFieldVO taskCardFieldVO = JSON.parseObject(JSON.toJSONString(taskCardField), TaskCardFieldVO.class);
                    taskCardFieldVO.setCode(pageView.getCode());
                    taskCardFieldVOList.add(taskCardFieldVO);
                }
            }
        }
        return taskCardFieldVOList;
    }

    public static String dealLang(String name, BaseObject obj, String defaultValue, String locale) {
        if (null != locale && null != obj && null != obj.getLang() && null != obj.getLang().get(name) && null != obj.getLang().get(name).get(locale)) {
            return obj.getLang().get(name).get(locale);
        }
        return defaultValue;
    }

    @Override
    public Object getPageUIElement(ViewRequest request) throws DWException {
        Map<String, Object> query = new HashMap<>();
        if (!StringUtils.isEmpty(request.getCode())) {
            query.put("code", request.getCode());
        }
        if (!StringUtils.isEmpty(request.getTaskCode())) {
            query.put("activityId", request.getTaskCode());
        }
        if (!StringUtils.isEmpty(request.getPageCode())) {
            query.put("pageCode", request.getPageCode());
        }
        List<PageUIElement> betters = dataPickService.find(BasicQuery.of(query, request.getEocInfo()), PageUIElement.class,"pageUIElement",true);

        try {
            String tenantId = ServiceUtils.getTenantId();
            // 定义Map类型的dm平铺接收容器
            List<Map<String, Object>> actionMap = new ArrayList<>();
            // 递归List的Map嵌套类型并平铺为actionMap
            recordService.batchListSetActionMap(betters, tenantId, actionMap);
            // 批量设置Action产品名称
            recordService.batchSetDataActionProductInfo(actionMap, tenantId);
        } catch (Exception e) {
            e.printStackTrace();
        }


        return betters;
    }
    @Override
    public List<Task> postTaskNamesByCodes(ViewRequest request) throws DWException {
        Map<String, Object> query = request.getQuery();
        if (MapUtils.isEmpty(query)) {
            return null;
        }
        // 只查询人工的
        query.put("executeType", "manual");
        List<Task> taskAndProjectData = getTaskAndProjectData(Task.class, query);
        if (taskAndProjectData != null && CollectionUtils.isNotEmpty(taskAndProjectData)) {
            return taskAndProjectData.stream().filter(e -> StringUtils.isBlank(e.getProjectCode())).collect(Collectors.toList());
        }
        return null;
    }

    private <T extends TenantObject> List<T> getTaskAndProjectData(Class<T> tClass, Map<String, Object> query) throws DWBusinessException {
        Object o = query.get("code");
        if (o instanceof List) {
            List<String> codes = (List<String>) o;
            List<T> taskList = Lists.newArrayListWithExpectedSize(codes.size());
            // 防止查询多分批查询
            List<List<String>> lists = CommonUtils.spliceArrays(codes, 600);
            boolean isTask = Task.class.isAssignableFrom(tClass);
            List<String> fields =
                    isTask ? ListUtil.of("code", "name", "lang", "tenantId", "eocInfo", "version", "projectCode") : ListUtil.of("code", "name", "lang", "tenantId", "eocInfo", "version", "manualAble");
            for (List<String> splitCodes : lists) {
                Map<String, Object> queryParam = new HashMap<>(query);
                queryParam.put("code", splitCodes);
                // "tenantId","eocInfo","version" 不能过滤，过滤会导致名称不正确
                BasicQuery basicQuery = BasicQuery.of(query, null);
                basicQuery.setReturnFields(fields);
                List<T> splitData = dataPickService.find(basicQuery, tClass);
                if (CollectionUtils.isNotEmpty(splitData)) {
                    taskList.addAll(splitData);
                }
            }
            return taskList;
        }
        return null;
    }

    @Override
    public List<Project> postProjectNamesByCodes(ViewRequest request) throws DWException {
        Map<String, Object> query = request.getQuery();
        if (MapUtils.isEmpty(query)) {
            return null;
        }
        // 只查询user类型
        query.put("executeType", "user");
        List<Project> taskAndProjectData = getTaskAndProjectData(Project.class, query);
        if (taskAndProjectData != null && CollectionUtils.isNotEmpty(taskAndProjectData)) {
            return taskAndProjectData.stream().filter(e -> BooleanUtils.isNotTrue(e.getManualAble())).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public List<Object> getSystemHooks(ViewRequest request) throws DWException {
        Map<String, Object> query = new HashMap<>();
        if (CollectionUtils.isNotEmpty(request.getTaskCodes())) {
            query.put("activityId", request.getTaskCodes());
        }
        if (CollectionUtils.isNotEmpty(request.getPageCodes())) {
            query.put("pageCode", request.getPageCodes());
        }
        List<PageUIElement> betters = dataPickService.findBetters(BasicQuery.of(query, request.getEocInfo()), PageUIElement.class);

        // 确保数据不为空
        if (betters == null || betters.isEmpty()) {
            // 如果列表为空，直接返回
            return new ArrayList<>();
        }

        List<Object> systemHooks =
                (List) betters.stream().filter(s -> s.getElements().containsKey("systemHooks")).flatMap(s -> ((List) s.getElements().get(
                        "systemHooks")).stream()).collect(Collectors.toList());

        return systemHooks;
    }

    /**
     * 获取项目/任务/api级别bk信息
     * 支持项目/任务/api级别bk信息获取,
     * 对于项目和任务如果BkInfo已经配置bk信息则优先取该配置,如果没有则取inputData中的信息
     * api则必须要进行配置
     */
    @SuppressWarnings({"unchecked", "rawtypes"})
    @Override
    public BkResponse postBk(BkRequest request) throws DWException {
        String tenantId = ServiceUtils.getTenantId();
        String version = dataPickService.tenantVersion(tenantId);
        BkResponse resp = new BkResponse();
        List<BkInfo> infos = knowledgeGraphService.find(
                Filters.and(
                        Filters.eq("objectType", request.getObjectType()),
                        Filters.eq("objectValue", request.getObjectValue()),
                        Filters.eq("version", version)),
                BkInfo.class, "bkInfo", KnowledgeGraphDb.SYSTEM);
        resp.setType(request.getObjectType());
        resp.setQueryCode(request.getObjectValue());
        resp.setBkInfo(infos);
        if (infos.isEmpty()) {
            Map<String, Object> m = null;
            if ("task".equalsIgnoreCase(request.getObjectType())) {
                m = dataMapTaskService.getInputData(request.getObjectValue());
            } else if ("activity".equalsIgnoreCase(request.getObjectType())) {
                m = dataMapActivityService.getInputData(request.getObjectValue());
            }
            if (null != m && null != m.get("inputData")) {
                Object obj = m.get("inputData");
                List infos2 = new ArrayList();
                Map<String, Object> info2 = new HashMap<>();
                List bk = new ArrayList();
                info2.put("bk", bk);

                if (obj instanceof DataEntityMetadataDTO) {
                    DataEntityMetadataDTO defaultbk = (DataEntityMetadataDTO) obj;
                    info2.put("entityName", defaultbk.getEntity_name());
                    info2.put("entity_name", defaultbk.getEntity_name());
                    bk.add(defaultbk);
                } else if (obj instanceof Map) {
                    Map defaultbk = (Map) obj;
                    info2.put("entityName", defaultbk.get("entity_name"));
                    info2.put("entity_name", defaultbk.get("entity_name"));
                    bk.add(defaultbk);
                } else {
                    try {
                        DataEntityMetadataDTO defaultbk = JSON.parseObject(JSON.toJSONString(obj), DataEntityMetadataDTO.class);
                        info2.put("entityName", defaultbk.getEntity_name());
                        info2.put("entity_name", defaultbk.getEntity_name());
                        bk.add(defaultbk);
                    } catch (Exception e) {
                        DataEntityMetadataDTO2 defaultbk2 = JSON.parseObject(JSON.toJSONString(obj), DataEntityMetadataDTO2.class);
                        info2.put("entityName", defaultbk2.getEntity_name());
                        info2.put("entity_name", defaultbk2.getEntity_name());
                        bk.add(defaultbk2);
                    }

                }
                infos2.add(info2);
                resp.setBkInfo(infos2);
            }
        } else {
            infos.forEach(this::transBk);
        }

        return resp;
    }

    private void transBk(BkInfo in) {
        in.setEntity_name(in.getEntityName());
        if (null != in.getBk()) {
            transbkField(in.getBk());
        }
    }

    private void transbkField(List<BkField> fields) {
        fields.forEach(fd -> {
            fd.setEntity_name(fd.getEntityName());
            fd.setData_type(fd.getDataType());
            fd.setData_name(fd.getDataName());
            fd.setBk_name(fd.getBkName());
            fd.setIs_array(fd.getIsArray());
            fd.setIs_businesskey(fd.getIsBusinesskey());
            if (null != fd.getField()) {
                transbkField(fd.getField());
            }
        });
    }

    /**
     * 仅有任务支持校验规则获取.
     * 校验规则以侦测规则形式进行配置.bkinfo中包含ruleId指向对应的校验信息
     * 如果传入任务code表示仅查询一个任务的校验信息,如果不传入则需要查询所有任务的校验信息并做合并Action_params和Return_columns两项
    */
    @Override
    public BkResponse postBkMeta(BkRequest request) throws DWException {
        String tenantId = ServiceUtils.getTenantId();
        String version = dataPickService.tenantVersion(tenantId);
        BkResponse resp = new BkResponse();
        Bson query;
        if ("activityCheckCycle".equalsIgnoreCase(request.getObjectType())) {
            query = Filters.eq("objectType", "activityCheckCycle");
        } else {
            String bkConcat = bkConcat(request.getBk());
            query = Filters.and(
                    Filters.eq("objectType", "activityCheck"),
                    Filters.eq("bkConcat", bkConcat),
                    Filters.eq("entityName", request.getEntityName()));
            resp.setBkConcat(bkConcat);
        }

        if (request.getTaskCode() != null) {
            query = Filters.and(query, Filters.eq("objectValue", request.getTaskCode()));
        }

        if (request.getActivityCode() != null) {
            query = Filters.and(query, Filters.eq("objectValue", request.getActivityCode()));
        }

        query = Filters.and(query, Filters.eq("version", version));
        List<BkInfo> infos = knowledgeGraphService.find(query, BkInfo.class, "bkInfo", KnowledgeGraphDb.SYSTEM);
        resp.setQueryCode(request.getTaskCode());
        resp.setEntityName(request.getEntityName());

        if (!infos.isEmpty()) {
            MonitorRuleDTO dto = null;
            try {
                dto = dataMapKgService.queryMonitorRule(infos.get(0).getRuleId(), tenantId);
            } catch (DWBusinessException e) {
                log.error("queryMonitorRule error", e);
            }
            if (dto == null) {
                return resp;
            }
            resp.setRule(dto);
            resp.setProductName(dto.getProduct_name());
            if (infos.size() > 1) {
                // TODO 这里kg原来是走的线程池，需要确认是否还需要加线程池
                List<String> ruleIds = new ArrayList<>();
                for (int i = 1; i < infos.size(); i++) {
                    BkInfo info = infos.get(i);
                    if (null != info.getRuleId() && !ruleIds.contains(info.getRuleId())) {
                        ruleIds.add(info.getRuleId());
                    }
                }
                Set<ActionParamDTO> params = new HashSet<>();
                Set<ReturnColumnDTO> returnCols = new HashSet<>();
                for (String ruleId : ruleIds) {
                    MonitorRuleDTO rule = null;
                    try {
                        rule = dataMapKgService.queryMonitorRule(ruleId, tenantId);
                    } catch (DWBusinessException e) {
                        log.error("queryMonitorRule error", e);
                    }
                    if (null != rule) {
                        if (null != rule.getAction_params()) {
                            params.addAll(rule.getAction_params());
                        }
                        if (null != rule.getReturn_columns()) {
                            returnCols.addAll(rule.getReturn_columns());
                        }
                    }
                }
                dto.setAction_params(new ArrayList<>());
                dto.setReturn_columns(new ArrayList<>());
                dto.getAction_params().addAll(params);
                dto.getReturn_columns().addAll(returnCols);
            }
        }
        return resp;
    }

    @Override
    public Object postTasksWithCustomize(TasksWithCustomizeRequest request) throws DWException {
        Map<String, Object> query = new HashMap<>();
        query.put("application", request.getApplication());
        query.put("executeType", request.getExecuteTypeList());
        List<Task> tasks = dataPickService.find(BasicQuery.of(query, null), Task.class);
        if (CollectionUtils.isEmpty(tasks)) {
            return null;
        }
        try {
            List<Map<String, Object>> mapList = JSON.parseObject(JSON.toJSONString(tasks), new TypeReference<List<Map<String, Object>>>() {
            });
            // 查询该任务是否是客制的页面
            for (Map<String, Object> map : mapList) {
                Optional<Boolean> isCustomizeOpt = getIsCustomize(map);
                Boolean isCustomize = isCustomizeOpt.orElse(null);
                map.put("isCustomize", isCustomize);
            }
            return mapList;
        } catch (Exception e) {
            log.error("postTasksWithCustomize failed, request:" + JSON.toJSONString(request) + ", error:{}", e);
        }
        return null;
    }

    @Override
    public Object postActivityInputDataEntityName(BkRequest request) throws DWException {
        List<BkInfo> infos = knowledgeGraphService.find(
                Filters.and(
                        Filters.eq("version", dataPickService.tenantVersion()),
                        Filters.eq("objectType", request.getObjectType()),
                        Filters.in("objectValue", request.getObjectValues())),
                BkInfo.class, "bkInfo", KnowledgeGraphDb.SYSTEM);
        infos = MergeUtil.excludeWithSameCode(infos, BkInfo::getObjectValue, BkInfo::getSourceLevel);
        // 转成map
        Map<String, String> activityEntityNameMap = infos.stream().collect(Collectors.toMap(BkInfo::getObjectValue, BkInfo::getEntityName));
        List<String> notFound = new ArrayList<>();
        for (String activityCode : request.getObjectValues()) {
            if (!activityEntityNameMap.containsKey(activityCode)) {
                notFound.add(activityCode);
            }
        }
        Map<String, Object> param = new HashMap<>();
        param.put("code", notFound);
        List<Task> tasks = dataPickService.find(BasicQuery.of(param, null), Task.class);
        for (Task task : tasks) {
            Object eval = JSONPath.eval(task.getInputData(), "$.entity_name");
            activityEntityNameMap.put(task.getCode(), eval != null ? eval.toString() : "");
        }
        return activityEntityNameMap;
    }

    private Optional<Boolean> getIsCustomize(Map<String, Object> map) throws Exception {
        // 获取 "code" 字段并检查为空
        Object object = map.get("code");
        if (object == null) {
            return Optional.empty();
        }
        String code = object.toString();
        // 获取 activityDefinition，若为空则直接返回 Optional.empty()
        Object activityDefinition = dataMapTaskService.getActivityDefinition(code, "task-detail");
        if (activityDefinition == null) {
            log.error("getIsCustomize getActivityDefinition not found Definition code: {}", code);
            return Optional.empty();
        }
        // 解析 activityDefinition
        JSONObject jsonObject = JSON.parseObject(JSON.toJSONString(activityDefinition));
        JSONObject pages = jsonObject.getJSONObject("pages");
        // 获取 isCustomize，若为空则检查 "pattern" 是否为 "CUSTOM"
        Boolean isCustomize = Optional.ofNullable(pages)
                .map(p -> p.getBoolean("isCustomize"))
                .orElse("CUSTOM".equals(jsonObject.getString("pattern")) ? Boolean.TRUE : null);
        return Optional.ofNullable(isCustomize);
    }

    private static String bkConcat(List<String> bks) {
        Collections.sort(bks);
        StringBuilder sb = new StringBuilder();
        bks.forEach(bk -> {
            sb.append(bk).append("$&");
        });
        return sb.toString();
    }
}
