package com.digiwin.athena.datamap.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.log.operation.annotation.DWIgnoreFileLog;
import com.digiwin.app.resource.DWResourceBundleUtils;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.datamap.filter.DataMapFilter;
import com.digiwin.athena.datamap.filter.LoginInfo;
import com.digiwin.athena.datamap.kg.DataMapMongoEntityBaseDAO;
import com.digiwin.athena.datamap.povo.CheckAppExpirePo;
import com.digiwin.athena.datamap.service.IAppService;
import com.digiwin.athena.datamap.service.inner.DataMapKgDataPickService;
import com.digiwin.athena.datamap.service.inner.KmService;
import com.digiwin.athena.datamap.spi.IKnowledgeGraphService;
import com.digiwin.athena.datamap.spi.DataMapIamService;
import com.digiwin.athena.datamap.kg.DataMapLicenseKeyManager;
import com.digiwin.athena.datamap.utils.AthenaUtils;
import com.digiwin.athena.datamap.utils.DatamapESPUtils;
import com.digiwin.athena.datamap.utils.DataMapTranslateUtils;
import com.digiwin.athena.domain.core.app.Application;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.domain.core.app.FunctionCtrl;
import com.digiwin.athena.domain.definition.FieldDescription;
import com.digiwin.athena.kg.activity.Activity;
import com.digiwin.athena.kg.monitorRule.MonitorRule;
import com.digiwin.athena.kg.monitorRule.MonitorRuleProductConfig;
import com.digiwin.athena.kg.action.Action;
import com.digiwin.athena.kg.Constants;
import com.digiwin.athena.kg.domain.*;
import com.digiwin.athena.kg.dto.AppRelationBatchPo;
import com.digiwin.athena.kg.dto.ApplicationRelationQueryDTO;
import com.digiwin.athena.kmservice.locale.Lang;

import com.digiwin.athena.kmservice.utils.I18nUtils;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import com.digiwin.athena.repository.neo4j.ActionRepository;
import com.digiwin.athena.repository.neo4j.MonitorRuleRepository;
import com.google.common.collect.Lists;
import com.mongodb.bulk.BulkWriteResult;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.util.Pair;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.RequestBody;

import java.lang.reflect.Field;
import java.util.*;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@Lang
@Slf4j
@Service
@MyExceptionHandler
public class DatamapAppService implements IAppService {

    @Autowired
    private DataMapLicenseKeyManager dataMapLicenseKeyManager;

    @Autowired
    @Qualifier("kgSystem")
    private MongoTemplate mongoTemplate;
    @Autowired
    private DataMapIamService dataMapIamService;

    @Autowired
    DataMapTenantService dataMapTenantService;

    @Autowired
    DataMapMongoEntityBaseDAO dataMapMongoEntityBaseDAO;

    @Autowired
    KmService kmService;
    @Autowired
    @Qualifier("kgDataPickService")
    private DataMapKgDataPickService dataPickService;
    @Autowired
    IKnowledgeGraphService knowledgeGraphService;
    @Autowired
    MonitorRuleRepository monitorRuleRepository;
    @Autowired
    private DatamapESPUtils datamapEspUtils;
    @Autowired
    DataMapTranslateUtils dataMapTranslateUtils;

    @Autowired
    ActionRepository actionRepository;

    @Override
    public ApplicationRelation getApplicationByTypeAndCode(String type, String code) throws DWBusinessException {
        Criteria criteria = new Criteria();
        criteria.and("code").is(code).and("type").is(type);
        return dataPickService.findOneByCondition(criteria, ApplicationRelation.class, "applicationRelation");
        
    }

    @Override
    public ApplicationRelation getApplicationByTypeAndCodeAndLang1(String type, String code, String lang) throws DWBusinessException {
        ApplicationRelation applicationRelation = getApplicationByTypeAndCode(type, code);
        Application application = null;
        try {
            application = getApplicationByCode(applicationRelation.getAppCode());
        } catch (Exception e) {
            log.warn("获取应用异常 for type:{},code:{}", type, code);
        }
        if (application != null && application.getLang() != null) {
            Map nameLangMap = application.getLang().get("name");
            String language = null == nameLangMap.get(lang) ? application.getName() : (String) nameLangMap.get(lang);
            applicationRelation.setAppName(org.springframework.util.StringUtils.isEmpty(language) ? applicationRelation.getAppName() : language);
        }
        return applicationRelation;
    }

    @Override
    @DWIgnoreFileLog
    public Map<String, List<ApplicationRelation>> postApplicationsMapByTypeAndCodesAndActivityMap(ApplicationRelationQueryDTO queryDTO) throws DWBusinessException {
        Map<String, Object> keyConditions = new HashMap<>();
        keyConditions.put("type", queryDTO.getType());
        Map<String, List<ApplicationRelation>> applicationRelationsMap = dataMapMongoEntityBaseDAO.find(keyConditions, "code"
                , queryDTO.getCodes(), ApplicationRelation.class, queryDTO.getActivityMap());
        //Assert.notNull(applicationRelation, "查询结果为空");
        //[{"type":"1","code":"1"},{"type":"1","code":"1","tenantId":"1"},{"type":"1","code":"2","tenantId":"1"}]
        return applicationRelationsMap;
    }

    @Override
    public Map<String, List<ApplicationRelation>> postApplicationsMapByTypeAndCodes(ApplicationRelationQueryDTO queryDTO) throws DWBusinessException {
        Map<String, Object> keyConditions = new HashMap<>();
        keyConditions.put("type", queryDTO.getType());
        Map<String, List<ApplicationRelation>> applicationRelationsMap = dataMapMongoEntityBaseDAO.find(keyConditions, "code", queryDTO.getCodes(), ApplicationRelation.class, new HashMap<>());
        //Assert.notNull(applicationRelation, "查询结果为空");
        //[{"type":"1","code":"1"},{"type":"1","code":"1","tenantId":"1"},{"type":"1","code":"2","tenantId":"1"}]
        return applicationRelationsMap;
    }

    @Override
    public List<ApplicationRelation> postApplicationByTypeAndCodeList(ApplicationRelationQueryDTO queryDTO) throws DWBusinessException {
        return postApplicationByTypeAndSubTypeAndCodeList(queryDTO);
    }

    @Override
    public List<ApplicationRelation> postApplicationByTypeAndSubTypeAndCodeList(ApplicationRelationQueryDTO queryDTO) throws DWBusinessException {
        Criteria criteria = Criteria.where("type").is(queryDTO.getType())
                .and("code").in(queryDTO.getCodes());
        if (StringUtils.isNotEmpty(queryDTO.getSubType())) {
            criteria.and("subType").is(queryDTO.getSubType());
        }
        return dataPickService.find(criteria, ApplicationRelation.class, "applicationRelation");
    }

    @Override
    public List<ApplicationRelation> getApplicationsByTypeAndCode(String type, String code) throws DWBusinessException {
        ApplicationRelationQueryDTO queryDTO = ApplicationRelationQueryDTO.builder().type(type).codes(Collections.singletonList(code)).build();
        return postApplicationByTypeAndSubTypeAndCodeList(queryDTO);
    }

    @Override
    public List<Application> postApplicationsByCodes(Collection<String> codes) throws DWBusinessException {
        Criteria criteria = Criteria.where("code").in(codes);
        return dataPickService.find(criteria, Application.class, "application");
    }

    @Override
    public Application getApplicationByCode(String code) throws DWBusinessException {
        String tenantId = ServiceUtils.getTenantId();
        return getApplicationByCodeAndTenantId(code, tenantId);
    }

    @Override
    public Application getApplicationByCodeAndTenantId(String code, String tenantId) throws DWBusinessException {
        Criteria criteria = new Criteria();
        criteria.and("code").is(code);
        return dataPickService.findOneByCondition(criteria, tenantId, Application.class, "application");
    }

    @Override
    public FunctionCtrl getApplicationFunctionCtrlByBizCode(String code) throws DWBusinessException {
        Application application = getApplicationByCode(code);
        if (null == application) {
            throw new DWBusinessException("app not found");
        } else {
            return application.getFunctionCtrl();
        }
    }

    @Override
    public FunctionCtrl getApplicationFunctionCtrlByAppCode(String code) throws DWBusinessException {
        /*Application application = getApplicationByCode(code);
        if (null == application) {
            throw new DWBusinessException("app not found");
        } else {
            return application.getFunctionCtrl();
        }*/
        FunctionCtrl functionCtrl = new FunctionCtrl();
        functionCtrl.setProjectCardCustomizeFlag(true);
        functionCtrl.setTaskCardCustomizeFlag(true);
        functionCtrl.setTaskCardMergeCustomizeFlag(true);
        return functionCtrl;
    }

    @Override
    public List<Map> getApplicationRecommendations() throws DWBusinessException {
        Locale locale = DWResourceBundleUtils.getCurrentLocale();
        String localeStr = locale.toString();
        String tenantId = ServiceUtils.getTenantId();
        String tenantVersion = kmService.tenantVersion() ;
        //String tenantVersion = "init";
        // 获取租户下有权限的应用
        List<String> tenantAppCodes = dataMapTenantService.getAppCodes();
        /*List<String> tenantAppCodes = new ArrayList<String>(){{
            add("PWD");
            add("PCC");
        }};*/
        Criteria criteria = new Criteria();
        criteria.and("appCode").in(tenantAppCodes).and("version").is(tenantVersion);
        List<ApplicationRecommendation> applicationRecommendations = mongoTemplate.find(new Query(criteria),
                ApplicationRecommendation.class);
        Map<String, List<ApplicationRecommendation>> groupedApplicationRecommendations = null;
        List<Map> resultList = new LinkedList<>();
        if (CollectionUtils.isNotEmpty(applicationRecommendations)) {
            applicationRecommendations.forEach(item -> {
                if (!org.springframework.util.StringUtils.isEmpty(item.getLang().get("template").get(localeStr))) {
                    item.setTemplate(item.getLang().get("template").get(localeStr));
                }
                if (!org.springframework.util.StringUtils.isEmpty(item.getLang().get("appName").get(localeStr))) {
                    item.setAppName(item.getLang().get("appName").get(localeStr));
                }
            });
            groupedApplicationRecommendations = applicationRecommendations
                    .stream().collect(Collectors.groupingBy(s -> s.getAppCode()));
            groupedApplicationRecommendations.forEach((k, v) -> {
                Map<String, Object> innerMap = new HashMap<>();
                innerMap.put("appCode", k);
                innerMap.put("appName", v.get(0).getAppName());
                innerMap.put("group", v.stream().sorted(Comparator.comparing(ApplicationRecommendation::getWeight).reversed()).collect(Collectors.toList()));
                resultList.add(innerMap);
            });
        }
        return resultList;
    }

    @DWIgnoreFileLog
    public Map<String, List<ApplicationRelation>> getApplicationRelationsMapByTypeAndCodesAndLang(String type,
                                                                                                  Collection<String> codes, String lang, Map<String, Activity> activityMap) throws DWBusinessException {
        ApplicationRelationQueryDTO queryDTO = ApplicationRelationQueryDTO.builder().type(type).codes((List<String>) codes).activityMap(activityMap).build();
        Map<String, List<ApplicationRelation>> applicationRelationsMap = postApplicationsMapByTypeAndCodesAndActivityMap(queryDTO);
        Set<String> applicationsCodes = new HashSet<>();
        applicationRelationsMap.values().forEach(item -> {
            if (!CollectionUtils.isEmpty(item)) {
                item.forEach(itemI -> applicationsCodes.add(itemI.getAppCode()));
            }
        });
        List<Application> applications = postApplicationsByCodes(applicationsCodes);
        Map<String, Application> applicationMap = applications.stream().collect(Collectors.toMap(Application::getCode
                , Function.identity(), (a, b) -> b));
        applicationRelationsMap.forEach((k, v) -> {
            v.forEach(applicationRelation -> {
                Application application = applicationMap.get(applicationRelation.getAppCode());
                if (application != null) {
                    applicationRelation.setCommonApp(null == application.getCommonApp() ? false : application.getCommonApp());
                } else {
                    applicationRelation.setCommonApp(false);
                }
                if (application != null && application.getLang() != null) {
                    Map nameLangMap = application.getLang().get("name");
                    String language = null == nameLangMap.get(lang) ? application.getName() :
                            (String) nameLangMap.get(lang);
                    applicationRelation.setAppName(org.springframework.util.StringUtils.isEmpty(language) ?
                            applicationRelation.getAppName() : language);
                }
            });
        });
        return applicationRelationsMap;
    }


    @Override
    public Map<String, List<ApplicationRelation>> postApplicationRelationsMapByTypeAndCodesAndLang(ApplicationRelationQueryDTO queryDTO) throws DWBusinessException {
        //   log.info("getApplicationByTypeAndCodeAndLang");
        Map<String, List<ApplicationRelation>> applicationRelationsMap = postApplicationsMapByTypeAndCodes(queryDTO);
        Set<String> applicationsCodes = new HashSet<>();
        applicationRelationsMap.values().forEach(item -> {
            if (!CollectionUtils.isEmpty(item)) {
                item.forEach(itemI -> applicationsCodes.add(itemI.getAppCode()));
            }
        });
        List<Application> applications = postApplicationsByCodes(applicationsCodes);
        Map<String, Application> applicationMap = applications.stream().collect(Collectors.toMap(Application::getCode, Function.identity()));
        applicationRelationsMap.forEach((k, v) -> {
            v.forEach(applicationRelation -> {
                Application application = applicationMap.get(applicationRelation.getAppCode());
                if (application != null && application.getLang() != null) {
                    Map nameLangMap = application.getLang().get("name");
                    String language = null == nameLangMap.get(queryDTO.getLang()) ? application.getName() : (String) nameLangMap.get(queryDTO.getLang());
                    applicationRelation.setAppName(org.springframework.util.StringUtils.isEmpty(language) ? applicationRelation.getAppName() : language);
                }
            });
        });
        return applicationRelationsMap;
    }

    @Override
    public List<ApplicationRelation> getApplicationRelationsByTypeAndCodeAndLang(String type, String code, String lang) throws DWBusinessException {
        //   log.info("getApplicationByTypeAndCodeAndLang");
        List<ApplicationRelation> applicationRelations = getApplicationsByTypeAndCode(type, code);
        if (CollectionUtils.isEmpty(applicationRelations)) {
            return new LinkedList<>();
        }
        applicationRelations.forEach(applicationRelation -> {
            Application application = null;
            try {
                application = getApplicationByCode(applicationRelation.getAppCode());
            } catch (DWBusinessException e) {
                log.warn("获取应用异常", e);
            }
            if (application != null && application.getLang() != null) {
                Map nameLangMap = application.getLang().get("name");
                String language = null == nameLangMap.get(lang) ? application.getName() : (String) nameLangMap.get(lang);
                applicationRelation.setAppName(org.springframework.util.StringUtils.isEmpty(language) ? applicationRelation.getAppName() : language);
            }
        });
        return applicationRelations;
    }

    @Override
    public ApplicationRelation getApplicationByTypeAndCodeAndLang(String type, String code, String lang) throws DWBusinessException {
        //   log.info("getApplicationByTypeAndCodeAndLang");
        ApplicationRelation applicationRelation = getApplicationByTypeAndCode(type, code);
        if (null != applicationRelation) {
            Application application = getApplicationByCode(applicationRelation.getAppCode());
            if (application == null || application.getLang() == null) {
                return applicationRelation;
            }
            Map nameLangMap = application.getLang().get("name");
            String language = null == nameLangMap.get(lang) ? application.getName() : (String) nameLangMap.get(lang);
            applicationRelation.setAppName(org.springframework.util.StringUtils.isEmpty(language) ? applicationRelation.getAppName() : language);
        }
        return applicationRelation;
    }

    @Override
    public Map<String, ApplicationRelation> postApplicationRelationsMapByApplicationAndLang(ApplicationRelationQueryDTO queryDTO) throws DWBusinessException {
        Map<String, ApplicationRelation> applicationRelations = new HashMap<>();
        List<String> codes = queryDTO.getCodes();
        List<Application> applications = postApplicationsByCodes(codes);
        for (Application item : applications) {
            if (!codes.contains(item.getCode()) || item.getLang() == null) {
                throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.appNotFound") + item.getCode());
            }
            Map nameLangMap = item.getLang().get("name");
            String language = null == nameLangMap.get(queryDTO.getLocaleStr()) ? item.getName() : (String) nameLangMap.get(queryDTO.getLocaleStr());
            ApplicationRelation applicationRelation = new ApplicationRelation();
            applicationRelation.setAppName(org.springframework.util.StringUtils.isEmpty(language) ? applicationRelation.getAppName() : language);
            applicationRelation.setAppCode(item.getCode());
            applicationRelations.put(applicationRelation.getCode(), applicationRelation);
        }
        return applicationRelations;
    }

    @Override
    public ApplicationRelation getApplicationRelationByApplicationAndLang(String code, String localeStr) throws DWBusinessException {
        ApplicationRelation applicationRelation = new ApplicationRelation();
        Application application = getApplicationByCode(code);
        if (application == null || application.getLang() == null) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.appNotFound") + code);
        }
        Map nameLangMap = application.getLang().get("name");
        String language = null == nameLangMap.get(localeStr) ? application.getName() : (String) nameLangMap.get(localeStr);
        applicationRelation.setAppName(org.springframework.util.StringUtils.isEmpty(language) ? applicationRelation.getAppName() : language);
        applicationRelation.setAppCode(code);
        return applicationRelation;
    }

    //   @Cache(namespace = REDIS_KNOWLEDGE_GRAPH, key = "getLicenseKey$0", ttlSecs = 7200, loadEmpty = true)
    @Override
    public Object getLicenseKey(String tenantId) throws Exception {
        //return DWServiceResultBuilder.build(new LicenseKeyManager().getLicenseKey(tenantId));
        return this.dataMapLicenseKeyManager.getLicenseKey(tenantId);
    }

    @Override
    public Object getLicenseKeyByTenantIdAndRequestFromAndKeyAndTime(String tenantId, String requestFrom, String key, long timestamp) throws Exception {
        //  return DWServiceResultBuilder.build(new LicenseKeyManager().getLicenseKey(tenantId,requestFrom,key,timestamp));
        return this.dataMapLicenseKeyManager.getLicenseKey(tenantId, requestFrom, key, timestamp);
    }

    @Override
    public Object postSetLicenseKey() throws Exception {
        String athenaLicenceKey = dataMapIamService.getAthenaLicenceKey();
        String tenantId = ServiceUtils.getTenantId();
        this.dataMapLicenseKeyManager.setLicenseKey(tenantId, athenaLicenceKey);
        return "success";
    }

    @Override
    public Object postSetLicenseKeyByTenantId(String tenantId) throws Exception {
        String athenaLicenceKey = dataMapIamService.getAthenaLicenceKey(tenantId);
        log.info("SetLicenseKeyTenantId:{},athenaLicenceKey:{}", tenantId, athenaLicenceKey);
        this.dataMapLicenseKeyManager.setLicenseKey(tenantId, athenaLicenceKey);
        return "success";
    }

    @Override
    public Object get(String code) throws Exception {
        if (code == null || code.isEmpty()) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.codeEmpty"));
        }
        String tenantId = ServiceUtils.getTenantId();
        String tenantVersion = kmService.tenantVersion();
        Application app = null;
        if ("common".equals(code)) {
            String prefix = "BCB"; // 要匹配的前缀字符串
            Pattern pattern = Pattern.compile("^" + prefix);
            Criteria criteria = Criteria.where("code").regex(pattern).and("version").is(tenantVersion);
            List<Application> apps = dataPickService.find(criteria, Application.class, "application");
            if (!org.springframework.util.CollectionUtils.isEmpty(apps)) {
                List<Application> commonApps = apps.stream().filter(application -> application.getCommonApp() != null && application.getCommonApp()).collect(Collectors.toList());
                if (!org.springframework.util.CollectionUtils.isEmpty(commonApps)) {
                    app = commonApps.get(0);
                }
            }
        } else {
            app = getApplicationByCode(code);
        }
        /*if (null != app && null != app.getCommonApp() && app.getCommonApp()) {
            return app;
        }*/
        /*if (StringUtils.equalsIgnoreCase("common", code) && ObjectUtils.isEmpty(app)) {
            return new Application();
        }*/
        //设置默认值
        if (CollectionUtils.isEmpty(app.getParamDescription())) {
            app.setParamDescription(new ArrayList<>());
        }
        for (FieldDescription p : app.getParamDescription()) {
            if (p.getExecutable() == null) {
                p.setExecutable(1);//默认打开立即执行按钮
            }
        }
        //从applicationRelation获取侦测规则
        processMonitorRule(app);
        //从applicationRelation获取变量
        processVariable(app);
        //开窗条件组合
        Map<String, Map<String, String>> openWin = new HashMap<>();
        for (FieldDescription p : app.getParamDescription()) {
            if (p.getFieldOpenWindowMap() != null && !p.getFieldOpenWindowMap().isEmpty()) {
                Map<String, String> map = new HashMap<>();
                for (FieldOpenWindowSetting setting : p.getFieldOpenWindowMap()) {
                    map.put(setting.getColumn(), setting.getOpenWindowKey());
                }
                openWin.put(p.getKey(), map);
            }
        }
        // 处理参数对应的开窗信息
        Map<String, Map<String, OpenWindowDefinition>> openWinInfo = postOpenWinInfo(openWin);
        for (FieldDescription p : app.getParamDescription()) {
            Map<String, OpenWindowDefinition> temp = openWinInfo.get(p.getKey());
            p.setFieldOpenWindowDefinitions(temp);
        }

        //组装组件过滤
//        this.filterByComponentManager(app);

        //按sequence排序
        if (CollectionUtils.isNotEmpty(app.getParamDescription())) {
            app.getParamDescription().sort((o1, o2) -> o1.getSequence().compareTo(o2.getSequence()));
        }

        return app;
    }

    /*private void filterByComponentManager(Application app) throws DWBusinessException {
        List<FieldDescription> list = app.getParamDescription();
        if (CollectionUtils.isNotEmpty(list)) {
            Map<String, FieldDescription> map = new HashMap<>();
            List<ComponentBaseInfoBO> componentBaseInfos = new ArrayList<>();
            for (FieldDescription f : list) {
                map.put(f.getKey(), f);
                ComponentBaseInfoBO info = new ComponentBaseInfoBO();
                info.setCode(f.getKey());
                if (StringUtils.equalsIgnoreCase(f.getCategory(), "period")) {
                    info.setType(ComponentTypeEnum.MonitorRule);
                } else if (StringUtils.equalsIgnoreCase(f.getCategory(), "variable")) {
                    info.setType(ComponentTypeEnum.MechanismVariable);
                } else {
                    info.setType(ComponentTypeEnum.ApplicationParam);
                }
                componentBaseInfos.add(info);
            }
            //过滤
            List<ComponentBaseInfoBO> filterComponents = componentManager.FilterByTenantApplicationComponentList(app.getCode(), ServiceUtils.getTenantId(), componentBaseInfos);
            List<FieldDescription> filterParams = new ArrayList<>();
            if (CollectionUtils.isNotEmpty(filterComponents)) {//过滤掉所有数据
                if (list.size() == filterComponents.size()) {//数量相同无需过滤
                    filterParams = list;
                } else {
                    for (ComponentBaseInfoBO c : filterComponents) {
                        filterParams.add(map.get(c.getCode()));
                    }
                }
            }
            app.setParamDescription(filterParams);
        }
    }*/

    protected void processVariable(Application app) throws DWBusinessException {
        List<String> variableList = this.getVariableCode(app.getCode());
        if (variableList != null && !variableList.isEmpty()) {
            if (app.getParamDescription() != null) {
                int seq = 1000;
                for (String code : variableList) {
                    boolean existed = false;
                    for (FieldDescription p : app.getParamDescription()) {
                        if (p.getCategory().toLowerCase(Locale.ROOT).equals("variable") && p.getKey().equals(code)) {
                            existed = true;
                            break;
                        }
                    }
                    if (existed) {
                        continue;
                    } else {
                        FieldDescription para = createVariableParam(code);
                        if (para.getSequence() == null) {
                            para.setSequence(seq);
                            seq += 10;
                        }
                        setFieldDescriptionValue(para);
                        app.getParamDescription().add(para);
                    }
                }
            } else {
                List<FieldDescription> paras = new ArrayList<>();
                int seq = 1000;
                for (String code : variableList) {
                    FieldDescription para = createVariableParam(code);
                    if (para.getSequence() == null) {
                        para.setSequence(seq);
                        seq += 10;
                    }
                    setFieldDescriptionValue(para);
                    paras.add(para);
                }
                app.setParamDescription(paras);
            }
        }
    }

    public FieldDescription createVariableParam(String variableCode) throws DWBusinessException {
//        String tenantId = ServiceUtils.getTenantId();
//        String tenantVersion = kmService.tenantVersion(tenantId);
//        FieldDescription para = new FieldDescription();
//        para.setKey(variableCode);
//        para.setCategory("variable");
//        para.setDataType("string");
//        para.setRequired(true);
//        para.setReadOnly(false);
//        para.setIsExecute(true);
//        para.setDisplayType("STRING");
//        para.setName(variableCode);
//        para.setDescription(variableCode);
//
//        // 去variableDefinition表中查找侦测规则code对应的参数信息
//        handleParaFromVariD(variableCode, tenantVersion, para);
//
//        return para;

        return this.createVariableParam(variableCode, null);
    }

    public FieldDescription createVariableParam(String variableCode, Map<String, VariableDefinition> variableDefinitionsMap) throws DWBusinessException {
        String tenantId = ServiceUtils.getTenantId();
        String tenantVersion = kmService.tenantVersion();
        FieldDescription para = new FieldDescription();
        para.setKey(variableCode);
        para.setCategory("variable");
        para.setDataType("string");
        para.setRequired(true);
        para.setReadOnly(false);
        para.setIsExecute(true);
        para.setDisplayType("STRING");
        para.setName(variableCode);
        para.setDescription(variableCode);

        // 去variableDefinition表中查找侦测规则code对应的参数信息
        handleParaFromVariD(variableCode, tenantVersion, para, variableDefinitionsMap);

        return para;
    }

    public FieldDescription createDefaultParam(String variableCode) throws DWBusinessException {
//        String tenantId = ServiceUtils.getTenantId();
//        String tenantVersion = kmService.tenantVersion(tenantId);
//        FieldDescription para = new FieldDescription();
//        para.setKey(variableCode);
//        para.setDataType("object");
//        para.setRequired(true);
//        para.setReadOnly(false);
//        para.setIsExecute(true);
//        para.setName(variableCode);
//        para.setDescription(variableCode);
//
//        // 去variableDefinition表中查找侦测规则code对应的参数信息
//        FieldDescription fieldDescription = handleParaFromVariD(variableCode, tenantVersion, para);
//
//
//        return fieldDescription == null ? null : para;

        return this.createDefaultParam(variableCode, null);
    }

    public FieldDescription createDefaultParam(String variableCode, Map<String, VariableDefinition> variableDefinitionsMap) throws DWBusinessException {
        String tenantId = ServiceUtils.getTenantId();
        String tenantVersion = kmService.tenantVersion();
        FieldDescription para = new FieldDescription();
        para.setKey(variableCode);
        para.setDataType("object");
        para.setRequired(true);
        para.setReadOnly(false);
        para.setIsExecute(true);
        para.setName(variableCode);
        para.setDescription(variableCode);

        // 去variableDefinition表中查找侦测规则code对应的参数信息
        FieldDescription fieldDescription = handleParaFromVariD(variableCode, tenantVersion, para, variableDefinitionsMap);


        return fieldDescription == null ? null : para;
    }

    public FieldDescription createLinkParam(String variableCode) throws DWBusinessException {
//        String tenantId = ServiceUtils.getTenantId();
//        String tenantVersion = kmService.tenantVersion(tenantId);
//        FieldDescription para = new FieldDescription();
//        para.setKey(variableCode);
//        para.setCategory("link");
//        para.setDataType("object");
//        para.setRequired(true);
//        para.setReadOnly(false);
//        para.setIsExecute(true);
//        para.setDisplayType("LINK");
//        para.setName(variableCode);
//        para.setDescription(variableCode);
//
//        // 去variableDefinition表中查找侦测规则code对应的参数信息
//        handleParaFromVariD(variableCode, tenantVersion, para);
//
//        return para;
        return this.createLinkParam(variableCode, null);
    }

    public FieldDescription createLinkParam(String variableCode, Map<String, VariableDefinition> variableDefinitionsMap) throws DWBusinessException {
        String tenantId = ServiceUtils.getTenantId();
        String tenantVersion = kmService.tenantVersion();
        FieldDescription para = new FieldDescription();
        para.setKey(variableCode);
        para.setCategory("link");
        para.setDataType("object");
        para.setRequired(true);
        para.setReadOnly(false);
        para.setIsExecute(true);
        para.setDisplayType("LINK");
        para.setName(variableCode);
        para.setDescription(variableCode);

        // 去variableDefinition表中查找侦测规则code对应的参数信息
        handleParaFromVariD(variableCode, tenantVersion, para, variableDefinitionsMap);

        return para;
    }

    protected void processMonitorRule(Application app) throws DWBusinessException {
        List<String> ruleList = this.getMonitorRuleCode(app.getCode());
        if (ruleList != null && !ruleList.isEmpty()) {
            if (app.getParamDescription() != null) {
                int seq = 1000;
                for (String ruleId : ruleList) {
                    boolean existed = false;
                    for (FieldDescription p : app.getParamDescription()) {
                        if (p.getCategory().toLowerCase(Locale.ROOT).equals("period") && p.getExtendData().equals(ruleId)) {
                            existed = true;
                            break;
                        }
                    }
                    if (existed) {
                        continue;
                    } else {
                        FieldDescription para = createMonitorRuleParam(ruleId, true);
                        if (null == para) {
                            continue;
                        }
                        if (para.getSequence() == null) {
                            para.setSequence(seq);
                            seq += 10;
                        }
                        app.getParamDescription().add(para);
                    }
                }
            } else {
                List<FieldDescription> paras = new ArrayList<>();
                int seq = 1000;
                for (String ruleId : ruleList) {
                    FieldDescription para = createMonitorRuleParam(ruleId, true);
                    if (null == para) {
                        continue;
                    }
                    if (para.getSequence() == null) {
                        para.setSequence(seq);
                        seq += 10;
                    }
                    paras.add(para);
                }
                app.setParamDescription(paras);
            }
        }
    }

    public FieldDescription createMonitorRuleParam(String ruleId, boolean keyPrefix) throws DWBusinessException {
//        //交付设计器暂不考虑个案场景 获取个案新增侦测
//////        List<MonitorRule> monitorRules = this.monitorRuleRepository.getAddedCustomByCode(ruleId, "tenantId");
//////        if (monitorRules == null || monitorRules.isEmpty()) {//不存在个案新增侦测
//////            monitorRules = this.monitorRuleRepository.findByCodeAndVersion(ruleId);//获取标准侦测
//////        }
////        String tenantId = ServiceUtils.getTenantId();
////        String tenantVersion = kmService.tenantVersion(tenantId);
////        FieldDescription para = new FieldDescription();
////
////        // 去variableDefinition表中查找侦测规则code对应的参数信息
////        handleParaFromVariD(ruleId, tenantVersion, para);
////
////        if(StringUtils.isEmpty(para.getKey())){  //如果没有找到定义，才用下面方式构造，避免无效的查询
////            List<MonitorRule> monitorRules  = this.monitorRuleRepository.findByCodeAndVersion(ruleId, tenantVersion);//获取标准侦测
////            if (monitorRules==null || monitorRules.size()==0) {
////                throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.monitorNotFound",ruleId));
////            }
////            MonitorRule monitorRule = monitorRules.get(0);
////
////
////            if(keyPrefix){
////                para.setKey("executeTime-"+ruleId);
////            }else{
////                para.setKey(ruleId);
////            }
////
////            para.setDataType("string");
////            para.setCategory("period");
////            para.setDisplayType("PERIODIC");
////            para.setFormat("rule;yyyyMMdd HH:mm;switch");
////            para.setDefaultValue("D;20210801 12:00;true");
////            para.setRequired(true);
////            para.setReadOnly(false);
////            para.setIsExecute(true);
////            para.setExtendData(ruleId);
////            para.setName(monitorRule.getName());
////            para.setDescription(monitorRule.getDescription());
////            para.setLang(monitorRule.getLang());
////            if (monitorRule.getExecutable() == null) {
////                para.setExecutable(1);//默认打开立即执行按钮
////            } else {
////                para.setExecutable(monitorRule.getExecutable());
////            }
////            if (StringUtils.isEmpty(monitorRule.getPeriodEnable())) {
////                para.setPeriodEnable("M;W;D;H;F");//默认打开所有周期级别
////            } else {
////                para.setPeriodEnable(monitorRule.getPeriodEnable());
////            }
////            setEoc(para, ruleId);
////        }
////
////        return para;
        return this.createMonitorRuleParam(ruleId, keyPrefix, null);
    }

    public FieldDescription createMonitorRuleParam(String ruleId, boolean keyPrefix, Map<String, VariableDefinition> variableDefinitionsMap) throws DWBusinessException {
        //交付设计器暂不考虑个案场景 获取个案新增侦测
//        List<MonitorRule> monitorRules = this.monitorRuleRepository.getAddedCustomByCode(ruleId, "tenantId");
//        if (monitorRules == null || monitorRules.isEmpty()) {//不存在个案新增侦测
//            monitorRules = this.monitorRuleRepository.findByCodeAndVersion(ruleId);//获取标准侦测
//        }
        String tenantId = ServiceUtils.getTenantId();
        String tenantVersion = kmService.tenantVersion();
        FieldDescription para = new FieldDescription();

        List<MonitorRule> monitorRules = dataPickService.excludeWithSameCode(monitorRuleRepository.findByCodeAndVersion(ruleId, tenantVersion));//获取标准侦测
        boolean ucRemoved = filterUc(monitorRules,tenantId);
        if (monitorRules == null || monitorRules.size() == 0) {
            if (ucRemoved) {
                return null;
            }
            throw new DWBusinessException("P.KG.500.0030", I18nUtils.getValue("knowledgegraph.monitorNotFound", ruleId));
        }
        MonitorRule monitorRule = monitorRules.get(0);

        if (keyPrefix) {
            para.setKey("executeTime-" + ruleId);
        } else {
            para.setKey(ruleId);
        }
        para.setDataType("string");
        para.setCategory("period");
        para.setDisplayType("PERIODIC");
        para.setFormat("rule;yyyyMMdd HH:mm;switch");
        para.setDefaultValue("D;20210801 12:00;true");
        para.setRequired(true);
        para.setReadOnly(false);
        para.setIsExecute(true);
        para.setIsDesignerSet(monitorRule.getIsDesignerSet());
        para.setExtendData(ruleId);
        para.setName(monitorRule.getName());
        para.setDescription(monitorRule.getDescription());
        para.setLang(monitorRule.getLang());
        if (monitorRule.getExecutable() == null) {
            para.setExecutable(1);//默认打开立即执行按钮
        } else {
            para.setExecutable(monitorRule.getExecutable());
        }
        if (StringUtils.isEmpty(monitorRule.getPeriodEnable())) {
            para.setPeriodEnable("M;W;D;H;F;fixInterval");//默认打开所有周期级别
        } else {
            para.setPeriodEnable(monitorRule.getPeriodEnable());
        }
        setEoc(para, ruleId);
        //增加针对实时类型的侦测类型进行默认显示的样式控制
        Query query = Query.query(Criteria.where("category").is(monitorRule.getCategory()));
        InitMonitorRuleGroup initMonitorRuleGroup = mongoTemplate.findOne(query, InitMonitorRuleGroup.class);
        if (!Objects.isNull(initMonitorRuleGroup)) {
            para.setFormat(initMonitorRuleGroup.getFormat());
            para.setDefaultValue(initMonitorRuleGroup.getDefaultValue());
            para.setExecutable(initMonitorRuleGroup.getExecutable());//默认打开立即执行按钮
        }
        // 去variableDefinition表中查找侦测规则code对应的参数信息
        handleParaFromVariD(ruleId, tenantVersion, para, variableDefinitionsMap);

        return para;
    }


    private boolean filterUc(List<MonitorRule> activities, String tenantId) {
        boolean removed = false;
        Iterator<MonitorRule> activityIterator = activities.iterator();
        List<String> ucCodes = new ArrayList<>();
        while (activityIterator.hasNext()) {
            MonitorRule activity = activityIterator.next();
            if (null != activity.getInclusionTenant()) {
                if (!activity.getInclusionTenant().contains(tenantId)) {
                    activityIterator.remove();
                    removed = true;
                } else {
                    if (activity.getCode().startsWith("UC_")) {
                        ucCodes.add(activity.getCode().replace("UC_", ""));
                    }
                }
            }
        }
//        Iterator<Activity> activityIterator2 = activities.iterator();
//        while (activityIterator2.hasNext()){
//            Activity activity  = activityIterator2.next();
//            if(ucCodes.contains(activity.getCode())){
//                activityIterator2.remove();
//            }
//        }

        return removed;
    }

    // 在variableDefinition表中查找变量code/侦测规则code对应的参数信息，如果有值则覆盖初始值
    private FieldDescription handleParaFromVariD(String code, String tenantVersion, FieldDescription para) throws DWBusinessException {
        return this.handleParaFromVariD(code, tenantVersion, para, null);
//        Query query = new Query();
//        Criteria criteria = Criteria.where("code").in(code).and("version").is(tenantVersion);
//        query.addCriteria(criteria);
//        VariableDefinition def = this.mongoTemplate.findOne(query, VariableDefinition.class);
//        if (def != null) {
//            if (StringUtils.isNotEmpty(def.getName())) {
//                para.setName(def.getName());
//            }
//            if (StringUtils.isNotEmpty(def.getDescription())) {
//                para.setDescription(def.getDescription());
//            }
//            if (StringUtils.isNotEmpty(def.getDataType())) {
//                para.setDataType(def.getDataType());
//            }
//            if (!ObjectUtils.isEmpty(def.getDefaultValue())) {
//                para.setDefaultValue(def.getDefaultValue());
//            }
//            if (def.getIsOperation() != null) {
//                para.setIsOperation(def.getIsOperation());
//            }
//            if (def.getEocLevel() != null && !def.getEocLevel().isEmpty()) {
//                para.setEocLevel(def.getEocLevel());
//            }
//            if (StringUtils.isNotEmpty(def.getExtendData())) {
//                para.setExtendData(def.getExtendData());
//            }
//            if (StringUtils.isNotEmpty(def.getDisplayType())) {
//                para.setDisplayType(def.getDisplayType());
//            }
//            if (StringUtils.isNotEmpty(def.getDisplayFormat())) {
//                para.setDisplayFormat(def.getDisplayFormat());
//            }
//            if (!ObjectUtils.isEmpty(def.getValueDisplay())) {
//                para.setValueDisplay(def.getValueDisplay());
//            }
//            if (def.getIsSimulation() != null) {
//                para.setIsSimulation(def.getIsSimulation());
//            }
//            if (def.getIsExecute() != null) {
//                para.setIsExecute(def.getIsExecute());
//            }
//            if (StringUtils.isNotEmpty(def.getExecuteName())) {
//                para.setExecuteName(def.getExecuteName());
//            }
//            if (def.getReadOnly() != null) {
//                para.setReadOnly(def.getReadOnly());
//            }
//            if (def.getRequired() != null) {
//                para.setRequired(def.getRequired());
//            }
//            if (StringUtils.isNotEmpty(def.getPeriodEnable())) {
//                para.setPeriodEnable(def.getPeriodEnable());
//            }
//            if (def.getExecutable() != null) {
//                para.setExecutable(def.getExecutable());
//            }
//            if (def.getSequence() != null) {
//                para.setSequence(def.getSequence());
//            }
//            if (StringUtils.isNotEmpty(def.getValidateScript())) {
//                para.setValidateScript(def.getValidateScript());
//            }
//            if (!ObjectUtils.isEmpty(def.getOptions())) {
//                para.setOptions(def.getOptions());
//            }
//            if (def.getParamVisble() != null && !def.getParamVisble().isEmpty()) {
//                para.setParamVisble(def.getParamVisble());
//            }
//            if (def.getParamVisbleScope() != null && !def.getParamVisbleScope().isEmpty()) {
//                para.setParamVisbleScope(def.getParamVisbleScope());
//            }
//            if (def.getColspan() != null) {
//                para.setColspan(def.getColspan());
//            }
//            if (!ObjectUtils.isEmpty(def.getDynamicCondition())) {
//                para.setDynamicCondition(def.getDynamicCondition());
//            }
//            if (!ObjectUtils.isEmpty(def.getFieldMappings())) {
//                para.setFieldMappings(def.getFieldMappings());
//            }
//            if (StringUtils.isNotEmpty(def.getMechanismCode())) {
//                para.setMechanismCode(def.getMechanismCode());
//            }
//            if (StringUtils.isNotEmpty(def.getCategory())) {
//                para.setCategory(def.getCategory());
//            }
//            if (StringUtils.isNotEmpty(def.getGroup())) {
//                para.setGroup(def.getGroup());
//            }
//            if (def.getLang() != null && !def.getLang().isEmpty()) {
//                para.setLang(def.getLang());
//            }
//            if (!ObjectUtils.isEmpty(def.getVisibleCondition())) {
//                para.setVisibleCondition(def.getVisibleCondition());
//            }
//            if (def.getFieldOpenWindowMap() != null && !def.getFieldOpenWindowMap().isEmpty()){
//                para.setFieldOpenWindowMap(def.getFieldOpenWindowMap());
//            }
//            if (!ObjectUtils.isEmpty(def.getDisplayTypeDefinition())) {
//                para.setDisplayTypeDefinition(def.getDisplayTypeDefinition());
//            }
//            if (!ObjectUtils.isEmpty(def.getForceOpen())) {
//                para.setForceOpen(def.getForceOpen());
//            }
//            if (!ObjectUtils.isEmpty(def.getValue())) {
//                para.setValue(def.getValue());
//            }
//            if (StringUtils.isNotEmpty(def.getFrom())) {
//                para.setFrom(def.getFrom());
//            }
//            if (StringUtils.isNotEmpty(def.getTarget())) {
//                para.setTarget(def.getTarget());
//            }
//            if (StringUtils.isNotEmpty(def.getFormat())) {
//                para.setFormat(def.getFormat());
//            }
//            return para;
//        }else{
//           return null;
//        }
    }

    private FieldDescription handleParaFromVariD(String code, String tenantVersion, FieldDescription para, Map<String, VariableDefinition> variableDefinitionsMap) throws DWBusinessException {
        VariableDefinition def = null;
        if (variableDefinitionsMap == null || !variableDefinitionsMap.containsKey(code)) {
            Query query = new Query();
            Criteria criteria = Criteria.where("code").in(code);
            query.addCriteria(criteria);
            def = dataPickService.findOneByCondition(criteria, VariableDefinition.class, "variableDefinition");
        } else {
            def = variableDefinitionsMap.get(code);
        }

        if (def != null) {
            if (StringUtils.isNotEmpty(def.getApplication())) {
                Application application = getApplicationByCode(def.getApplication());
                // 悬停，只需要个案的
                if (Boolean.TRUE.equals(application.getIndividualAll()) && "SYSTEM".equals(def.getTenantId())) {
                    return null;
                }
            }
            // 把应用 code 放到上下文中，在调用 esp 的地方，透传过去
            LoginInfo loginInfo = DataMapFilter.getLoginInfo();
            if (Objects.nonNull(loginInfo) && StringUtils.isNotEmpty(def.getApplication())) {
                loginInfo.setApplication(def.getApplication());
            }
            if (StringUtils.isNotEmpty(def.getName())) {
                para.setName(def.getName());
            }
            if (StringUtils.isNotEmpty(def.getDescription())) {
                para.setDescription(def.getDescription());
            }
            if (StringUtils.isNotEmpty(def.getDataType())) {
                para.setDataType(def.getDataType());
            }
            if (!ObjectUtils.isEmpty(def.getDefaultValue())) {
                para.setDefaultValue(def.getDefaultValue());
            }
            if (def.getIsOperation() != null) {
                para.setIsOperation(def.getIsOperation());
            }
            if (def.getEocLevel() != null && !def.getEocLevel().isEmpty()) {
                para.setEocLevel(def.getEocLevel());
            }
            if (StringUtils.isNotEmpty(def.getExtendData())) {
                para.setExtendData(def.getExtendData());
            }
            if (StringUtils.isNotEmpty(def.getDisplayType())) {
                para.setDisplayType(def.getDisplayType());
            }
            if (StringUtils.isNotEmpty(def.getDisplayFormat())) {
                para.setDisplayFormat(def.getDisplayFormat());
            }
            if (!ObjectUtils.isEmpty(def.getValueDisplay())) {
                para.setValueDisplay(def.getValueDisplay());
            }
            if (def.getIsSimulation() != null) {
                para.setIsSimulation(def.getIsSimulation());
            }
            if (def.getIsExecute() != null) {
                para.setIsExecute(def.getIsExecute());
            }
            if (StringUtils.isNotEmpty(def.getExecuteName())) {
                para.setExecuteName(def.getExecuteName());
            }
            if (def.getReadOnly() != null) {
                para.setReadOnly(def.getReadOnly());
            }
            if (def.getRequired() != null) {
                para.setRequired(def.getRequired());
            }
            if (StringUtils.isNotEmpty(def.getPeriodEnable())) {
                para.setPeriodEnable(def.getPeriodEnable());
            }
            if (def.getExecutable() != null) {
                para.setExecutable(def.getExecutable());
            }
            if (def.getSequence() != null) {
                para.setSequence(def.getSequence());
            }
            if (StringUtils.isNotEmpty(def.getValidateScript())) {
                para.setValidateScript(def.getValidateScript());
            }
            if (!Objects.isNull(def.getSelectVariableOptionSetting())) {
                para.setOptions(getOptionsFromApi(def.getSelectVariableOptionSetting()));
            } else if (!ObjectUtils.isEmpty(def.getOptions())) {
                para.setOptions(def.getOptions());
            }
            if (def.getParamVisble() != null && !def.getParamVisble().isEmpty()) {
                para.setParamVisble(def.getParamVisble());
            }
            if (def.getParamVisbleScope() != null && !def.getParamVisbleScope().isEmpty()) {
                para.setParamVisbleScope(def.getParamVisbleScope());
            }
            if (def.getParamDisable() != null && !def.getParamDisable().isEmpty()) {
                para.setParamDisable(def.getParamDisable());
            }
            if (def.getParamDisableScope() != null && !def.getParamDisableScope().isEmpty()) {
                para.setParamDisableScope(def.getParamDisableScope());
            }
            if (def.getColspan() != null) {
                para.setColspan(def.getColspan());
            }
            if (!ObjectUtils.isEmpty(def.getDynamicCondition())) {
                para.setDynamicCondition(def.getDynamicCondition());
            }
            if (!ObjectUtils.isEmpty(def.getFieldMappings())) {
                para.setFieldMappings(def.getFieldMappings());
            }
            if (StringUtils.isNotEmpty(def.getMechanismCode())) {
                para.setMechanismCode(def.getMechanismCode());
            }
            if (StringUtils.isNotEmpty(def.getCategory())) {
                para.setCategory(def.getCategory());
            }
            if (StringUtils.isNotEmpty(def.getGroup())) {
                para.setGroup(def.getGroup());
            }
            if (def.getLang() != null && !def.getLang().isEmpty()) {
                para.setLang(def.getLang());
            }
            if (!ObjectUtils.isEmpty(def.getVisibleCondition())) {
                para.setVisibleCondition(def.getVisibleCondition());
            }
            if (def.getFieldOpenWindowMap() != null && !def.getFieldOpenWindowMap().isEmpty()) {
                para.setFieldOpenWindowMap(def.getFieldOpenWindowMap());
            }
            if (!ObjectUtils.isEmpty(def.getDisplayTypeDefinition())) {
                para.setDisplayTypeDefinition(def.getDisplayTypeDefinition());
            }
            if (!ObjectUtils.isEmpty(def.getForceOpen())) {
                para.setForceOpen(def.getForceOpen());
            }
            if (!ObjectUtils.isEmpty(def.getValue())) {
                para.setValue(def.getValue());
            }
            if (StringUtils.isNotEmpty(def.getFrom())) {
                para.setFrom(def.getFrom());
            }
            if (StringUtils.isNotEmpty(def.getTarget())) {
                para.setTarget(def.getTarget());
            }
            if (StringUtils.isNotEmpty(def.getFormat())) {
                para.setFormat(def.getFormat());
            }
            if (!ObjectUtils.isEmpty(def.getMax())) {
                para.setMax(def.getMax());
            }
            if (!ObjectUtils.isEmpty(def.getMin())) {
                para.setMin(def.getMin());
            }
            if (!ObjectUtils.isEmpty(def.getStep())) {
                para.setStep(def.getStep());
            }
            if (!ObjectUtils.isEmpty(def.getLinkKey())) {
                para.setLinkKey(def.getLinkKey());
            }
            if (!ObjectUtils.isEmpty(def.getLinkOptions())) {
                para.setLinkOptions(def.getLinkOptions());
            }
            if (StringUtils.isNotEmpty(def.getPrecision())) {
                para.setPrecision(def.getPrecision());
            }
            if (!ObjectUtils.isEmpty(def.getRestrictions())) {
                para.setRestrictions(def.getRestrictions());
            }
            if (!ObjectUtils.isEmpty(def.getFilters())) {
                para.setFilters(def.getFilters());
            }
            if (!ObjectUtils.isEmpty(def.getIsSingleOperation())) {
                para.setIsSingleOperation(def.getIsSingleOperation());
            }
            if (!ObjectUtils.isEmpty(def.getOpenWindowTip())) {
                para.setOpenWindowTip(def.getOpenWindowTip());
            }
            para.setValueComputed(MapUtils.isNotEmpty(def.getValueComputed()) ? def.getValueComputed() : null);
            para.setIsTop(Optional.ofNullable(def.getIsTop()).orElse(false));
            para.setLinkageParamEvent(def.getLinkageParamEvent());
            return para;
        } else {
            return null;
        }
    }

    /**
     * 下拉控件选项从api获取
     *
     * @param setting 下拉控件选项配置
     * @return 下拉控件选项数据
     * @throws DWBusinessException 业务异常
     */
    private Object getOptionsFromApi(SelectVariableOptionSetting setting) throws DWBusinessException {
        if ("ESP".equalsIgnoreCase(setting.getOptionApiType())) {
            try {
                Map<String, Object> result = datamapEspUtils.execute(AthenaUtils.getHeaderToken(), ServiceUtils.getTenantId(), setting.getOptionApi(), Optional.ofNullable(setting.getOptionApiParams()).orElse(Collections.emptyMap()));
                Map<String, Object> config = setting.getConfig();
                String label = MapUtils.getString(config, "label");
                String value = MapUtils.getString(config, "value");
                String dataKey = MapUtils.getString(config, "dataKey");
                Object data = result.get(dataKey);
                if (!(data instanceof List)) {
                    return Collections.emptyList();
                }
                JSONArray optionData = (JSONArray) data;
                if (CollectionUtils.isEmpty(optionData)) {
                    return Collections.emptyList();
                }
                List<Object> collect = optionData.stream().map(o -> {
                    JSONObject jsonObject = (JSONObject) o;
                    return new JSONObject().fluentPut("label", jsonObject.get(label)).fluentPut("value", jsonObject.get(value));
                }).collect(Collectors.toList());
                String translateStr = dataMapTranslateUtils.translateContent(collect);
                return JSONArray.parseArray(translateStr);
            } catch (Exception e) {
                log.info("查询下拉控件选项列表出错：{}", e.getMessage());
                throw new DWBusinessException(e.getMessage());
            }
        }
        return null;
    }


    private void setEoc(FieldDescription para, String ruleId) throws DWBusinessException {
        String tenantId = ServiceUtils.getTenantId();
        String tenantVersion = kmService.tenantVersion();
        //根据ruleId获取是否存在eocLevel 没有获取到 则为不区分运营单元
        Criteria criteria = Criteria.where("monitorRuleId").in(ruleId)
                .and("version").is(tenantVersion);
        List<MonitorRuleProductConfig> configs = dataPickService.find(criteria, MonitorRuleProductConfig.class, "monitorRuleProductConfig");
        if (configs != null && !configs.isEmpty()) {
            boolean isOperation = false;
            Map eoc = new HashMap<>();
            for (MonitorRuleProductConfig c : configs) {
                if (StringUtils.isNotEmpty(c.getEocLevel())) {
                    eoc.put(c.getProductName(), c.getEocLevel());
                    isOperation = true;
                }
            }
            if (isOperation) {
                para.setEocLevel(eoc);
                para.setIsOperation(true);
            }
        }
    }

    @Override
    public Object postList(Set<String> applicationCodeList) throws Exception {
        Criteria criteria = Criteria.where("code").in(applicationCodeList);
        List<Application> applications = dataPickService.find(criteria, Application.class, "application");
        if (CollectionUtils.isNotEmpty(applications)) {
            for (Application app : applications) {
                //从applicationRelation获取侦测规则
                processMonitorRule(app);
                //从applicationRelation获取变量
                processVariable(app);
                //按sequence排序
                if (CollectionUtils.isNotEmpty(app.getParamDescription())) {
                    app.getParamDescription().sort((o1, o2) -> o1.getSequence().compareTo(o2.getSequence()));
                }
            }
        }

        return applications;
    }

    @Override
    public Object postByNameAndTags(ApplicationRelationQueryDTO queryDTO) throws Exception {
        String tenantId = ServiceUtils.getTenantId();
        String tenantVersion = kmService.tenantVersion();
        Query query = new Query();
        Criteria criteria = null;
        if (StringUtils.isNotEmpty(queryDTO.getApplicationName())) {
            criteria = Criteria.where("name").regex(".*?\\" + queryDTO.getApplicationName() + ".*");
        }
        if (CollectionUtils.isNotEmpty(queryDTO.getTags())) {
            if (criteria != null) {
                criteria = criteria.and("tags.key").in(queryDTO.getTags());
            } else {
                criteria = Criteria.where("tags.key").in(queryDTO.getTags());
            }
        }
        if (criteria != null) {
            criteria = criteria.and("version").is(tenantVersion);
            query.addCriteria(criteria);
        } else {
            query.addCriteria(Criteria.where("version").is(tenantVersion));
        }
        query.with(Sort.by(Sort.Order.desc("editDate")));
        List<Application> applications = this.mongoTemplate.find(query, Application.class);
        return dataPickService.excludeWithSameCode(applications);
    }


    @Override
    public Application getApplicationInfo(String code) throws DWBusinessException {
        Application application = dataPickService.findOneByCondition(Criteria.where("code").is(code), Application.class, "application");
        if (application != null) {
            //获取语言别
            Locale locale = DWResourceBundleUtils.getCurrentLocale();
            String localeStr = locale.toString();
            if (application.getLang() != null && !application.getLang().isEmpty()) {//设置多语言
                for (Map.Entry<String, Map<String, String>> i : application.getLang().entrySet()) {
                    Map<String, String> lang = i.getValue();
                    if (lang != null && !lang.isEmpty()) {
                        if (lang.containsKey(localeStr)) {
                            try {
                                Field field = Application.class.getDeclaredField(i.getKey());
                                field.setAccessible(true);
                                field.set(application, lang.get(localeStr));
                            } catch (NoSuchFieldException ex) {//允许因配置错误找不到对应的字段设置
                            } catch (IllegalAccessException ex) {//允许因配置错误设置对应的字段异常
                            } catch (Exception ex) {
                                throw ex;
                            }
                        }
                    }
                }
            }
        }

        return application;
    }

    @Override
    public List<String> getTaskCode(String appCode) throws DWBusinessException {
        List<String> codes = new ArrayList<>();
        List<String> appCodes = dataMapTenantService.getAppCodes();
        if (!appCodes.contains(appCode)) {
            return codes;
        }
        List<ApplicationRelation> relations = dataPickService.applicationRelations(appCode, "task", null, null, null);
        relations.forEach(r -> codes.add(r.getCode()));
        return codes;
    }

    @Override
    public List<String> getMechanismCode(String appCode) throws DWBusinessException {
        List<String> codes = new ArrayList<>();
        List<String> appCodes = dataMapTenantService.getAppCodes();
        if (!appCodes.contains(appCode)) {
            return codes;
        }
        List<ApplicationRelation> relations = dataPickService.applicationRelations(appCode, "mechanism", null, null, null);
        relations.forEach(r -> codes.add(r.getCode()));
        return codes;
    }

    @Override
    public List<String> getMonitorRuleCode(String appCode) throws DWBusinessException {
        return getMonitorRuleCode(appCode, null);
    }

    public List<String> getMonitorRuleCode(String appCode, String tenantId) throws DWBusinessException {
        tenantId = StringUtils.isEmpty(tenantId) ? ServiceUtils.getTenantId() : tenantId;
        List<String> codes = new ArrayList<>();
        List<String> appCodes = dataMapTenantService.getAppCodes();
        if (!appCodes.contains(appCode)) {
            return codes;
        }
        List<ApplicationRelation> relations = dataPickService.applicationRelations(appCode, "monitorRule", null, null, null);
        relations.forEach(r -> codes.add(r.getCode()));
        //查找application下配置的侦测
        Application application = getApplicationByCode(appCode);
        if (application == null || application.getParamDescription() == null) {
            return codes;
        }
        for (FieldDescription fieldDescription : application.getParamDescription()) {
            if (StringUtils.equalsIgnoreCase("period", fieldDescription.getCategory())
                    && StringUtils.isNotEmpty(fieldDescription.getExtendData()) && !codes.contains(fieldDescription.getExtendData())) {
                codes.add(fieldDescription.getExtendData());
            }
        }
        return codes;
    }

    public List<String> getMonitorRuleCodeByAppAndVersion(String appCode, String version) throws DWBusinessException {
        List<String> codes = new ArrayList<>();
        List<ApplicationRelation> relations = dataPickService.applicationRelations(appCode, "monitorRule", null, null, version);
        relations.forEach(r -> codes.add(r.getCode()));
        //查找application下配置的侦测
        Application application =getApplicationByCode(appCode);
        if (application == null || application.getParamDescription() == null) {
            return codes;
        }
        for (FieldDescription fieldDescription : application.getParamDescription()) {
            if (StringUtils.equalsIgnoreCase("period", fieldDescription.getCategory())
                    && StringUtils.isNotEmpty(fieldDescription.getExtendData()) && !codes.contains(fieldDescription.getExtendData())) {
                codes.add(fieldDescription.getExtendData());
            }
        }
        return codes;
    }

    public List<String> getMonitorRuleCodeByAppAndVersion(String version) throws DWBusinessException {
        List<String> codes = new ArrayList<>();
        List<MonitorRule> monitorRules = monitorRuleRepository.getCommonByVersion(version);
        if (!org.springframework.util.CollectionUtils.isEmpty(monitorRules)) {
            codes = monitorRules.stream().map(MonitorRule::getCode).collect(Collectors.toList());
        }
        return codes;
    }

    @Override
    public List<ApplicationRelation> postApplicationRelationsByCodesAndType(@RequestBody ApplicationRelationQueryDTO applicationRelationQueryDTO) throws DWBusinessException {
        String tenantId = ServiceUtils.getTenantId();
        String tenantVersion = kmService.tenantVersion();
        List<String> appCodes = dataMapTenantService.getAppCodes();
        if (appCodes.isEmpty()) {
            return new ArrayList<>();
        }
        Criteria criteria = Criteria.where("type").is(applicationRelationQueryDTO.getType())
                .and("code").in(applicationRelationQueryDTO.getCodes())
                .and("version").is(tenantVersion);
        return dataPickService.find(criteria, ApplicationRelation.class, "applicationRelation");
    }

    @Override
    public List<ApplicationRelation> getAppCodeByTaskCode(String code) throws DWBusinessException {
        List<String> appCodes = dataMapTenantService.getAppCodes();
        if (appCodes.isEmpty()) {
            return new ArrayList<>();
        }
        Criteria criteria = Criteria.where("type").is("task")
                .and("code").is(code)
                .and("appCode").in(appCodes);
        List<ApplicationRelation> relations = dataPickService.find(criteria, ApplicationRelation.class, "applicationRelation");

        //获取对应多语言的application name
        proccessAppNameLanguage(relations);

        return relations;
    }

    @Override
    public List<ApplicationRelation> getAppCodeByMechanismCode(String code) throws DWBusinessException {
        List<String> appCodes = dataMapTenantService.getAppCodes();
        if (appCodes.isEmpty()) {
            return new ArrayList<>();
        }
        Criteria criteria = Criteria.where("type").is("mechanism")
                .and("code").is(code)
                .and("appCode").in(appCodes);
        List<ApplicationRelation> relations = dataPickService.find(criteria, ApplicationRelation.class, "applicationRelation");

        //获取对应多语言的application name
        proccessAppNameLanguage(relations);

        return relations;
    }

    @Override
    public List<ApplicationRelation> getAppCodeByMonitorRuleCode(String code) throws DWBusinessException {
        String tenantId = ServiceUtils.getTenantId();
        List<String> appCodes = dataMapTenantService.getAppCodes();
        if (appCodes.isEmpty()) {
            return new ArrayList<>();
        }
        Criteria criteria1 = Criteria.where("type").is("monitorRule")
                .and("code").is(code)
                .and("appCode").in(appCodes);
        List<ApplicationRelation> relations = dataPickService.find(criteria1, ApplicationRelation.class, "applicationRelation");

        //当applicationRelation中没有配置和monitorRule的关系时，查找下Application中直接配置再paramDescription中的数据
        if (CollectionUtils.isEmpty(relations)) {
            Criteria criteria = Criteria.where("paramDescription.extendData").is(code);
            List<Application> applications = dataPickService.find(criteria, Application.class, "application");
            for (Application application : applications) {
                ApplicationRelation applicationRelation = new ApplicationRelation();
                applicationRelation.setAppCode(application.getCode());
                applicationRelation.setAppName(application.getName());
                applicationRelation.setCode(code);
                applicationRelation.setType("monitorRule");
                relations.add(applicationRelation);
            }

        }

        //获取对应多语言的application name
        proccessAppNameLanguage(relations);


        return relations;
    }

    private void proccessAppNameLanguage(List<ApplicationRelation> relations) throws DWBusinessException {
        //使用application中定义的应用名称 处理对应多语言
        if (CollectionUtils.isNotEmpty(relations)) {
            for (ApplicationRelation i : relations) {
                Application app = this.getApplicationInfo(i.getAppCode());
                if (app != null) {
                    i.setAppName(app.getName());
                    Map<String, Map<String, String>> appLang = app.getLang();
                    if (appLang != null) {
                        if (i.getLang() != null) {
                            i.getLang().put("appName", appLang.get("name"));
                        } else {
                            Map<String, Map<String, String>> lang = new HashMap<>();
                            lang.put("appName", appLang.get("name"));
                            i.setLang(lang);
                        }
                    }
                }
            }
        }
    }

    @Override
    public List<ApplicationRelation> postApplicationRelationByCodesAndTenantVersion(ApplicationRelationQueryDTO queryDTO) throws DWBusinessException {
        Criteria criteria = Criteria.where("code").in(queryDTO.getCodes());
        return dataPickService.find(criteria, ApplicationRelation.class, "applicationRelation");
    }

    @Override
    public List<ApplicationRelation> postApplicationRelationByAppCodesAndCodesAndTypeAndSubType(ApplicationRelationQueryDTO queryDTO) throws DWBusinessException {
        Criteria criteria = Criteria.where("code").in(queryDTO.getCodes()).and("appCode").in(queryDTO.getAppCodes());
        if (StringUtils.isNotEmpty(queryDTO.getType())) {
            criteria.and("type").is(queryDTO.getType());
        }
        if (StringUtils.isNotEmpty(queryDTO.getSubType())) {
            criteria.and("subType").is(queryDTO.getSubType());
        }
        return dataPickService.find(criteria, ApplicationRelation.class, "applicationRelation");
    }

    @Override
    public List<ApplicationRelation> postApplicationRelation(List<String> appCodes) throws DWBusinessException {
        return dataPickService.applicationRelations(appCodes, null, null, null, null);
    }

    @Override
    public List<String> getFlowCode(String appCode) throws DWBusinessException {
        List<String> codes = new ArrayList<>();
        List<ApplicationRelation> relations = dataPickService.applicationRelations(appCode, "flow", null, null, null);
        relations.forEach(r -> codes.add(r.getCode()));
        return codes;
    }

    @Override
    public List<ApplicationRelation> getAppCodeByFlowCode(String code) throws DWBusinessException {
        Criteria criteria = Criteria.where("type").is("flow").and("code").is(code);
        return dataPickService.find(criteria, ApplicationRelation.class, "applicationRelation");
    }

    @Override
    public List<String> getVariableCode(String appCode) throws DWBusinessException {
        List<String> re = new ArrayList<>();
        List<String> appCodes = dataMapTenantService.getAppCodes();
        if (!appCodes.contains(appCode)) {
            return re;
        }
        List<ApplicationRelation> relations = dataPickService.applicationRelations(appCode, "variable", null, null, null);
        relations.forEach(r -> re.add(r.getCode()));
        return re;
    }

    /**
     * getAllAppCode()这个方法不要关联版本信息，仅仅是租户初始化时获取系统有哪些应用code的方法，如果想要有版本信息，请另写方法
     */
    @Override
    public List<String> getAllAppCode() throws DWBusinessException {
//        String tenantId = ServiceUtils.getTenantId();
//        String tenantVersion = tenantService.getTenantVersion(tenantId);
        Query query = new Query();
        query.fields().include("code");
//        Criteria criteria = Criteria.where("version").is(tenantVersion);
//        query.addCriteria(criteria);
        List<Application> app = this.mongoTemplate.find(query, Application.class);
        return app.stream().map(Application::getCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    @Override
    public List<String> getNotCommonAppCode() throws DWBusinessException {
//        String tenantId = ServiceUtils.getTenantId();
//        String tenantVersion = tenantService.getTenantVersion(tenantId);
        Query query = new Query();
        query.fields().include("code");
//        Criteria criteria = Criteria.where("version").is(tenantVersion);
//        query.addCriteria(criteria);
        List<Application> app = this.mongoTemplate.find(query, Application.class);
        List<String> collect = app.stream().filter(item -> null == item.getCommonApp() || false == item.getCommonApp()).map(Application::getCode).distinct().collect(Collectors.toList());
        return collect;
    }



    @Override
    public List<ApplicationRelation> getAppCodeByTypeAndCode(String type, String code) throws Exception {
        ApplicationRelationQueryDTO queryDTO = ApplicationRelationQueryDTO.builder().type(type).codes(Collections.singletonList(code)).build();
        List<ApplicationRelation> applicationRelationList = postApplicationByTypeAndSubTypeAndCodeList(queryDTO);

        if (CollectionUtils.isEmpty(applicationRelationList)) {
            return applicationRelationList;
        }
        //从application获取应用名称
        List<Application> all = this.mongoTemplate.findAll(Application.class);
        Map<String, Application> collect = dataPickService.excludeWithSameCode(all).stream().collect(Collectors.toMap(Application::getCode, Function.identity(), (a, b) -> a));
        applicationRelationList.forEach(e -> {
            Application application = collect.get(e.getAppCode());
            if (application != null && application.getLang() != null && application.getLang().containsKey("name")) {
                e.setAppName(application.getName());
                Map<String, Map<String, String>> lang = e.getLang();
                if (lang == null) {
                    lang = new HashMap<>();
                    e.setLang(lang);
                }
                lang.put("appName", application.getLang().get("name"));

            }
        });

        return applicationRelationList;
    }

    @Override
    public List<ApplicationRelation> getParadigmByTypeAndAppCode(String type, String appCode) throws Exception {
        List<ApplicationRelation> applicationRelationList = dataPickService.applicationRelations(appCode, type, null, null, null);
        return CollectionUtils.isEmpty(applicationRelationList) ? new ArrayList<>() : applicationRelationList;
    }

    /**
     * 通过参数的开窗条件列名称查找开窗信息
     */
    @Override
    public Map<String, Map<String, OpenWindowDefinition>> postOpenWinInfo(Map<String, Map<String, String>> openWin) throws DWBusinessException {
        Map<String, Map<String, OpenWindowDefinition>> result = new HashMap<>();
        for (Map.Entry<String, Map<String, String>> entry0 : openWin.entrySet()) {
            Map<String, OpenWindowDefinition> openWindowInfo = new HashMap<>();
            if (entry0.getValue() != null) {
                for (Map.Entry<String, String> entry1 : entry0.getValue().entrySet()) {
                    OpenWindowDefinition openWindowDefinition = dataPickService.findOneByCondition(Criteria.where("key").is(entry1.getValue()), OpenWindowDefinition.class, "openWindowDefinition");
                    openWindowInfo.put(entry1.getKey(), openWindowDefinition);
                }
            }
            result.put(entry0.getKey(), openWindowInfo);
        }
        return result;
    }

    @Override
    public String getAppCodeByApplication(String application) throws Exception {
        List<ApplicationRelation> applicationRelationList = dataPickService.applicationRelations(Collections.singletonList(application), null, null, null, null);
        return CollectionUtils.isEmpty(applicationRelationList) ? null : applicationRelationList.get(0).getAppCode();
    }

    public Map<String, String> getAppCodeByApplication() throws DWBusinessException {
        Criteria criteria = new Criteria();
        List<ApplicationRelation> applicationRelationList = dataPickService.find(criteria, ApplicationRelation.class, "applicationRelation");
        return applicationRelationList.stream().filter(e -> StringUtils.isNotEmpty(e.getApplication()) && StringUtils.isNotEmpty(e.getAppCode()))
                .collect(Collectors.toMap(ApplicationRelation::getApplication, ApplicationRelation::getAppCode, (a, b) -> a));
    }

    public void checkRelatedAppHasExpired(String type, String code) throws DWBusinessException {
        //校验关联的应用是否过期
        List<ApplicationRelation> applicationRelations = this.getApplicationRelationsByTypeAndCodeAndLang(type, code, AthenaUtils.getCurrentLocale());
        List<String> appCodes = this.dataMapTenantService.getAppCodes();
        List<ApplicationRelation> collect = applicationRelations.stream().filter(e -> !appCodes.contains(e.getAppCode())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collect) && collect.size() == applicationRelations.size()) {
            throw new DWBusinessException(Constants.RELATED_APP_EXPIRED, collect.get(0).getAppName());
        }
    }

    @Override
    public List<ApplicationRelation> getApplicationRelationByTypeAndAppCode(String type, String appCode) throws Exception {
        List<ApplicationRelation> applicationRelationList = dataPickService.applicationRelations(appCode, type, null, null, null);
        return CollectionUtils.isEmpty(applicationRelationList) ? new ArrayList<>() : applicationRelationList;
    }

    @Override
    public List<ApplicationRelation> getApplicationRelationByTypeAndAppCodeAndVersion(String type, String appCode, String version) throws Exception {
        return getApplicationRelationByTenantIdAndTypeAndAppCode(null, type, appCode);
    }


    @Override
    public List<ApplicationRelation> postApplicationRelationByTypeAndAppCodes(ApplicationRelationQueryDTO queryDTO) throws Exception {
        List<ApplicationRelation> applicationRelationList = dataPickService.applicationRelations(queryDTO.getAppCodes(), queryDTO.getType(), null, null, null);
        if (CollectionUtils.isEmpty(applicationRelationList)) {
            return new ArrayList<>();
        }
        // 根据应用code查询应用列表
        List<Application> applicationList = knowledgeGraphService.applications(queryDTO.getAppCodes());
        Map<String, Application> applicationMap = applicationList.stream().collect(Collectors.toMap(Application::getCode
                , Function.identity(), (a, b) -> b));
        String locale = ServiceUtils.getLocale();
        for (ApplicationRelation relation : applicationRelationList) {
            String appCode = relation.getAppCode();
            Application application = applicationMap.get(appCode);
            if (application != null && application.getLang() != null) {
                Map nameLangMap = application.getLang().get("name");
                String language = (null == nameLangMap.get(locale)) ? application.getName() : (String) nameLangMap.get(locale);
                relation.setAppName(StringUtils.isEmpty(language) ? relation.getAppName() : language);
            }
        }
        return applicationRelationList;
    }

    @Override
    public List<ApplicationRelation> postQueryApplicationRelationByTypeAndAppCode(ApplicationRelationQueryDTO queryDTO) throws Exception {
        return postApplicationRelationByTypeAndAppCodes(queryDTO);
    }

    @Override
    public List<ApplicationRelation> getApplicationRelationByTenantIdAndTypeAndAppCode(String tenantId, String type, String appCode) throws DWBusinessException {
        List<ApplicationRelation> applicationRelationList = dataPickService.applicationRelations(appCode, type, null, null, null);
        return CollectionUtils.isEmpty(applicationRelationList) ? new ArrayList<>() : applicationRelationList;
    }

    @Override
    public Object postAppRelationUpdate(AppRelationBatchPo request) throws Exception {
        if (Boolean.TRUE.equals(request.getCleanDuplicate())) {
            Map map = new HashMap();
            List<ApplicationRelation> applicationRelations = mongoTemplate.findAll(ApplicationRelation.class);
            applicationRelations = dataPickService.filterApplicationRelations(applicationRelations);
            Set<String> cleaned = new HashSet<>();
            List<ApplicationRelation> newList = new ArrayList<>();
            applicationRelations.forEach(app -> {
                if (newList.contains(app)) {
                    cleaned.add(app.getCode());
                    mongoTemplate.remove(app);
                } else {
                    newList.add(app);
                }
            });
            map.put("codes", cleaned);
            map.put("count", cleaned.size());

            return map;
        }


        List<ApplicationRelation> relations = request.getList();
        if (null == relations) {
            return null;
        }
        List<Pair<Query, Update>> updateList = new ArrayList();

        relations.forEach(data -> {
            Query query = new Query(new Criteria("code").is(data.getCode()).and("type").is(data.getType()).and("appCode").is(data.getAppCode()));
            Update update = new Update();
            update.set("code", data.getCode());
            update.set("type", data.getType());
            update.set("application", data.getApplication());
            update.set("appName", data.getAppName());
            update.set("appCode", data.getAppCode());
            update.set("source", data.getSource());
            update.set("version", data.getVersion());
            update.set("name", data.getName());
            update.set("tenantId", data.getTenantId());
            update.set("sourceLevel", data.getSourceLevel());
            Pair<Query, Update> updatePair = Pair.of(query, update);
            updateList.add(updatePair);
        });
        BulkWriteResult result = mongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, ApplicationRelation.class).upsert(updateList).execute();

        int count = result.getDeletedCount() + result.getModifiedCount();
        return count;
    }


    public List<String> getNeedUserCheckApp(String tenantId) throws DWBusinessException {
        String tenantVersion = "2.0";
        if (StringUtils.isNotEmpty(tenantId)) {
            try {
                tenantVersion = kmService.tenantVersion(tenantId);
            } catch (Exception e) {
                log.error("getNeedUserCheckApp tenantId:{},e:{}", tenantId, e);
            }
        }

        List<String> appCodes = this.dataMapTenantService.getAppCodes();
        Set<String> appCodesSet = appCodes.stream().collect(Collectors.toSet());

//        List<Application> all = this.mongoTemplate.findAll(Application.class);
        Query query = new Query();
        query.fields().include("code").include("feature");
        Criteria criteria = Criteria.where("version").is(tenantVersion).and("code").in(appCodesSet);
        query.addCriteria(criteria);
        List<Application> all = this.mongoTemplate.find(query, Application.class);
        all = dataPickService.excludeWithSameCode(all);
        if (CollectionUtils.isEmpty(all)) {
            return Collections.emptyList();
        }

        List<String> collect = all.stream().filter(e -> appCodesSet.contains(e.getCode()) && this.needNeedUserCheck(e)).map(Application::getCode)
                .distinct().collect(Collectors.toList());
        return collect;

    }

    private boolean needNeedUserCheck(Application application) {
        return application.getFeature() == null
                || application.getFeature().get("userIntegrityCheck") == null
                || Boolean.parseBoolean(String.valueOf(application.getFeature().get("userIntegrityCheck")));

    }

    /**
     * 　* @description: 当DisplayType为复合型时：GROUP，查询所有子组件，并设置到FieldDescription
     * 　* @param [para]
     * 　* @return void
     * 　* @throws
     * 　* @author linc
     * 　* @date 2023/5/10 17:53
     */
    public void setFieldDescriptionValue(FieldDescription para) throws DWBusinessException {
        if ("GROUP".equalsIgnoreCase(para.getDisplayType())) {
            List<FieldDescription> childFieldDescriptions = new ArrayList<>();
            List<String> codeList = (List<String>) para.getDefaultValue();

            for (String code : codeList) {
                FieldDescription childFieldDescription = createVariableParam(code);
                childFieldDescriptions.add(childFieldDescription);
            }
            para.setParameters(childFieldDescriptions);
        }
    }

    @Override
    public List<ApplicationRelation> getApplicationRelationByType(String type) throws Exception {
        Criteria criteria = Criteria.where("type").is(type);
        List<ApplicationRelation> applicationRelationList = dataPickService.find(criteria, ApplicationRelation.class, "applicationRelation");
        return CollectionUtils.isEmpty(applicationRelationList) ? new ArrayList<>() : dataPickService.filterApplicationRelations(applicationRelationList);
    }

    @Override
    public List<ApplicationCustomizedConfig> postConfigByApplicationCustomized() throws DWBusinessException {
        String version = kmService.tenantVersion(null);
        Query query = new Query();
        Criteria criteria = Criteria.where("version").is(version).and("tenantId").in("SYSTEM", ServiceUtils.getTenantId());
        query.addCriteria(criteria);
        return this.mongoTemplate.find(query, ApplicationCustomizedConfig.class);
    }

    @Override
    public List<ApplicationCustomizedConfig> postConfigByGroupApplicationCustomized() throws DWBusinessException {
        String version = kmService.tenantVersion(null);
        Query query = new Query();
        Criteria criteria = Criteria.where("version").is(version).and("tenantId").in("SYSTEM", ServiceUtils.getTenantId());
        query.addCriteria(criteria);
        List<ApplicationCustomizedConfig> configList = this.mongoTemplate.find(query, ApplicationCustomizedConfig.class);
        // name -> tenantId -> appId集合
        Map<String, Map<String, List<String>>> nameTenantIdAppIdListMap = configList.stream()
                .filter(o -> StringUtils.isNotBlank(o.getName()) && StringUtils.isNotBlank(o.getTenantId()))
                .collect(Collectors.groupingBy(
                        ApplicationCustomizedConfig::getName,
                        Collectors.groupingBy(ApplicationCustomizedConfig::getTenantId,
                                Collectors.mapping(ApplicationCustomizedConfig::getAppId, Collectors.toList())))
                );
        // key：name + tenantId，value：第一个配置
        LinkedHashMap<String, ApplicationCustomizedConfig> nameMap = configList.stream()
                .filter(o -> StringUtils.isNotBlank(o.getName()) && StringUtils.isNotBlank(o.getTenantId()))
                .collect(Collectors.toMap(
                        o -> o.getName() + o.getTenantId(),
                        Function.identity(),
                        (existingValue, newValue) -> existingValue,
                        LinkedHashMap::new
                ));
        nameMap.forEach((name, config) -> {
            config.setRelationAppIds(nameTenantIdAppIdListMap.getOrDefault(config.getName(), Collections.emptyMap()).get(config.getTenantId()));
        });
        return Lists.newArrayList(nameMap.values());
    }

    @Override
    public List<Application> postAllApplications() {
        Query query = new Query();
        Criteria criteria = Criteria.where("version").is("2.0");
        query.addCriteria(criteria);
        query.fields().include("code");
        query.fields().include("name");
        query.fields().include("description");
        query.fields().include("lang");
        query.fields().include("version");
        List<Application> applicationList = this.mongoTemplate.find(query, Application.class);
        return CollectionUtils.isEmpty(applicationList) ? Collections.emptyList() : dataPickService.excludeWithSameCode(applicationList);
    }


    @Override
    public Object postApplicationRelationByTypeAndCode(String tenantId, String type, String code) throws DWBusinessException {
        Map<String, String> data = new HashMap<>();
        data.put("code", code);
        data.put("appCode", "");
        Map<String, String> convertType = new HashMap<String, String>();
        convertType.put("project", "task");
        convertType.put("task", "activity");
        convertType.put("monitorRule", "monitorRule");
        String codeType = convertType.get(type);
        try {
            if (StringUtils.isEmpty(codeType) && Objects.equals("action", type)) {
                List<Action> actions = dataPickService.excludeWithSameCode(actionRepository.findByActionId(code));
                if (CollectionUtils.isNotEmpty(actions)) {
                    Optional<Action> actionOptional = actions.stream().filter(list -> Objects.equals(list.getVersion(), "1.0")).findFirst();
                    if (actionOptional.isPresent()) {
                        data.put("appCode", actionOptional.get().getNameSpace());
                    }
                }
            } else if (Objects.equals("monitorRule", type)) {
                List<MonitorRule> monitorRules = dataPickService.excludeWithSameCodeAndFilterTenant(monitorRuleRepository.findByCodeAndVersion(code, "1.0"), tenantId);
                if (CollectionUtils.isNotEmpty(monitorRules)) {
                    Optional<MonitorRule> monitorRuleOptional = monitorRules.stream().filter(list -> Objects.equals(list.getVersion(), "1.0")).findFirst();
                    if (monitorRuleOptional.isPresent()) {
                        data.put("appCode", monitorRuleOptional.get().getNameSpace());
                    }
                }
            } else {
                List<String> codes = Collections.singletonList(code);
                Map<String, Object> profile = new HashMap<>();
                profile.put("tenantId", tenantId);
                DWServiceContext.getContext().setProfile(profile);
                profile.put("tenantId", tenantId);
                ApplicationRelationQueryDTO queryDTO = ApplicationRelationQueryDTO.builder().type(codeType).codes(codes).lang(AthenaUtils.getCurrentLocale()).build();
                Map<String, List<ApplicationRelation>> relationsMap = this.postApplicationRelationsMapByTypeAndCodesAndLang(queryDTO);
                Optional<ApplicationRelation> relations = relationsMap.entrySet().stream()
                        .map(Map.Entry::getValue)
                        .filter(list -> !CollectionUtils.isEmpty(list))
                        .flatMap(List::stream).findFirst();
                if (relations.isPresent()) {
                    data.put("appCode", relations.get().getAppCode());
                }
            }
        } catch (Exception e) {
            log.error("postApplicationRelationByTypeAndCode error:{}", e);
        }
        return data;
    }

    @Override
    public Object postApplicationRelationByDDSM(AppRelationBatchPo request) throws DWBusinessException {
        String version = kmService.tenantVersion(null);
        List<ApplicationRelation> applicationRelations = request.getList();
        String applicationRelationStr = dataMapTranslateUtils.translateContent(applicationRelations);
        applicationRelations = JSONArray.parseArray(applicationRelationStr, ApplicationRelation.class);
        if (CollectionUtils.isNotEmpty(applicationRelations)) {
            for (ApplicationRelation applicationRelation : applicationRelations) {
                Query query = new Query();
                Criteria criteria = Criteria.where("type").is(applicationRelation.getType()).and("code").is(applicationRelation.getCode()).and("appCode").is(applicationRelation.getAppCode()).and("version").is(version);
                query.addCriteria(criteria);
                List<ApplicationRelation> applicationRelationList = this.mongoTemplate.find(query, ApplicationRelation.class);
                if (CollectionUtils.isNotEmpty(applicationRelationList)) {
                    this.mongoTemplate.remove(query, ApplicationRelation.class);
                }
                this.mongoTemplate.save(applicationRelation);
            }
        }
        return "success";
    }

    @Override
    public List<Map<String, String>> postQueryApplicationsNameByCodeList(List<String> codes, Integer appType) throws DWBusinessException {
        Criteria criteria = new Criteria();
        criteria.and("code").in(codes).and("appType").is(appType);
        List<Application> applications = mongoTemplate.find(new Query(criteria), Application.class);

        List<Map<String, String>> result = new ArrayList<>();
        if (CollectionUtils.isEmpty(applications)) {
            return result;
        }
        applications.forEach(app -> {
            Map<String, String> data = new HashMap<>();
            data.put("code", app.getCode());
            data.put("name", app.getName());
            data.put("version", app.getVersion());
            result.add(data);
        });
        return result;
    }

    @Override
    public Application getAppByMechanismCode(String mechanismCode) throws DWBusinessException {
        String tenantId = ServiceUtils.getTenantId();
        String tenantVersion = kmService.tenantVersion();
        List<String> appCodes = dataMapTenantService.getAppCodes();
        if (appCodes.isEmpty()) {
            throw new DWBusinessException(String.format("authorizations Application is empty, mechanismCode: %s, tenantId: %s", mechanismCode, tenantId));
        }
        ApplicationRelation relation = dataPickService.findOneByCondition(Criteria.where("type").is("mechanism")
                .and("code").is(mechanismCode)
                .and("appCode").in(appCodes)
                .and("version").is(tenantVersion), ApplicationRelation.class, "applicationRelation");
        if (relation == null) {
            throw new DWBusinessException("applicationRelation is empty, mechanismCode: " + mechanismCode);
        }
        Criteria criteria = Criteria.where("code").is(relation.getAppCode()).and("version").is(tenantVersion);
        Application application = dataPickService.findOneByCondition(criteria, Application.class, "application");
        if (application == null) {
            throw new DWBusinessException("application is empty, code: " + relation.getAppCode());
        }
        return application;
    }

    @Override
    public Application getAppByActivityId(String activityId) throws DWBusinessException {
        ApplicationRelation relation = dataPickService.findOneByCondition(Criteria.where("code").is(activityId), ApplicationRelation.class, "applicationRelation");
        if (relation == null) {
            throw new DWBusinessException("applicationRelation is empty, activityId: " + activityId);
        }
        Criteria criteria = Criteria.where("code").is(relation.getAppCode());
        Application application = dataPickService.findOneByCondition(criteria, Application.class, "application");
        if (application == null) {
            throw new DWBusinessException("application is empty, code: " + relation.getAppCode());
        }
        return application;
    }

    @Override
    public Object postCheckAppExpire(CheckAppExpirePo po) throws DWBusinessException {
     //   checkRelatedAppHasExpired(po.getType(),po.getCode());
        ApplicationRelation applicationRelation = knowledgeGraphService.relation(po.getCode(),po.getType());
        if(null!=applicationRelation){
            List<String> appCodes = kmService.userAuthApps();
            if(!appCodes.contains(applicationRelation.getAppCode())){
                throw new DWBusinessException(Constants.RELATED_APP_EXPIRED, applicationRelation.getAppName());
            }
        }
        return null;
    }


    public List<String> getActivityCode(String tenantId) throws DWBusinessException {
        List<String> appCodes = dataMapTenantService.getAppCodes();
        Criteria criteria = Criteria.where("type").in("task", "activity")
                .and("appCode").in(appCodes);
        List<ApplicationRelation> relations = dataPickService.find(criteria, ApplicationRelation.class, "applicationRelation");
        return relations.stream().map(s -> s.getCode()).collect(Collectors.toList());
    }
}
