package com.digiwin.athena.datamap.service.impl;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.service.ISetService;
import com.digiwin.athena.datamap.povo.DtdRelatedInfo;
import com.digiwin.athena.domain.core.*;
import com.digiwin.athena.domain.core.flow.FlowGraph;
import com.digiwin.athena.domain.core.view.PageView;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;

/**
 * @title: SetService
 * @description: SetService
 * @author: linc
 * @date 2023/8/18 13:44
 * @version: 1.0
 */
public class SetService implements ISetService {

    @Autowired
    @Qualifier("dataMapSystem")
    private MongoTemplate mongoTemplate;

    @Override
    public Object postSaveDtdRelatedInfo(DtdRelatedInfo dtdRelatedInfo) throws DWBusinessException {
        try {
            if (null != dtdRelatedInfo && StringUtils.isNotEmpty(dtdRelatedInfo.getProject().getPluginId())) {
                deleteDtdRelatedInfo(dtdRelatedInfo.getProject().getPluginId(), dtdRelatedInfo.getVersion());
                saveDtdRelatedInfo(dtdRelatedInfo);
            }
        } catch (Exception e) {
            throw new DWBusinessException(e.toString());
        }
        return null;
    }

    private void saveDtdRelatedInfo(DtdRelatedInfo dtdRelatedInfo) {
        dtdRelatedInfo.getProject().setApplication(dtdRelatedInfo.getAppCode());
        dtdRelatedInfo.getProject().setAthena_namespace(dtdRelatedInfo.getAppCode());
        mongoTemplate.save(dtdRelatedInfo.getProject());
        for (Activity activity : dtdRelatedInfo.getActivityList()) {
            activity.setApplication(dtdRelatedInfo.getAppCode());
            activity.setAthena_namespace(dtdRelatedInfo.getAppCode());
            mongoTemplate.save(activity);
        }
        for (DataState dataState : dtdRelatedInfo.getDataStateList()) {
            dataState.setApplication(dtdRelatedInfo.getAppCode());
            dataState.setAthena_namespace(dtdRelatedInfo.getAppCode());
            mongoTemplate.save(dataState);
        }
        for (FlowGraph flowGraph : dtdRelatedInfo.getFlowGraphList()) {
            flowGraph.setApplication(dtdRelatedInfo.getAppCode());
            flowGraph.setAthena_namespace(dtdRelatedInfo.getAppCode());
            mongoTemplate.save(flowGraph);
        }
        for (PageView pageView : dtdRelatedInfo.getPageViewList()) {
            pageView.setApplication(dtdRelatedInfo.getAppCode());
            pageView.setAthena_namespace(dtdRelatedInfo.getAppCode());
            mongoTemplate.save(pageView);
        }
        for (Task task : dtdRelatedInfo.getTaskList()) {
            task.setApplication(dtdRelatedInfo.getAppCode());
            task.setAthena_namespace(dtdRelatedInfo.getAppCode());
            mongoTemplate.save(task);
        }
        dtdRelatedInfo.getDataDescription().setApplication(dtdRelatedInfo.getAppCode());
        dtdRelatedInfo.getDataDescription().setAthena_namespace(dtdRelatedInfo.getAppCode());
        mongoTemplate.save(dtdRelatedInfo.getDataDescription());
    }

    private void deleteDtdRelatedInfo(String pluginId, String version) {
        Criteria criteria = Criteria.where("tenantId").is("SYSTEM").and("pluginId").is(pluginId);
        if (StringUtils.isNotEmpty(version)) {
            criteria.and("version").is(version);
        }
        Query queryDelete = Query.query(criteria);
        mongoTemplate.remove(queryDelete, DataDescription.class);
        mongoTemplate.remove(queryDelete, DataState.class);
        mongoTemplate.remove(queryDelete, Project.class);
        mongoTemplate.remove(queryDelete, Task.class);
        mongoTemplate.remove(queryDelete, FlowGraph.class);
        mongoTemplate.remove(queryDelete, Activity.class);
        mongoTemplate.remove(queryDelete, PageView.class);
    }
}
