package com.digiwin.athena.datamap.service.inner;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import com.digiwin.athena.domain.common.Constants;
import com.digiwin.athena.domain.common.TenantObject;
import com.digiwin.athena.kmservice.utils.MergeUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * @program: athena2_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2022-03-03 16:51
 **/
@Service
public class SelectService {

    @Autowired
    @Qualifier("dataMapSystem")
    private MongoTemplate mongoTemplate;

    public <T extends TenantObject> T findByEntityId(String entityId, Class<T> c) throws DWBusinessException {
        if (null == entityId || null == c) {
            return null;
        }
        T t = mongoTemplate.findOne(Query.query(Criteria.where("entityId").is(entityId)), c);
        if (null != t) {
            String code = t.getCode();
            String tenantId = ServiceUtils.getTenantId();
            if (null != code && null != tenantId) {
                List<T> ts = mongoTemplate.find(Query.query(Criteria.where("tenantId").is(tenantId).and("code").is(code)), c, "tenant" + c.getSimpleName());
                if (ts.size() > 0) {
                    ts.stream().filter(t1 -> eocMatch(t1)).sorted((t1, t2) -> {
                        int size1 = t1.getEocId() == null ? 0 : t1.getEocId().length();
                        int size2 = t2.getEocId() == null ? 0 : t2.getEocId().length();
                        return size1 - size2;
                    }).forEach(et -> {
                        MergeUtil.mergeObject(et, t);
                    });
                }
            }
        }

        return t;
    }

    // public <T extends TenantObject> List<T> findByEntityIds(List<String> entityIds, Class<T> c) throws DWBusinessException {
    // if(null==entityIds || null==c || entityIds.size()==0){return null;}
    // List<T> ts = mongoTemplate.find(Query.query(Criteria.where("entityId").in(entityIds)),c);
    // if(ts.size()>0){
    // Map<String,T> tsmap= ts.stream().filter(t -> t.getCode()!=null).collect(Collectors.toMap(t -> t.getCode(),t->t));
    // String tenantId = ServiceUtils.getTenantId();
    // if(!ts.isEmpty() && null!=tenantId){
    // List<T> ts2 = mongoTemplate.find(Query.query(Criteria.where("tenantId").is(tenantId).and("code").in(tsmap.keySet())),c);
    // if(ts2.size()>0){
    // ts.stream().filter(t1->eocMatch(t1)).sorted((t1, t2)->{
    // int size1 = t1.getEocId()==null?0:t1.getEocId().length();
    // int size2 = t2.getEocId()==null?0:t2.getEocId().length();
    // return size1-size2;
    // }).forEach(et->{
    // T t = tsmap.get(et.getCode());
    // MergeUtil.mergeObject(et, t);
    // });
    // }
    // }
    // }
    //
    // return ts;
    // }

    /**
    用于查询配置数据,多版本实体慎用
     */

    public List allMatched(Map<String, Object> query, Class c, String col) throws DWBusinessException {

        String tenantId = ServiceUtils.getTenantIdSilent();
        if (null != query.get("tenantId")) {
            tenantId = (String) query.get("tenantId");
            query.remove("tenantId");
        }
        List<String> tenantIds = new ArrayList<>();
        tenantIds.add(tenantId);
        if (!Constants.defaultTenantId.equals(tenantId)) {
            tenantIds.add(Constants.defaultTenantId);
        }
        Query query1 = new Query();
        query1.addCriteria(Criteria.where("tenantId").in(tenantIds));
        query.forEach((k, v) -> {
            if (v instanceof Collection) {
                List list = new ArrayList();
                Collection collection = (Collection) v;
                collection.forEach(ele -> {
                    list.add(ele);
                });
                query1.addCriteria(Criteria.where(k).in(list));
            } else {
                query1.addCriteria(Criteria.where(k).is(v));
            }
        });
        List ts = null;
        if (null == col) {
            ts = mongoTemplate.find(query1, c);
        } else {
            ts = mongoTemplate.find(query1, c, col);
        }
        return ts;
    }

    private <T extends TenantObject> boolean eocMatch(T t) {
        if (t.getEocId() == null || t.getEocId().isEmpty()) {
            return true;
        }
        String eoc = ServiceUtils.getEoc();
        if (null != eoc && eoc.startsWith(t.getEocId())) {
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        Arrays.asList("aa", "a", "sss", "ss", "333", "").stream().sorted((s1, s2) -> s1.length() - s2.length()).forEach(s -> System.out.println(s));
    }

}
