package com.digiwin.athena.datamap.spi;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.datamap.povo.DapResponse;
import com.digiwin.athena.datamap.povo.SmartDataExecutePo;
import com.digiwin.athena.datamap.utils.DataMapUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.Map;

@Service
@Slf4j
public class SmartDataService {

    @Value("${smartDataUrl}")
    private String smartDataUrl;

    public Object engineExecute(SmartDataExecutePo po) {
        Map<String, Object> params = JSON.parseObject(JSON.toJSONString(po));

        DapResponse resp = DataMapUtils.request(smartDataUrl + "/restful/service/ExecutionEngine/execute", "post", params);
        return resp.getResponse();
    }

}
