package com.digiwin.athena.datamap.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.digiwin.app.container.exceptions.DWBusinessException;

import com.digiwin.athena.kmservice.aspect.ExceptionHandlerAspect;
import com.digiwin.athena.kmservice.action.execution.ProductNameResolver;
import com.digiwin.athena.datamap.filter.DataMapFilter;
import com.digiwin.athena.datamap.spi.DataMapIamService;
import com.digiwin.athena.datamap.supports.EspBody;
import com.digiwin.athena.datamap.supports.esp.EspResponse;
import com.digiwin.athena.kmservice.utils.I18nUtils;
import com.digiwin.http.client.DWHttpClient;
import com.google.common.base.Charsets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@Service
@Slf4j
public class DatamapESPUtils {
    private final String OPERATION_LIST = "/restful/standard/mdc/TenantProductOperationList/Get";
    private final String INTG_INFO = "/restful/standard/mdc/IntgInfo/Get";
    private static final String GET_PRODUCT = "/restful/standard/mdc/TenantProductList/Get";
    @Value("${espUrl}")
    private String espDomain;
    @Value("${mdcUrl}")
    private String mdcDomain;
    @Autowired
    private ProductNameResolver productNameResolver;

    @Autowired
    private DWHttpClient dwHttpClient;

    @Autowired
    @Qualifier("simpleRestTemplate")
    RestTemplate restTemplate;

    @Autowired
    private DataMapIamService dataMapIamService;
    @Value("${iamApToken}")
    private String iamApToken;

    public Map getTenantProductOperationList(String tenantId, String productName) throws DWBusinessException, ParseException {
        String url = mdcDomain + OPERATION_LIST;

        //RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
        MediaType type = MediaType.parseMediaType("application/json; charset=UTF-8");
        headers.setContentType(type);
        headers.add("token",StringUtils.isEmpty(AthenaUtils.getHeaderToken())? DataMapFilter.getLoginInfo().getToken():AthenaUtils.getHeaderToken());
        Map<String, Object> requestMap = new HashMap<>();
        requestMap.put("tenant_id", tenantId);
        requestMap.put("prod_name", productName);

        HttpEntity<Map> requestEntity = new HttpEntity<>(requestMap, headers);


        ResponseEntity<Map> result = restTemplate.exchange(url, HttpMethod.POST, requestEntity, Map.class);
        if (result.getStatusCodeValue() == 200) {
            return result.getBody();
        } else {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.getProductError",tenantId,productName));
        }
    }

    public Map<String, Object> execute(String token, String tenantId, String api, Object requestObj) throws Exception {
        String productName = productNameResolver.getProductName(api, tenantId);
        if (StringUtils.isEmpty(productName)) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.invokeEspApiError",tenantId,api));
        }
        String dataJson = JSON.toJSONString(requestObj, SerializerFeature.WriteMapNullValue);
        EspResponse response = ESPInvokeUtil.invokeRestSync(api, productName, token, tenantId, dataJson, null, null);
        if (response.isOK()) {
            EspBody espBody = (EspBody) response.getData();
            Map<String, Object> parameter = espBody.getStd_data().getParameter();
            return parameter;
        } else {
            DWBusinessException dwBusinessException = new DWBusinessException(response.getErrorCode(), I18nUtils.getValue(I18nUtils.getValue("knowledgegraph.invokeEspApiErrorMsg",tenantId,api,response.getMsg())));
            dwBusinessException.getInstructors().put(ExceptionHandlerAspect.CHAIN_INFO, response.getChainInfo());
            throw dwBusinessException;
        }
    }

    public Map<String, Object> query(String token, String tenantId, String queryApi) throws Exception {
        String productName = productNameResolver.getProductName(queryApi, tenantId);
//        String productName = "PWD";
        if (StringUtils.isEmpty(productName)) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.invokeEspApiError",tenantId,queryApi));
        }
        EspResponse response = ESPInvokeUtil.invokeRestSync(queryApi, productName, token, tenantId, null, null, null);
        if (response.isOK()) {
            EspBody espBody = (EspBody) response.getData();
            Map<String, Object> parameter = espBody.getStd_data().getParameter();
            return parameter;
        } else {
            DWBusinessException dwBusinessException = new DWBusinessException(response.getErrorCode(), I18nUtils.getValue("knowledgegraph.invokeEspApiErrorMsg", tenantId, queryApi, response.getMsg()));
            dwBusinessException.getInstructors().put(ExceptionHandlerAspect.CHAIN_INFO, response.getChainInfo());
            throw dwBusinessException;
        }
    }

    public Map<String, Object> getOMOperationInfo(String tenantId, String prodName, String uid) throws DWBusinessException {
        String url = mdcDomain + INTG_INFO;

        //RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
        MediaType type = MediaType.parseMediaType("application/json; charset=UTF-8");
        headers.setContentType(type);
        headers.add("token",StringUtils.isEmpty(AthenaUtils.getHeaderToken())? DataMapFilter.getLoginInfo().getToken():AthenaUtils.getHeaderToken());

        Map<String, Object> requestMap = new HashMap<>();
        requestMap.put("tenant_id", tenantId);
        requestMap.put("prod_name", prodName);
        requestMap.put("uid", uid);

        HttpEntity<Map> requestEntity = new HttpEntity<>(requestMap, headers);

        ResponseEntity<Map> result = restTemplate.exchange(url, HttpMethod.POST, requestEntity, Map.class);
        if (result.getStatusCodeValue() == 200) {
            return result.getBody();
        } else {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.getProductError2",tenantId));
        }
    }

    public Object getTenantProduct(String tenantId,String apiName)  {
        HttpPost httpPost = new HttpPost(mdcDomain + GET_PRODUCT);

        // 设置headers
        httpPost.setHeader("Content-Type", MediaType.APPLICATION_JSON.toString());

        // 设置请求体
        JSONObject requestBody = new JSONObject();
        requestBody.put("tenant_id", tenantId);
        requestBody.put("api_name", apiName);
        StringEntity requestEntity = new StringEntity(requestBody.toString(),
                ContentType.create("application/json", Charsets.UTF_8));
        httpPost.setEntity(requestEntity);

        try{
            // 发送请求
            httpPost.setHeader("token",StringUtils.isEmpty(AthenaUtils.getHeaderToken())? DataMapFilter.getLoginInfo().getToken():AthenaUtils.getHeaderToken());
            HttpResponse response = dwHttpClient.execute(httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == HttpStatus.OK.value()) {
                org.apache.http.HttpEntity entity = response.getEntity();
                if (entity != null) {
                    String responseString = EntityUtils.toString(entity, "UTF-8");
                    JSONObject result = JSON.parseObject(responseString);
                    return result;
                }
            }
        } catch (Exception e) {
            log.error("ESPUtils.getTenantProduct method error:{}",e);
        }
        return null;
    }

    public Object callEspService(Object registerModel, String token, String tenantId, String productName, String serviceName) throws DWBusinessException {
        // 使用集成token
        token = dataMapIamService.getIntegrationToken(tenantId, token);

        // 组装导出模型sql的入参
        // 组装header
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-app", iamApToken);
        headers.add("token", token);
        headers.add("Content-Type", "application/json");
        headers.add("digi-type", "sync");

        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String formatTime = sdf.format(date);

        Map<String, String> headMapDigi_Host = new HashMap<>();
        headMapDigi_Host.put("prod", productName);
//        headMapDigi_Host.put("prod", "Athena");
        headMapDigi_Host.put("ver", "1.0");
        headMapDigi_Host.put("lang", "zh_CN");
        headMapDigi_Host.put("timestamp", formatTime);
        headMapDigi_Host.put("ip", "");
        headMapDigi_Host.put("eoc_acct", "athena");
        headMapDigi_Host.put("acct", "athena");
        headers.add("digi-host", JSON.toJSONString(headMapDigi_Host));

        Map<String, String> headMapDigi_Service = new HashMap<>();
        headMapDigi_Service.put("prod", productName);
        headMapDigi_Service.put("uid", productName);
        headMapDigi_Service.put("tenant_id", tenantId);
        headMapDigi_Service.put("name", serviceName);
        headers.add("digi-service", JSON.toJSONString(headMapDigi_Service));

        // 组装请求体body
        Map<String, Object> requestMap = new HashMap<>();
        Map<String, Object> parameter = new HashMap<>();
        Map<String, Object> model = new HashMap<>();
        model.put("model", registerModel);
        parameter.put("parameter", model);
        requestMap.put("std_data", parameter);

        String fileMD5 = DigestUtils.md5Hex(JSON.toJSONString(headMapDigi_Host) + JSON.toJSONString(headMapDigi_Service));
        headers.add("digi-key", fileMD5);
        log.info("headers" + " headers is ={}", JSON.toJSONString(headers));
        log.info("requestMap is ={}", JSON.toJSONString(requestMap));


        String url = espDomain + "/CROSS/RESTful";
        HttpEntity<Map> requestEntity = new HttpEntity<>(requestMap, headers);
        ResponseEntity<Object> resEntity = restTemplate.exchange(url, HttpMethod.POST, requestEntity, Object.class);
        return resEntity.getBody();
    }


}