package com.digiwin.athena.datamap.actions;

import lombok.Data;

import java.util.HashMap;
import java.util.Map;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2023-02-16 15:06
 **/
@Data
public class ActionResp {

    /**
     * 响应状态，是否成功
     */
    private Boolean success;
    /**
     * 响应数据
     */
    private Object data;
    /**
     * 响应消息
     */
    private String msg;
    /**
     * 扩展数据
     */
    private Map<String, Object> ext = new HashMap<>();

    public static ActionResp of(Boolean r, Object d, String msg) {
        ActionResp resp = new ActionResp();
        resp.setData(d);
        resp.setSuccess(r);
        resp.setMsg(msg);
        return resp;
    }

    public static ActionResp of(Object d) {
        ActionResp resp = new ActionResp();
        resp.setData(d);
        resp.setSuccess(true);
        return resp;
    }

}
